/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.actions;

import java.awt.Component;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import jgnash.engine.DataStoreType;
import jgnash.util.Resource;

public class DatabasePathAction {
    private static String LAST_DIR = "LastDir";

    private DatabasePathAction() {
    }

    public static String databaseNameAction(Component parent, Type type) {
        return DatabasePathAction.databaseNameAction(parent, type, DataStoreType.values());
    }

    public static String databaseNameAction(Component parent, Type type, DataStoreType ... dataStoretype) {
        String[] ext = new String[dataStoretype.length];
        for (int i = 0; i < dataStoretype.length; ++i) {
            ext[i] = dataStoretype[i].getDataStore().getFileExt();
        }
        Resource rb = Resource.get();
        StringBuilder description = new StringBuilder(rb.getString("Label.jGnashFiles") + " (");
        for (int i = 0; i < dataStoretype.length; ++i) {
            description.append("*.");
            description.append(dataStoretype[i].getDataStore().getFileExt());
            if (i >= dataStoretype.length - 1) continue;
            description.append(", ");
        }
        description.append(')');
        Preferences pref = Preferences.userNodeForPackage(DatabasePathAction.class);
        JFileChooser chooser = new JFileChooser(pref.get(LAST_DIR, null));
        chooser.addChoosableFileFilter(new FileNameExtensionFilter(description.toString(), ext));
        chooser.setApproveButtonText(rb.getString("Button.Ok"));
        if (type == Type.OPEN) {
            chooser.setDialogTitle(rb.getString("Title.Open"));
        } else {
            chooser.setDialogTitle(rb.getString("Title.NewFile"));
        }
        if (chooser.showOpenDialog(parent) == 0) {
            pref.put(LAST_DIR, chooser.getCurrentDirectory().getAbsolutePath());
            try {
                return chooser.getSelectedFile().getAbsolutePath();
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().warning(e.toString());
            }
        }
        return "";
    }

    public static enum Type {
        OPEN,
        NEW;

    }
}

