/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import jgnash.ui.components.JTextFieldEx;
import jgnash.ui.components.autocomplete.AutoCompleteModel;
import jgnash.ui.components.autocomplete.DefaultAutoCompleteModel;

public class AutoCompleteTextField
extends JTextFieldEx
implements FocusListener {
    private static final long serialVersionUID = -7122559240136664049L;
    private volatile boolean setText = false;
    private AutoCompleteModel model;

    public AutoCompleteTextField() {
        this(new DefaultAutoCompleteModel());
    }

    public AutoCompleteTextField(AutoCompleteModel model) {
        this.model = model;
        this.addFocusListener(this);
    }

    public AutoCompleteModel getModel() {
        return this.model;
    }

    @Override
    protected Document createDefaultModel() {
        return new AutoCompleteDocument();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        String text = this.getText();
        if (text != null && text.length() > 0) {
            this.setCaretPosition(text.length());
        }
    }

    @Override
    public void setText(String t) {
        this.setText = true;
        super.setText(t);
        this.setText = false;
    }

    protected class AutoCompleteDocument
    extends PlainDocument {
        private static final long serialVersionUID = -1369307873189366733L;
        String currText = null;
        String newText = null;

        protected AutoCompleteDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            super.insertString(offs, str, a);
            if (!AutoCompleteTextField.this.setText) {
                this.currText = this.getText(0, this.getLength());
                this.newText = AutoCompleteTextField.this.model.doLookAhead(this.currText);
                if (this.newText != null) {
                    this.remove(0, this.currText.length());
                    super.insertString(0, new String(this.currText.substring(0, offs + 1)) + new String(this.newText.substring(offs + 1)), a);
                    AutoCompleteTextField.this.setCaretPosition(this.newText.length());
                    AutoCompleteTextField.this.moveCaretPosition(offs + 1);
                }
            }
        }
    }
}

