/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.util.List;
import jgnash.engine.Account;
import jgnash.ui.components.AccountListComboBox;

public class FilteredAccountListComboBox
extends AccountListComboBox {
    private boolean hideLocked;
    private boolean hidePlaceholder;

    public FilteredAccountListComboBox(boolean hideLocked, boolean hidePlaceholder) {
        super(new FilteredModel(null, hideLocked, hidePlaceholder));
        this.hideLocked = hideLocked;
        this.hidePlaceholder = hidePlaceholder;
    }

    public void setHideLocked(boolean value) {
        this.hideLocked = value;
        this.setModel(new FilteredModel(null, this.hideLocked, this.hidePlaceholder));
    }

    public void setHidePlaceholder(boolean value) {
        this.hidePlaceholder = value;
        this.setModel(new FilteredModel(null, this.hideLocked, this.hidePlaceholder));
    }

    private static final class FilteredModel
    extends AccountListComboBox.AbstractModel {
        private static final long serialVersionUID = -6114581770341251372L;
        private boolean hideLocked;
        private boolean hidePlaceholder;

        public FilteredModel(Account exclude, boolean hideLocked, boolean hidePlaceholder) {
            super(exclude);
            this.hideLocked = hideLocked;
            this.hidePlaceholder = hidePlaceholder;
            this.loadAccounts();
        }

        @Override
        protected void loadChildren(Account acc, List<Account> array) {
            for (Account tAcc : acc.getChildren()) {
                if (!(this.hideLocked && tAcc.isLocked() || this.hidePlaceholder && tAcc.isPlaceHolder() || this.baseAccount == tAcc)) {
                    array.add(tAcc);
                }
                if (tAcc.getChildCount() <= 0) continue;
                this.loadChildren(tAcc, array);
            }
        }
    }
}

