/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.option;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jgnash.engine.EngineFactory;
import jgnash.ui.register.AccountBalanceDisplayManager;
import jgnash.ui.register.AccountBalanceDisplayMode;
import jgnash.ui.register.RegisterFactory;
import jgnash.util.Resource;

public class AccountOptions
extends JPanel
implements ActionListener,
FocusListener {
    private final Resource rb = Resource.get();
    private JTextField accountSeparatorField;
    private JCheckBox useAccountTermsCheckBox;
    private JRadioButton noneButton;
    private JRadioButton creditAccountsButton;
    private JRadioButton incomeExpenseAccountsButton;

    public AccountOptions() {
        this.layoutMainPanel();
        this.useAccountTermsCheckBox.setSelected(RegisterFactory.isAccountingTermsEnabled());
        if (AccountBalanceDisplayManager.getDisplayMode().equals((Object)AccountBalanceDisplayMode.NONE)) {
            this.noneButton.setSelected(true);
        } else {
            this.creditAccountsButton.setSelected(true);
        }
        this.accountSeparatorField.addFocusListener(this);
        this.useAccountTermsCheckBox.addActionListener(this);
        this.noneButton.addActionListener(this);
        this.creditAccountsButton.addActionListener(this);
        this.incomeExpenseAccountsButton.addActionListener(this);
    }

    private void initComponents() {
        this.accountSeparatorField = new JTextField(EngineFactory.getEngine("default").getAccountSeparator());
        this.useAccountTermsCheckBox = new JCheckBox(this.rb.getString("Button.AccTerms"));
        this.noneButton = new JRadioButton(this.rb.getString("Button.None"));
        this.noneButton.setToolTipText(this.rb.getString("ToolTip.ReversedSignNone"));
        this.creditAccountsButton = new JRadioButton(this.rb.getString("Button.CreditAccounts"));
        this.creditAccountsButton.setToolTipText(this.rb.getString("ToolTip.ReversedCredit"));
        this.incomeExpenseAccountsButton = new JRadioButton(this.rb.getString("Button.IncomeAndExpense"));
        this.incomeExpenseAccountsButton.setToolTipText(this.rb.getString("ToolTip.ReversedIncomeExpense"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.noneButton);
        group.add(this.creditAccountsButton);
        group.add(this.incomeExpenseAccountsButton);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("right:p, $lcgap, max(75dlu;p):g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.appendSeparator(this.rb.getString("Title.Display"));
        builder.append(this.rb.getString("Label.AccountSeparator"), (Component)this.accountSeparatorField);
        builder.appendSeparator(this.rb.getString("Title.Terms"));
        builder.append((Component)this.useAccountTermsCheckBox, 3);
        builder.appendSeparator(this.rb.getString("Title.ReverseAccountBalances"));
        builder.append((Component)this.noneButton, 3);
        builder.append((Component)this.creditAccountsButton, 3);
        builder.append((Component)this.incomeExpenseAccountsButton, 3);
    }

    private void accountBalancesAction() {
        if (this.noneButton.isSelected()) {
            AccountBalanceDisplayManager.setDisplayMode(AccountBalanceDisplayMode.NONE);
        } else if (this.creditAccountsButton.isSelected()) {
            AccountBalanceDisplayManager.setDisplayMode(AccountBalanceDisplayMode.REVERSE_CREDIT);
        } else if (this.incomeExpenseAccountsButton.isSelected()) {
            AccountBalanceDisplayManager.setDisplayMode(AccountBalanceDisplayMode.REVERSE_INCOME_EXPENSE);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.useAccountTermsCheckBox) {
            RegisterFactory.setAccountingTermsEnabled(this.useAccountTermsCheckBox.isSelected());
        } else if (e.getSource() == this.noneButton || e.getSource() == this.creditAccountsButton || e.getSource() == this.incomeExpenseAccountsButton) {
            this.accountBalancesAction();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.accountSeparatorField) {
            if (this.accountSeparatorField.getText().length() > 0) {
                EngineFactory.getEngine("default").setAccountSeparator(this.accountSeparatorField.getText());
            } else {
                this.accountSeparatorField.setText(EngineFactory.getEngine("default").getAccountSeparator());
            }
        }
    }
}

