/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jgnash.engine.Account;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;
import jgnash.ui.components.AutoCompleteFactory;
import jgnash.ui.components.JFloatField;
import jgnash.ui.register.AbstractEntryFormPanel;
import jgnash.ui.register.AccountExchangePanel;
import jgnash.ui.register.table.SplitsRegisterTableModel;

public abstract class AbstractTransactionEntryPanel
extends AbstractEntryFormPanel
implements ActionListener {
    protected AccountExchangePanel accountPanel;
    protected JCheckBox reconciledButton;
    protected JFloatField amountField;
    protected JTextField memoField;
    private JButton enterButton;
    private JButton cancelButton;
    protected Account account;
    protected TransactionEntry oldEntry;
    private SplitsRegisterTableModel model = null;

    protected AbstractTransactionEntryPanel(SplitsRegisterTableModel model) {
        this.model = model;
        this.account = model.getAccount();
        this.layoutMainPanel();
        this.clearForm();
    }

    private void init() {
        this.amountField = new JFloatField(this.account.getCurrencyNode());
        this.accountPanel = new AccountExchangePanel(this.account.getCurrencyNode(), this.account, this.amountField);
        this.enterButton = new JButton(this.rb.getString("Button.Enter"));
        this.cancelButton = new JButton(this.rb.getString("Button.Clear"));
        this.memoField = AutoCompleteFactory.getMemoField();
        this.reconciledButton = new JCheckBox(this.rb.getString("Button.Reconciled"));
        this.reconciledButton.setHorizontalTextPosition(10);
        this.reconciledButton.setMargin(new Insets(0, 0, 0, 0));
        this.cancelButton.addActionListener(this);
        this.enterButton.addActionListener(this);
        this.enterButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AbstractTransactionEntryPanel.this.enterAction();
                }
            }
        });
        this.setFocusCycleRoot(true);
    }

    private void layoutMainPanel() {
        this.init();
        FormLayout layout = new FormLayout("d, 4dlu, d:g, 8dlu, d, 4dlu, 45dlu", "f:d, 3dlu, f:d, 3dlu, f:d");
        layout.setRowGroups((int[][])new int[][]{{1, 3, 5}});
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)layout);
        this.setBorder(Borders.DIALOG_BORDER);
        this.add("Label.Account", (Object)cc.xy(1, 1));
        this.add((Component)this.accountPanel, (Object)cc.xy(3, 1));
        this.add("Label.Amount", (Object)cc.xy(5, 1));
        this.add((Component)this.amountField, (Object)cc.xy(7, 1));
        this.add("Label.Memo", (Object)cc.xy(1, 3));
        this.add((Component)this.memoField, (Object)cc.xywh(3, 3, 5, 1));
        this.add((Component)this.createBottomPanel(), (Object)cc.xywh(1, 5, 7, 1));
    }

    private JPanel createBottomPanel() {
        FormLayout layout = new FormLayout("m, 8dlu, m:g", "f:d");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append((Component)this.reconciledButton, (Component)ButtonBarFactory.buildOKCancelBar((JButton)this.enterButton, (JButton)this.cancelButton));
        return builder.getPanel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.cancelAction();
        } else if (e.getSource() == this.enterButton) {
            this.enterAction();
        }
    }

    protected abstract TransactionEntry buildTransactionEntry();

    public abstract void modifyTransaction(TransactionEntry var1);

    @Override
    public void clearForm() {
        this.oldEntry = null;
        this.memoField.setText(null);
        this.amountField.setDecimal(null);
        this.reconciledButton.setSelected(false);
        this.accountPanel.setExchangedAmount(null);
    }

    @Override
    public void enterAction() {
        if (this.validateForm()) {
            TransactionEntry entry = this.buildTransactionEntry();
            if (this.oldEntry != null) {
                this.model.modifyTransaction(this.oldEntry, entry);
            } else {
                this.model.addTransaction(entry);
            }
            this.clearForm();
            this.fireOkAction();
        }
    }

    @Override
    protected void cancelAction() {
        this.clearForm();
        this.fireCancelAction();
        this.focusFirstComponent();
    }

    protected Account getAccount() {
        return this.account;
    }

    @Override
    public boolean validateForm() {
        return !this.amountField.getText().equals("");
    }

    protected boolean hasEqualCurrencies() {
        return this.getAccount().getCurrencyNode().equals(this.accountPanel.getSelectedAccount().getCurrencyNode());
    }

    @Override
    public void modifyTransaction(Transaction t) {
        throw new IllegalStateException();
    }
}

