/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import com.jgoodies.forms.builder.ButtonBarBuilder2;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jgnash.engine.Account;
import jgnash.engine.TransactionEntry;
import jgnash.ui.register.PanelType;
import jgnash.ui.register.RegisterFactory;
import jgnash.ui.register.SplitTransactionEntryPanel;
import jgnash.ui.register.table.RegisterTable;
import jgnash.ui.register.table.SplitsRegisterTableModel;
import jgnash.ui.util.DialogUtils;
import jgnash.ui.util.JTableUtils;
import jgnash.util.Resource;

public class SplitsDialog
extends JDialog
implements ListSelectionListener,
ActionListener {
    private final Resource rb = Resource.get();
    private SplitsRegisterTableModel model;
    private RegisterTable table;
    private SplitTransactionEntryPanel creditPanel;
    private SplitTransactionEntryPanel debitPanel;
    private Account account;
    protected boolean returnStatus = false;
    private JButton newButton;
    private JButton deleteButton;
    private JButton deleteAllButton;
    private JTabbedPane tabbedPane;
    private JButton okButton;
    private JButton cancelButton;

    protected static SplitsDialog getSplitsDialog(Component c, Account account, List<TransactionEntry> splits, PanelType defaultTab) {
        Window parent = SwingUtilities.getWindowAncestor(c);
        if (parent instanceof Dialog) {
            return new SplitsDialog((Dialog)parent, account, splits, defaultTab);
        }
        if (parent instanceof Frame) {
            return new SplitsDialog((Frame)parent, account, splits, defaultTab);
        }
        return new SplitsDialog((Frame)null, account, splits, defaultTab);
    }

    private SplitsDialog(Frame parent, Account account, List<TransactionEntry> splits, PanelType defaultTab) {
        super(parent, true);
        this.init(account, splits, defaultTab);
    }

    private SplitsDialog(Dialog parent, Account account, List<TransactionEntry> splits, PanelType defaultTab) {
        super(parent, true);
        this.init(account, splits, defaultTab);
    }

    private void init(Account a, List<TransactionEntry> splits, PanelType defaultTab) {
        this.setTitle(this.rb.getString("Title.SpitTran"));
        this.setDefaultCloseOperation(2);
        this.account = a;
        this.table = RegisterFactory.generateSplitsTable(a, splits);
        this.model = (SplitsRegisterTableModel)this.table.getModel();
        JTableUtils.packTable(this.table);
        this.layoutMainPanel();
        if (defaultTab == PanelType.DECREASE) {
            this.tabbedPane.setSelectedIndex(1);
        } else {
            this.tabbedPane.setSelectedIndex(0);
        }
        this.pack();
        this.setMinimumSize(this.getSize());
        DialogUtils.addBoundsListener(this);
    }

    private void initComponents() {
        this.newButton = new JButton(this.rb.getString("Button.New"));
        this.deleteButton = new JButton(this.rb.getString("Button.Delete"));
        this.deleteAllButton = new JButton(this.rb.getString("Button.DeleteAll"));
        this.okButton = new JButton(this.rb.getString("Button.Ok"));
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.deleteAllButton.addActionListener(this);
        this.tabbedPane = new JTabbedPane();
        this.debitPanel = new SplitTransactionEntryPanel(this.model, PanelType.DECREASE);
        this.creditPanel = new SplitTransactionEntryPanel(this.model, PanelType.INCREASE);
        String[] tabNames = RegisterFactory.getCreditDebitTabNames(this.account);
        this.tabbedPane.add(tabNames[0], this.creditPanel);
        this.tabbedPane.add(tabNames[1], this.debitPanel);
        this.table.getSelectionModel().addListSelectionListener(this);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("d:g", "80dlu:g");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)new JScrollPane(this.table));
        ButtonBarBuilder2 bbb = new ButtonBarBuilder2();
        bbb.addButton((JComponent)this.newButton, (JComponent)this.deleteButton);
        bbb.addUnrelatedGap();
        bbb.addGlue();
        bbb.addButton((JComponent)this.deleteAllButton);
        builder.append((Component)bbb.getPanel());
        builder.append((Component)this.tabbedPane);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.okButton, (JButton)this.cancelButton));
        this.getContentPane().add((Component)builder.getPanel(), "Center");
    }

    private void closeDialog() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void okAction() {
        this.returnStatus = true;
        this.closeDialog();
    }

    private void deleteAction() {
        int index = this.table.getSelectedRow();
        if (index != -1) {
            this.model.removeTransaction(index);
        }
    }

    private void deleteAllAction() {
        for (int i = this.model.getRowCount() - 1; i >= 0; --i) {
            this.model.removeTransaction(i);
        }
    }

    private void newAction() {
        this.creditPanel.clearForm();
        this.debitPanel.clearForm();
        this.table.clearSelection();
    }

    private void modifyTransaction(int index) {
        TransactionEntry t = this.model.getTransactionAt(index);
        if (t.getCreditAccount() == this.account) {
            this.tabbedPane.setSelectedComponent(this.creditPanel);
            this.creditPanel.modifyTransaction(t);
        } else {
            this.tabbedPane.setSelectedComponent(this.debitPanel);
            this.debitPanel.modifyTransaction(t);
        }
    }

    public List<TransactionEntry> getSplits() {
        return this.model.getSplits();
    }

    public BigDecimal getBalance() {
        return this.model.getBalance();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int index = this.table.getSelectedRow();
        if (index != -1) {
            this.modifyTransaction(index);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.closeDialog();
        } else if (e.getSource() == this.deleteButton) {
            this.deleteAction();
        } else if (e.getSource() == this.deleteAllButton) {
            this.deleteAllAction();
        } else if (e.getSource() == this.newButton) {
            this.newAction();
        } else if (e.getSource() == this.okButton) {
            this.okAction();
        }
    }
}

