/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.invest;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jgnash.engine.Account;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.ReconciledState;
import jgnash.engine.SecurityNode;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionFactory;
import jgnash.engine.TransactionType;
import jgnash.ui.UIApplication;
import jgnash.ui.components.AccountSecurityComboBox;
import jgnash.ui.components.AutoCompleteFactory;
import jgnash.ui.components.DatePanel;
import jgnash.ui.components.JFloatField;
import jgnash.ui.register.invest.AbstractInvTransactionPanel;
import jgnash.ui.util.ValidationFactory;

public class AddRemoveSharePanel
extends AbstractInvTransactionPanel {
    private TransactionType tranType;
    private AccountSecurityComboBox securityCombo;
    private DatePanel datePanel;
    private JFloatField quantityField;
    private JTextField memoField;
    private JFloatField priceField;
    private JFloatField totalField;
    private Logger logger = UIApplication.getLogger();

    protected AddRemoveSharePanel(Account account, TransactionType tranType) {
        super(account);
        this.tranType = tranType;
        this.securityCombo = new AccountSecurityComboBox(account);
        this.datePanel = new DatePanel();
        this.quantityField = new JFloatField(0, 6, 2);
        this.memoField = AutoCompleteFactory.getMemoField();
        this.priceField = new JFloatField(0, 6, (int)account.getCurrencyNode().getScale());
        this.totalField = new JFloatField(account.getCurrencyNode());
        this.totalField.setEditable(false);
        this.totalField.setFocusable(false);
        this.reconciledButton = new JCheckBox(this.rb.getString("Button.Reconciled"));
        this.layoutMainPanel();
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                AddRemoveSharePanel.this.updateTotalField();
            }
        };
        this.quantityField.addFocusListener(focusListener);
        this.priceField.addFocusListener(focusListener);
        this.securityCombo.addKeyListener(this.keyListener);
        this.datePanel.getDateField().addKeyListener(this.keyListener);
        this.quantityField.addKeyListener(this.keyListener);
        this.memoField.addKeyListener(this.keyListener);
        this.priceField.addKeyListener(this.keyListener);
        this.clearForm();
    }

    private void layoutMainPanel() {
        FormLayout layout = new FormLayout("right:d, $lcgap, 50dlu:g, 8dlu, right:d, $lcgap, max(65dlu;min)", "f:d, $lgap, f:d, $lgap, f:d, $lgap:g");
        layout.setRowGroups((int[][])new int[][]{{1, 3, 5}});
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)layout);
        JPanel subPanel = this.buildHorizontalSubPanel("max(48dlu;min):g(0.5), 8dlu, d, $lcgap, max(48dlu;min):g(0.5)", new Object[]{ValidationFactory.wrap(this.priceField), "Label.Quantity", ValidationFactory.wrap(this.quantityField)});
        this.add("Label.Security", (Object)cc.xy(1, 1));
        this.add((Component)ValidationFactory.wrap(this.securityCombo), (Object)cc.xy(3, 1));
        this.add("Label.Date", (Object)cc.xy(5, 1));
        this.add((Component)this.datePanel, (Object)cc.xy(7, 1));
        this.add("Label.Price", (Object)cc.xy(1, 3));
        this.add((Component)subPanel, (Object)cc.xy(3, 3));
        this.add("Label.Total", (Object)cc.xy(5, 3));
        this.add((Component)this.totalField, (Object)cc.xy(7, 3));
        this.add("Label.Memo", (Object)cc.xy(1, 5));
        this.add((Component)this.memoField, (Object)cc.xy(3, 5));
        this.add((Component)this.reconciledButton, (Object)cc.xyw(5, 5, 3));
    }

    @Override
    public void clearForm() {
        this.modTrans = null;
        if (!AddRemoveSharePanel.getRememberLastDate()) {
            this.datePanel.setDate(new Date());
        }
        this.memoField.setText(null);
        this.priceField.setDecimal(null);
        this.quantityField.setDecimal(null);
        this.totalField.setDecimal(null);
        this.reconciledButton.setSelected(false);
        this.updateTotalField();
    }

    @Override
    public void modifyTransaction(Transaction tran) {
        assert (tran instanceof InvestmentTransaction);
        assert (tran.getTransactionType() == TransactionType.ADDSHARE || tran.getTransactionType() == TransactionType.REMOVESHARE);
        InvestmentTransaction _tran = (InvestmentTransaction)tran;
        this.clearForm();
        this.modTrans = tran;
        this.datePanel.setDate(tran.getDate());
        this.memoField.setText(tran.getMemo());
        this.priceField.setDecimal(_tran.getPrice());
        this.quantityField.setDecimal(_tran.getQuantity());
        this.securityCombo.setSelectedNode(_tran.getSecurityNode());
        this.reconciledButton.setSelected(tran.getReconciled(this.getAccount()) == ReconciledState.RECONCILED);
        this.updateTotalField();
    }

    @Override
    public Transaction buildTransaction() {
        if (this.tranType == TransactionType.ADDSHARE) {
            return TransactionFactory.generateAddXTransaction(this.account, (SecurityNode)this.securityCombo.getSelectedNode(), this.priceField.getDecimal(), this.quantityField.getDecimal(), this.datePanel.getDate(), this.memoField.getText(), this.reconciledButton.isSelected());
        }
        return TransactionFactory.generateRemoveXTransaction(this.account, (SecurityNode)this.securityCombo.getSelectedNode(), this.priceField.getDecimal(), this.quantityField.getDecimal(), this.datePanel.getDate(), this.memoField.getText(), this.reconciledButton.isSelected());
    }

    void updateTotalField() {
        BigDecimal quantity = this.quantityField.getDecimal();
        BigDecimal price = this.priceField.getDecimal();
        this.totalField.setDecimal(quantity.multiply(price));
    }

    @Override
    public boolean validateForm() {
        if (this.securityCombo.getSelectedNode() == null) {
            this.logger.warning(this.rb.getString("Message.Error.SecuritySelection"));
            this.showValidationError(this.rb.getString("Message.Error.SecuritySelection"), this.securityCombo);
            return false;
        }
        if (this.priceField.getText().equals("")) {
            this.logger.warning(this.rb.getString("Message.Error.SecurityPrice"));
            this.showValidationError(this.rb.getString("Message.Error.SecurityPrice"), this.priceField);
            return false;
        }
        if (this.quantityField.getText().equals("")) {
            this.logger.warning(this.rb.getString("Message.Error.SecurityQuantity"));
            this.showValidationError(this.rb.getString("Message.Error.SecurityQuantity"), this.quantityField);
            return false;
        }
        return true;
    }

    @Override
    protected void cancelAction() {
        this.clearForm();
    }
}

