/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.table;

import java.awt.EventQueue;
import java.math.BigDecimal;
import java.util.ArrayList;
import jgnash.engine.Account;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.ReconciledState;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;
import jgnash.engine.TransactionType;
import jgnash.message.Message;
import jgnash.message.MessageProperty;
import jgnash.ui.register.AccountBalanceDisplayManager;
import jgnash.ui.register.table.RegisterTableModel;

public class RegisterTableWithSplitEntriesModel
extends RegisterTableModel {
    private static final long serialVersionUID = 6691702130271087845L;
    private ArrayList<TransactionWrapper> data;
    private boolean splitDetailsActived = false;

    public RegisterTableWithSplitEntriesModel(Account account, String[] names, boolean detailSplits) {
        super(account, names, _clazz);
        this.splitDetailsActived = detailSplits;
        this.updateData();
    }

    @Override
    protected Object getInternalValueAt(int row, int col) {
        TransactionWrapper wrapper = this.data.get(row);
        BigDecimal amount = wrapper.entry == null ? wrapper.transaction.getAmount(this.account) : wrapper.entry.getAmount(this.account);
        int signum = amount.signum();
        boolean showDetail = wrapper.entry != null && this.splitDetailsActived;
        switch (col) {
            case 0: {
                if (showDetail) {
                    return null;
                }
                return wrapper.transaction.getDate();
            }
            case 1: {
                if (showDetail) {
                    return null;
                }
                return wrapper.transaction.getNumber();
            }
            case 2: {
                if (showDetail) {
                    return null;
                }
                return wrapper.transaction.getPayee();
            }
            case 3: {
                if (showDetail) {
                    return null;
                }
                return wrapper.transaction.getMemo();
            }
            case 4: {
                if (wrapper.entry != null && showDetail) {
                    TransactionEntry _t = wrapper.entry;
                    if (_t.getCreditAccount() != this.account) {
                        return "   - " + _t.getCreditAccount().getName();
                    }
                    return "   - " + _t.getDebitAccount().getName();
                }
                if (wrapper.entry == null && wrapper.transaction.getTransactionType() == TransactionType.DOUBLEENTRY) {
                    TransactionEntry _t = wrapper.transaction.getTransactionEntries().get(0);
                    if (_t.getCreditAccount() != this.account) {
                        return _t.getCreditAccount().getName();
                    }
                    return _t.getDebitAccount().getName();
                }
                if (wrapper.entry == null && wrapper.transaction.getTransactionType() == TransactionType.SINGLENTRY) {
                    TransactionEntry _t = wrapper.transaction.getTransactionEntries().get(0);
                    return _t.getCreditAccount().getName();
                }
                if (wrapper.transaction.getTransactionType() == TransactionType.SPLITENTRY) {
                    Transaction _t = wrapper.transaction;
                    return "[ " + _t.size() + " " + split + " ]";
                }
                if (wrapper.transaction instanceof InvestmentTransaction) {
                    return ((InvestmentTransaction)wrapper.transaction).getInvestmentAccount().getName();
                }
                System.out.println("here");
                return "error";
            }
            case 5: {
                if (wrapper.entry == null) {
                    return wrapper.transaction.getReconciled(this.account) == ReconciledState.NOT_RECONCILED ? null : this.reconcileSymbol;
                }
                return wrapper.entry.getReconciled(this.account) == ReconciledState.NOT_RECONCILED ? null : this.reconcileSymbol;
            }
            case 6: {
                if (signum >= 0) {
                    return amount;
                }
                return null;
            }
            case 7: {
                if (signum < 0) {
                    return amount.abs();
                }
                return null;
            }
            case 8: {
                if (showDetail) {
                    return null;
                }
                return this.getBalanceAt(row);
            }
        }
        return "error";
    }

    private void updateData() {
        this.updateData(0);
    }

    private void updateData(int startIndex) {
        if (this.data == null) {
            this.data = new ArrayList(0);
        }
        while (this.data.size() > startIndex) {
            this.data.remove(startIndex);
        }
        for (Transaction t : this.account.getTransactions()) {
            if (this.data.size() < startIndex) continue;
            this.data.add(new TransactionWrapper(t));
            if (t.getTransactionType() != TransactionType.SPLITENTRY || !this.splitDetailsActived) continue;
            int splitImpact = 0;
            for (TransactionEntry e : t.getTransactionEntries()) {
                if (e.getAmount(this.account).signum() == 0) continue;
                ++splitImpact;
            }
            if (splitImpact <= true) continue;
            for (TransactionEntry e : t.getTransactionEntries()) {
                if (e.getAmount(this.account).signum() == 0) continue;
                this.data.add(new TransactionWrapper(t, e));
            }
        }
        this.balanceCache.ensureCapacity(this.data.size());
        this.balanceCache.clear(startIndex);
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Transaction getTransactionAt(int index) {
        return this.data.get((int)index).transaction;
    }

    @Override
    public int indexOf(Transaction t) {
        for (TransactionWrapper w : this.data) {
            if (!w.transaction.equals(t)) continue;
            return this.data.indexOf(w);
        }
        return 0;
    }

    @Override
    public BigDecimal getBalanceAt(int index) {
        if (this.balanceCache.get(index) != null) {
            return AccountBalanceDisplayManager.convertToSelectedBalanceMode(this.account.getAccountType(), this.balanceCache.get(index));
        }
        BigDecimal balance = null;
        Transaction t = this.data.get((int)index).transaction;
        if (this.account.contains(t) && this.data.get((int)index).entry == null) {
            balance = BigDecimal.ZERO;
            for (int i = 0; i <= index; ++i) {
                Transaction tran = this.data.get((int)i).transaction;
                if (this.data.get((int)i).entry != null || !this.account.contains(tran)) continue;
                balance = balance.add(tran.getAmount(this.account));
            }
        }
        this.balanceCache.set(index, balance);
        return AccountBalanceDisplayManager.convertToSelectedBalanceMode(this.account.getAccountType(), balance);
    }

    @Override
    public void messagePosted(final Message event) {
        if (this.account.equals(event.getObject(MessageProperty.ACCOUNT))) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    switch (event.getEvent()) {
                        case FILE_CLOSING: {
                            RegisterTableWithSplitEntriesModel.this.dispose();
                            break;
                        }
                        case TRANSACTION_ADD: {
                            Transaction t = (Transaction)event.getObject(MessageProperty.TRANSACTION);
                            RegisterTableWithSplitEntriesModel.this.updateData();
                            int index = RegisterTableWithSplitEntriesModel.this.data.indexOf(t);
                            RegisterTableWithSplitEntriesModel.this.fireTableRowsInserted(index, index);
                            break;
                        }
                        case TRANSACTION_REMOVE: {
                            RegisterTableWithSplitEntriesModel.this.updateData();
                            RegisterTableWithSplitEntriesModel.this.fireTableDataChanged();
                            break;
                        }
                    }
                }
            });
        }
    }

    public boolean isSplitDetailsActived() {
        return this.splitDetailsActived;
    }

    public void setSplitDetailsActived(boolean detailSplits) {
        this.splitDetailsActived = detailSplits;
        this.updateData();
    }

    private static class TransactionWrapper {
        Transaction transaction;
        TransactionEntry entry;

        protected TransactionWrapper(Transaction transaction, TransactionEntry entry) {
            this.transaction = transaction;
            this.entry = entry;
        }

        protected TransactionWrapper(Transaction transaction) {
            this.transaction = transaction;
        }
    }
}

