/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.collections;

import com.db4o.activation.Activator;
import com.db4o.ta.Activatable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayMap4<K, V>
implements Map<K, V>,
Serializable,
Cloneable,
Activatable {
    private static final long serialVersionUID = 1L;
    private K[] _keys;
    private V[] _values;
    private int _startIndex;
    private int _endIndex;
    private transient Activator _activator;

    public ArrayMap4() {
        this(16);
    }

    public ArrayMap4(int n) {
        this.initializeBackingArray(n);
    }

    @Override
    public void activate() {
        if (this._activator != null) {
            this._activator.activate();
        }
    }

    @Override
    public void bind(Activator activator) {
        if (this._activator != null || activator == null) {
            throw new IllegalStateException();
        }
        this._activator = activator;
    }

    @Override
    public void clear() {
        this.activate();
        this._startIndex = 0;
        this._endIndex = 0;
        Arrays.fill(this._keys, null);
        Arrays.fill(this._values, null);
    }

    @Override
    public boolean containsKey(Object object) {
        this.activate();
        return this.indexOf(this._keys, object) != -1;
    }

    @Override
    public boolean containsValue(Object object) {
        this.activate();
        return this.indexOf(this._values, object) != -1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.activate();
        HashSet<Map.Entry<K, V>> hashSet = new HashSet<Map.Entry<K, V>>();
        for (int i = this._startIndex; i < this._endIndex; ++i) {
            MapEntry4<K, V> mapEntry4 = new MapEntry4<K, V>(this._keys[i], this._values[i]);
            hashSet.add(mapEntry4);
        }
        return hashSet;
    }

    @Override
    public V get(Object object) {
        this.activate();
        int n = this.indexOf(this._keys, object);
        return n == -1 ? null : (V)this._values[n];
    }

    @Override
    public boolean isEmpty() {
        this.activate();
        return this._endIndex - this._startIndex == 0;
    }

    @Override
    public Set<K> keySet() {
        this.activate();
        HashSet<K> hashSet = new HashSet<K>();
        for (int i = this._startIndex; i < this._endIndex; ++i) {
            hashSet.add(this._keys[i]);
        }
        return hashSet;
    }

    @Override
    public V put(K k, V v) {
        this.activate();
        int n = this.indexOf(this._keys, k);
        V v2 = null;
        if (n == -1) {
            this.add(k, v);
        } else {
            v2 = this._values[n];
            this._values[n] = v;
        }
        return v2;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        this.activate();
        int n = this.indexOf(this._keys, object);
        if (n == -1) {
            return null;
        }
        return (V)this.delete(n);
    }

    @Override
    public int size() {
        this.activate();
        return this._endIndex - this._startIndex;
    }

    @Override
    public Collection<V> values() {
        this.activate();
        ArrayList<V> arrayList = new ArrayList<V>();
        for (int i = this._startIndex; i < this._endIndex; ++i) {
            arrayList.add(this._values[i]);
        }
        return arrayList;
    }

    public Object clone() {
        this.activate();
        try {
            ArrayMap4 arrayMap4 = (ArrayMap4)super.clone();
            arrayMap4._keys = (Object[])this._keys.clone();
            arrayMap4._values = (Object[])this._values.clone();
            return arrayMap4;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size() != map.size()) {
            return false;
        }
        Set set = map.keySet();
        for (Map.Entry<K, V> entry : this.entrySet()) {
            K k = entry.getKey();
            if (!set.contains(k)) {
                return false;
            }
            V v = entry.getValue();
            if (v != null ? v.equals(map.get(k)) : map.get(k) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (Map.Entry<K, V> entry : this.entrySet()) {
            n += ((Object)entry).hashCode();
        }
        return n;
    }

    private void initializeBackingArray(int n) {
        this._keys = new Object[n];
        this._values = new Object[n];
    }

    private int indexOf(Object[] objectArray, Object object) {
        int n = -1;
        for (int i = this._startIndex; i < this._endIndex; ++i) {
            if (!(objectArray[i] == null ? object == null : objectArray[i].equals(object))) continue;
            n = i;
            break;
        }
        return n;
    }

    private void add(K k, V v) {
        this.ensureCapacity();
        this._keys[this._endIndex] = k;
        this._values[this._endIndex] = v;
        ++this._endIndex;
    }

    private void ensureCapacity() {
        if (this._endIndex == this._keys.length) {
            Object[] objectArray = new Object[this._keys.length * 2];
            Object[] objectArray2 = new Object[this._values.length * 2];
            System.arraycopy(this._keys, this._startIndex, objectArray, 0, this._endIndex - this._startIndex);
            System.arraycopy(this._values, this._startIndex, objectArray2, 0, this._endIndex - this._startIndex);
            Arrays.fill(this._keys, null);
            Arrays.fill(this._values, null);
            this._keys = objectArray;
            this._values = objectArray2;
        }
    }

    private Object delete(int n) {
        V v = this._values[n];
        for (int i = n; i < this._endIndex - 1; ++i) {
            this._keys[i] = this._keys[i + 1];
            this._values[i] = this._values[i + 1];
        }
        --this._endIndex;
        this._keys[this._endIndex] = null;
        this._values[this._endIndex] = null;
        return v;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapEntry4<K, V>
    implements Map.Entry<K, V> {
        private K _key;
        private V _value;

        public MapEntry4(K k, V v) {
            this._key = k;
            this._value = v;
        }

        @Override
        public K getKey() {
            return this._key;
        }

        @Override
        public V getValue() {
            return this._value;
        }

        @Override
        public V setValue(V v) {
            V v2 = v;
            this._value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            MapEntry4 mapEntry4 = (MapEntry4)object;
            return this._key == null ? mapEntry4.getKey() == null : (this._key.equals(mapEntry4.getKey()) && this._value == null ? mapEntry4.getValue() == null : this._value.equals(mapEntry4.getValue()));
        }

        @Override
        public int hashCode() {
            return (this._key == null ? 0 : this._key.hashCode()) ^ (this._value == null ? 0 : this._value.hashCode());
        }
    }
}

