/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.db4o;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import jgnash.engine.StoredObject;
import jgnash.engine.dao.AccountDAO;
import jgnash.engine.dao.CommodityDAO;
import jgnash.engine.dao.ConfigDAO;
import jgnash.engine.dao.EngineDAO;
import jgnash.engine.dao.RecurringDAO;
import jgnash.engine.dao.TransactionDAO;
import jgnash.engine.dao.TrashDAO;
import jgnash.engine.db4o.AbstractDb4oDAO;
import jgnash.engine.db4o.Db4oAccountDAO;
import jgnash.engine.db4o.Db4oCommodityDAO;
import jgnash.engine.db4o.Db4oConfigDAO;
import jgnash.engine.db4o.Db4oRecurringDAO;
import jgnash.engine.db4o.Db4oTransactionDAO;
import jgnash.engine.db4o.Db4oTrashDAO;
import jgnash.util.DefaultDaemonThreadFactory;

public class Db4oEngineDAO
extends AbstractDb4oDAO
implements EngineDAO {
    private AccountDAO accountDAO;
    private CommodityDAO commodityDAO;
    private ConfigDAO configDAO;
    private RecurringDAO recurringDAO;
    private TransactionDAO transactionDAO;
    private TrashDAO trashDAO;
    private ScheduledExecutorService commitExecutor = Executors.newSingleThreadScheduledExecutor(new DefaultDaemonThreadFactory());

    protected Db4oEngineDAO(ObjectContainer container, boolean isRemote) {
        super(container, isRemote);
        this.commitExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (AbstractDb4oDAO.commitCount.get() > 0) {
                    Db4oEngineDAO.this.commitAndReset();
                }
            }
        }, 30L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public synchronized void shutdown() {
        this.commitExecutor.shutdown();
        this.commitExecutor = null;
    }

    @Override
    public synchronized AccountDAO getAccountDAO() {
        if (this.accountDAO == null) {
            this.accountDAO = new Db4oAccountDAO(this.container, this.isRemote);
        }
        return this.accountDAO;
    }

    @Override
    public synchronized CommodityDAO getCommodityDAO() {
        if (this.commodityDAO == null) {
            this.commodityDAO = new Db4oCommodityDAO(this.container, this.isRemote);
        }
        return this.commodityDAO;
    }

    @Override
    public synchronized ConfigDAO getConfigDAO() {
        if (this.configDAO == null) {
            this.configDAO = new Db4oConfigDAO(this.container, this.isRemote);
        }
        return this.configDAO;
    }

    @Override
    public synchronized RecurringDAO getRecurringDAO() {
        if (this.recurringDAO == null) {
            this.recurringDAO = new Db4oRecurringDAO(this.container, this.isRemote);
        }
        return this.recurringDAO;
    }

    @Override
    public synchronized TransactionDAO getTransactionDAO() {
        if (this.transactionDAO == null) {
            this.transactionDAO = new Db4oTransactionDAO(this.container, this.isRemote);
        }
        return this.transactionDAO;
    }

    @Override
    public synchronized TrashDAO getTrashDAO() {
        if (this.trashDAO == null) {
            this.trashDAO = new Db4oTrashDAO(this.container, this.isRemote);
        }
        return this.trashDAO;
    }

    @Override
    public StoredObject getObjectByUuid(String uuid) {
        StoredObject o = null;
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            Query query = this.container.query();
            query.constrain(StoredObject.class);
            query.descend("uuid").constrain((Object)uuid);
            ObjectSet result = query.execute();
            this.container.ext().releaseSemaphore("Lock");
            assert (result.size() <= 1);
            if (result.size() == 1) {
                o = (StoredObject)result.get(0);
            }
        }
        return o;
    }

    @Override
    public List<StoredObject> getStoredObjects() {
        ArrayList<StoredObject> list = new ArrayList<StoredObject>();
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            ObjectSet set = this.container.query(StoredObject.class);
            this.container.ext().releaseSemaphore("Lock");
            list.addAll((Collection<StoredObject>)set);
        }
        return list;
    }
}

