/*
 * Decompiled with CFR 0.152.
 */
package jgnash.imports.jgnash;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import jgnash.engine.AbstractInvestmentTransactionEntry;
import jgnash.engine.Account;
import jgnash.engine.AccountType;
import jgnash.engine.AmortizeObject;
import jgnash.engine.CurrencyNode;
import jgnash.engine.DefaultCurrencies;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.QuoteSource;
import jgnash.engine.ReconcileManager;
import jgnash.engine.ReconciledState;
import jgnash.engine.SecurityHistoryNode;
import jgnash.engine.SecurityNode;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;
import jgnash.engine.TransactionEntryAddX;
import jgnash.engine.TransactionEntryMergeX;
import jgnash.engine.TransactionEntryReinvestDivX;
import jgnash.engine.TransactionEntryRemoveX;
import jgnash.engine.TransactionEntrySplitX;
import jgnash.engine.TransactionFactory;
import jgnash.engine.TransactionTag;
import jgnash.util.EncodeDecode;

public class Import {
    private static final String ID = "_ID_";
    private static final Logger logger = Logger.getLogger(Import.class.getName());
    private Map<String, Account> accountMap = new HashMap<String, Account>();
    private Map<Account, String> parentMap = new HashMap<Account, String>();
    private Map<String, Boolean> lockMap = new HashMap<String, Boolean>();
    private List<Map<String, String>> splitList = new ArrayList<Map<String, String>>();
    private List<Map<String, String>> splitEntryList = new ArrayList<Map<String, String>>();
    private Map<String, Commodity> commodityMap = new HashMap<String, Commodity>();
    private static List<Runnable> workQueue = new ArrayList<Runnable>();
    private Map<String, CurrencyNode> currencyCache = new HashMap<String, CurrencyNode>();
    private Calendar calendar = Calendar.getInstance();

    private Import() {
        try {
            FileHandler fh = new FileHandler("%h/jgnashimport%g.log");
            fh.setFormatter(new SimpleFormatter());
            logger.addHandler(fh);
            logger.setLevel(Level.FINE);
        }
        catch (IOException ioe) {
            logger.severe("Could not install file handler");
        }
    }

    public static void doImport(String filename) {
        Import imp = new Import();
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        try {
            Engine engine = EngineFactory.getEngine("default");
            CurrencyNode defaultCurrency = DefaultCurrencies.buildNode(Locale.getDefault());
            if (engine.getCurrency(defaultCurrency.getSymbol(), defaultCurrency.getLocale()) == null) {
                engine.addCommodity(defaultCurrency);
                engine.setDefaultCurrency(defaultCurrency);
            }
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(new File(filename)));
            XMLStreamReader reader = inputFactory.createXMLStreamReader(input, "UTF-8");
            imp.importCommodities(reader);
            reader.close();
            ((InputStream)input).close();
            ExecutorService es = Executors.newSingleThreadExecutor();
            Iterator<Runnable> i = workQueue.iterator();
            while (i.hasNext()) {
                es.execute(i.next());
                i.remove();
            }
            es.shutdown();
            while (!es.isTerminated()) {
                imp.getLogger().info("Waiting for commodity cleanup threads to complete");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    imp.getLogger().log(Level.SEVERE, e.toString(), e);
                }
            }
            imp.getLogger().info("Commodity cleanup threads complete");
            input = new BufferedInputStream(new FileInputStream(new File(filename)));
            reader = inputFactory.createXMLStreamReader(input, "UTF-8");
            imp.importAccounts(reader);
            reader.close();
            ((InputStream)input).close();
            imp.getLogger().info("Running account cleanup threads");
            es = Executors.newSingleThreadExecutor();
            i = workQueue.iterator();
            while (i.hasNext()) {
                es.execute(i.next());
                i.remove();
            }
            es.shutdown();
            while (!es.isTerminated()) {
                imp.getLogger().info("Waiting for account cleanup threads to complete");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    imp.getLogger().log(Level.SEVERE, e.toString(), e);
                }
            }
            imp.getLogger().info("Account cleanup threads complete");
            input = new BufferedInputStream(new FileInputStream(new File(filename)));
            reader = inputFactory.createXMLStreamReader(input, "UTF-8");
            imp.importTransactions(reader);
            reader.close();
            ((InputStream)input).close();
            imp.lockAccounts();
        }
        catch (FileNotFoundException e) {
            imp.getLogger().log(Level.SEVERE, e.toString(), e);
        }
        catch (XMLStreamException e) {
            imp.getLogger().log(Level.SEVERE, e.toString(), e);
        }
        catch (IOException e) {
            imp.getLogger().log(Level.SEVERE, e.toString(), e);
        }
    }

    Logger getLogger() {
        return logger;
    }

    /*
     * Unable to fully structure code
     */
    void importTransactions(XMLStreamReader reader) {
        block17: {
            Import.logger.info("Begin transaction import");
lbl2:
            // 2 sources

            try {
                while (reader.hasNext()) {
                    event = reader.next();
                    switch (event) {
                        case 1: {
                            if (reader.getAttributeCount() > 0 && reader.getAttributeValue(0).contains("Transaction")) {
                                Import.logger.finest("Found the start of a Transaction");
                                this.parseTransaction(reader);
                                break;
                            }
                            ** GOTO lbl2
                        }
                        case 2: {
                            if (reader.getLocalName().equals("objects")) {
                                Import.logger.fine("Found the end of the object list and transactions");
                                break block17;
                            } else {
                                break;
                            }
                        }
                    }
                }
            }
            catch (XMLStreamException e) {
                Import.logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        Import.logger.info("Generating " + this.splitList.size() + " Split Transactions");
        i = this.splitList.iterator();
        while (i.hasNext()) {
            map = i.next();
            id = map.get("_ID_");
            transaction = new Transaction();
            transaction.setDate(this.decodeDate(map.get("voucherDate")));
            transaction.setDateEntered(this.decodeDate(map.get("actTransDate")));
            transaction.setNumber(map.get("number"));
            transaction.setPayee(map.get("payee"));
            transaction.setMemo(map.get("memo"));
            j = this.splitEntryList.iterator();
            while (j.hasNext()) {
                entryMap = j.next();
                if (!entryMap.get("parent").equals(id)) continue;
                entry = new TransactionEntry();
                entry.setMemo(entryMap.get("memo"));
                creditAccount = this.accountMap.get(entryMap.get("creditAccount"));
                debitAccount = this.accountMap.get(entryMap.get("debitAccount"));
                creditReconciled = Boolean.parseBoolean(entryMap.get("creditReconciled"));
                debitReconciled = Boolean.parseBoolean(entryMap.get("debitReconciled"));
                entry.setCreditAccount(creditAccount);
                entry.setDebitAccount(debitAccount);
                node = this.decodeCurrency(entryMap.get("commodity"));
                amount = new BigDecimal(entryMap.get("amount"));
                if (creditAccount.getCurrencyNode().equals(node)) {
                    entry.setCreditAmount(amount);
                } else {
                    exchangeRate = new BigDecimal(entryMap.get("exchangeRate"));
                    entry.setCreditAmount(amount.multiply(exchangeRate));
                }
                if (debitAccount.getCurrencyNode().equals(node)) {
                    entry.setDebitAmount(amount.negate());
                } else {
                    exchangeRate = new BigDecimal(entryMap.get("exchangeRate"));
                    entry.setDebitAmount(amount.multiply(exchangeRate).negate());
                }
                transaction.addTransactionEntry(entry);
                transaction.setReconciled(creditAccount, creditReconciled != false ? ReconciledState.RECONCILED : ReconciledState.NOT_RECONCILED);
                transaction.setReconciled(debitAccount, debitReconciled != false ? ReconciledState.RECONCILED : ReconciledState.NOT_RECONCILED);
                j.remove();
            }
            if (!Import.$assertionsDisabled && transaction.size() <= 0) {
                throw new AssertionError();
            }
            engine = EngineFactory.getEngine("default");
            if (!engine.addTransaction(transaction)) {
                Import.logger.severe("Failed to import transaction: " + id);
            }
            i.remove();
        }
        Import.logger.info("Transaction import complete");
    }

    /*
     * Unable to fully structure code
     */
    void importAccounts(XMLStreamReader reader) {
        block13: {
            Import.logger.info("Begin Account import");
lbl2:
            // 3 sources

            try {
                while (reader.hasNext()) {
                    event = reader.next();
                    switch (event) {
                        case 1: {
                            if (reader.getAttributeCount() > 0) {
                                if (reader.getAttributeValue(0).contains("Account")) {
                                    Import.logger.finest("Found the start of an Account");
                                    this.parseAccount(reader);
                                    break;
                                }
                            } else if (reader.getLocalName().equals("objects")) {
                                break;
                            }
                            ** GOTO lbl2
                        }
                        case 2: {
                            if (reader.getLocalName().equals("objects")) {
                                Import.logger.finest("Found the end of the object list and accounts");
                                break block13;
                            } else {
                                break;
                            }
                        }
                    }
                }
            }
            catch (XMLStreamException e) {
                Import.logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        Import.logger.info("Linking accounts");
        engine = EngineFactory.getEngine("default");
        for (Account account : this.parentMap.keySet()) {
            if (account.getAccountType() == AccountType.ROOT) continue;
            parent = this.accountMap.get(this.parentMap.get(account));
            if (account.getParent().equals(parent)) continue;
            engine.moveAccount(account, parent);
            Import.logger.finest("Moving " + account.getName() + " to " + parent.getName());
        }
        Import.logger.info("Account import complete");
    }

    private void lockAccounts() {
        for (String id : this.lockMap.keySet()) {
            this.accountMap.get(id).setLocked(this.lockMap.get(id));
        }
        logger.info("Account lock complete");
    }

    private void importCommodities(XMLStreamReader reader) {
        logger.info("Begin Commodity import");
        try {
            while (reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 1: {
                        if (reader.getAttributeCount() <= 0) break;
                        if (reader.getAttributeValue(0).equals("SecurityNode")) {
                            logger.finest("Found the start of a SecurityNode");
                            this.parseSecurityNode(reader);
                            break;
                        }
                        if (reader.getAttributeValue(0).equals("CurrencyNode")) {
                            logger.finest("Found the start of a CurrencyNode");
                            this.parseCurrencyNode(reader);
                            break;
                        }
                        if (reader.getAttributeValue(0).equals("CommodityNode")) {
                            logger.finest("Found the start of a CommodityNode");
                            this.parseCommodityNode(reader);
                            break;
                        }
                        if (!reader.getAttributeValue(0).equals("ExchangeRate")) break;
                        logger.finest("Parse exchange rate");
                        this.parseExchangeRate(reader);
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            logger.log(Level.SEVERE, e.toString(), e);
        }
        logger.info("Commodity import complete");
    }

    private void parseExchangeRate(XMLStreamReader reader) {
        HashMap<String, String> elementMap = new HashMap<String, String>();
        QName parsingElement = reader.getName();
        try {
            while (reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 1: {
                        String element = reader.getLocalName();
                        elementMap.put(element.intern(), reader.getElementText());
                        break;
                    }
                    case 2: {
                        if (!reader.getName().equals(parsingElement)) break;
                        logger.finest("Found the end of the exchange rate");
                        try {
                            String key = (String)elementMap.get("key");
                            if (key != null && key.length() == 6) {
                                Engine e = EngineFactory.getEngine("default");
                                CurrencyNode cOne = e.getCurrency(key.substring(0, 3));
                                CurrencyNode cTwo = e.getCurrency(key.substring(3, 6));
                                if (cOne != null && cTwo != null) {
                                    BigDecimal rate = new BigDecimal((String)elementMap.get("rate"));
                                    EngineFactory.getEngine("default").setExchangeRate(cOne, cTwo, rate);
                                    logger.fine("Set ExchangeRate " + key + ":" + rate.toString());
                                }
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, e.toString(), e);
                        }
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            logger.severe("Error importing exchange rate");
            logger.log(Level.SEVERE, e.toString(), e);
        }
    }

    private void parseTransaction(XMLStreamReader reader) {
        assert (reader.getAttributeCount() == 2);
        HashMap<String, String> elementMap = new HashMap<String, String>();
        QName parsingElement = reader.getName();
        String transactionClass = reader.getAttributeValue(0);
        String transactionId = reader.getAttributeValue(1);
        elementMap.put(ID, transactionId);
        try {
            while (reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 1: {
                        String element = reader.getLocalName();
                        elementMap.put(element.intern(), reader.getElementText());
                        break;
                    }
                    case 2: {
                        if (!reader.getName().equals(parsingElement)) break;
                        logger.finest("Found the end of a Transaction: " + transactionId);
                        try {
                            Transaction transaction = this.generateTransaction(transactionClass, elementMap);
                            if (transaction != null) {
                                Engine engine = EngineFactory.getEngine("default");
                                engine.addTransaction(transaction);
                                logger.finest("Transaction add complete");
                            }
                        }
                        catch (Exception e) {
                            logger.severe("Error importing transaction id: " + transactionId);
                            logger.log(Level.SEVERE, e.toString(), e);
                            throw new RuntimeException(e);
                        }
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            logger.severe("Error importing transaction id: " + transactionId);
            logger.log(Level.SEVERE, e.toString(), e);
        }
    }

    private Transaction generateTransaction(String transactionClass, Map<String, String> elementMap) {
        BigDecimal amount;
        BigDecimal quantity;
        BigDecimal price;
        BigDecimal fees;
        AbstractInvestmentTransactionEntry entry;
        SecurityNode sNode;
        boolean reconciled;
        Account investmentAccount;
        BigDecimal quantity2;
        BigDecimal price2;
        if (transactionClass.equals("SplitTransaction")) {
            logger.finest("Found SplitTransaction");
            this.splitList.add(elementMap);
            return null;
        }
        if (transactionClass.equals("SplitEntryTransaction")) {
            logger.finest("Found SplitEntryTransaction");
            this.splitEntryList.add(elementMap);
            return null;
        }
        Transaction transaction = null;
        Date actDate = this.decodeDate(elementMap.get("actTransDate"));
        Date date = this.decodeDate(elementMap.get("voucherDate"));
        String memo = elementMap.get("memo");
        String payee = elementMap.get("payee");
        String number = elementMap.get("number");
        CurrencyNode node = this.decodeCurrency(elementMap.get("commodity"));
        if (transactionClass.equals("AddXTransaction") || transactionClass.equals("RemoveXTransaction")) {
            price2 = new BigDecimal(elementMap.get("price"));
            quantity2 = new BigDecimal(elementMap.get("quantity"));
            investmentAccount = this.accountMap.get(elementMap.get("investmentAccount"));
            reconciled = Boolean.parseBoolean(elementMap.get("reconciled"));
            sNode = EngineFactory.getEngine("default").getSecurity(elementMap.get("security"));
            transaction = new InvestmentTransaction();
            entry = transactionClass.equals("AddXTransaction") ? new TransactionEntryAddX(investmentAccount, sNode, price2, quantity2) : new TransactionEntryRemoveX(investmentAccount, sNode, price2, quantity2);
            entry.setMemo(memo);
            transaction.setDate(date);
            transaction.setDateEntered(actDate);
            transaction.setPayee(payee);
            transaction.addTransactionEntry(entry);
            transaction.setReconciled(investmentAccount, reconciled ? ReconciledState.RECONCILED : ReconciledState.NOT_RECONCILED);
        }
        if (transactionClass.equals("SplitXTransaction") || transactionClass.equals("MergeXTransaction")) {
            price2 = new BigDecimal(elementMap.get("price"));
            quantity2 = new BigDecimal(elementMap.get("quantity"));
            investmentAccount = this.accountMap.get(elementMap.get("investmentAccount"));
            reconciled = Boolean.parseBoolean(elementMap.get("reconciled"));
            sNode = EngineFactory.getEngine("default").getSecurity(elementMap.get("security"));
            transaction = new InvestmentTransaction();
            entry = transactionClass.equals("SplitXTransaction") ? new TransactionEntrySplitX(investmentAccount, sNode, price2, quantity2) : new TransactionEntryMergeX(investmentAccount, sNode, price2, quantity2);
            entry.setMemo(memo);
            transaction.setDate(date);
            transaction.setDateEntered(actDate);
            transaction.setPayee(payee);
            transaction.addTransactionEntry(entry);
            transaction.setReconciled(investmentAccount, reconciled ? ReconciledState.RECONCILED : ReconciledState.NOT_RECONCILED);
        }
        if (transactionClass.equals("BuyXTransaction") || transactionClass.equals("SellXTransaction")) {
            fees = new BigDecimal(elementMap.get("fees"));
            price = new BigDecimal(elementMap.get("price"));
            quantity = new BigDecimal(elementMap.get("quantity"));
            Account investmentAccount2 = this.accountMap.get(elementMap.get("investmentAccount"));
            Account account = this.accountMap.get(elementMap.get("account"));
            boolean accountReconciled = Boolean.parseBoolean(elementMap.get("accountReconciled"));
            boolean investmentAccountReconciled = Boolean.parseBoolean(elementMap.get("investmentAccountReconciled"));
            SecurityNode sNode2 = EngineFactory.getEngine("default").getSecurity(elementMap.get("security"));
            BigDecimal exchangeRate = BigDecimal.ONE;
            if (sNode2 != null) {
                transaction = transactionClass.equals("BuyXTransaction") ? TransactionFactory.import1xBuyXTransaction(account, investmentAccount2, sNode2, price, quantity, exchangeRate, fees, date, memo) : TransactionFactory.import1xSellXTransaction(account, investmentAccount2, sNode2, price, quantity, exchangeRate, fees, date, memo);
                transaction.setDateEntered(actDate);
                transaction.setPayee(payee);
                transaction.setReconciled(investmentAccount2, investmentAccountReconciled ? ReconciledState.RECONCILED : ReconciledState.NOT_RECONCILED);
                transaction.setReconciled(account, accountReconciled ? ReconciledState.RECONCILED : ReconciledState.NOT_RECONCILED);
            }
        }
        if (transactionClass.equals("DividendTransaction")) {
            amount = new BigDecimal(elementMap.get("amount"));
            Account investmentAccount3 = this.accountMap.get(elementMap.get("investmentAccount"));
            Account account = this.accountMap.get(elementMap.get("account"));
            boolean accountReconciled = Boolean.parseBoolean(elementMap.get("accountReconciled"));
            boolean investmentAccountReconciled = Boolean.parseBoolean(elementMap.get("investmentAccountReconciled"));
            SecurityNode sNode3 = EngineFactory.getEngine("default").getSecurity(elementMap.get("security"));
            transaction = TransactionFactory.generateDividendXTransaction(investmentAccount3, investmentAccount3, account, sNode3, amount, amount.negate(), amount, date, memo, accountReconciled);
            ReconcileManager.reconcileTransaction(investmentAccount3, transaction, investmentAccountReconciled ? ReconciledState.RECONCILED : ReconciledState.NOT_RECONCILED);
            ReconcileManager.reconcileTransaction(account, transaction, accountReconciled ? ReconciledState.RECONCILED : ReconciledState.NOT_RECONCILED);
        }
        if (transactionClass.equals("ReinvestDivTransaction")) {
            fees = new BigDecimal(elementMap.get("fees"));
            price = new BigDecimal(elementMap.get("price"));
            quantity = new BigDecimal(elementMap.get("quantity"));
            SecurityNode sNode4 = EngineFactory.getEngine("default").getSecurity(elementMap.get("security"));
            Account investmentAccount4 = this.accountMap.get(elementMap.get("investmentAccount"));
            boolean reconciled2 = Boolean.parseBoolean(elementMap.get("reconciled"));
            transaction = new InvestmentTransaction();
            TransactionEntryReinvestDivX entry2 = new TransactionEntryReinvestDivX(investmentAccount4, sNode4, price, quantity);
            entry2.setMemo(memo);
            transaction.setDate(date);
            transaction.setDateEntered(actDate);
            transaction.setPayee(payee);
            transaction.addTransactionEntry(entry2);
            if (fees.compareTo(BigDecimal.ZERO) > 0) {
                TransactionEntry fTran = new TransactionEntry(investmentAccount4, fees.negate());
                fTran.setMemo(memo);
                fTran.setTransactionTag(TransactionTag.INVESTMENT_FEE);
                transaction.addTransactionEntry(fTran);
            }
            transaction.setReconciled(investmentAccount4, reconciled2 ? ReconciledState.RECONCILED : ReconciledState.NOT_RECONCILED);
        }
        if (transactionClass.equals("SingleEntryTransaction")) {
            amount = new BigDecimal(elementMap.get("amount"));
            Account account = this.accountMap.get(elementMap.get("account"));
            boolean reconciled3 = Boolean.parseBoolean(elementMap.get("reconciled"));
            transaction = TransactionFactory.generateSingleEntryTransaction(account, amount, date, reconciled3, memo, payee, number);
            transaction.setDateEntered(actDate);
        } else if (transactionClass.equals("DoubleEntryTransaction")) {
            Account creditAccount = this.accountMap.get(elementMap.get("creditAccount"));
            Account debitAccount = this.accountMap.get(elementMap.get("debitAccount"));
            BigDecimal amount2 = new BigDecimal(elementMap.get("amount"));
            boolean creditReconciled = Boolean.parseBoolean(elementMap.get("creditReconciled"));
            boolean debitReconciled = Boolean.parseBoolean(elementMap.get("debitReconciled"));
            transaction = new Transaction();
            transaction.setDate(date);
            transaction.setDateEntered(actDate);
            transaction.setNumber(number);
            transaction.setPayee(payee);
            TransactionEntry entry3 = new TransactionEntry();
            entry3.setMemo(memo);
            entry3.setCreditAccount(creditAccount);
            entry3.setDebitAccount(debitAccount);
            if (creditAccount.getCurrencyNode().equals(node)) {
                entry3.setCreditAmount(amount2);
            } else {
                BigDecimal exchangeRate = new BigDecimal(elementMap.get("exchangeRate"));
                entry3.setCreditAmount(amount2.multiply(exchangeRate));
            }
            if (debitAccount.getCurrencyNode().equals(node)) {
                entry3.setDebitAmount(amount2.negate());
            } else {
                BigDecimal exchangeRate = new BigDecimal(elementMap.get("exchangeRate"));
                entry3.setDebitAmount(amount2.multiply(exchangeRate).negate());
            }
            transaction.addTransactionEntry(entry3);
            transaction.setReconciled(creditAccount, creditReconciled ? ReconciledState.RECONCILED : ReconciledState.NOT_RECONCILED);
            transaction.setReconciled(debitAccount, debitReconciled ? ReconciledState.RECONCILED : ReconciledState.NOT_RECONCILED);
        }
        return transaction;
    }

    private void parseAccount(XMLStreamReader reader) {
        assert (reader.getAttributeCount() == 2);
        HashMap<String, Object> elementMap = new HashMap<String, Object>();
        QName parsingElement = reader.getName();
        String accountClass = reader.getAttributeValue(0);
        String accountId = reader.getAttributeValue(1);
        try {
            while (reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 1: {
                        String element = reader.getLocalName();
                        if (element.equals("securities")) {
                            logger.info("Parsing account securities");
                            elementMap.put("securities", this.parseAccountSecurities(reader));
                            break;
                        }
                        if (element.equals("amortize")) {
                            logger.info("Parsing amortize object");
                            elementMap.put("amortize", this.parseAmortizeObject(reader));
                            break;
                        }
                        if (element.equals("locked")) {
                            this.lockMap.put(accountId, Boolean.parseBoolean(reader.getElementText()));
                            break;
                        }
                        elementMap.put(element, reader.getElementText());
                        break;
                    }
                    case 2: {
                        if (!reader.getName().equals(parsingElement)) break;
                        logger.finest("Found the end of an Account");
                        Account account = this.generateAccount(accountClass, elementMap);
                        if (account != null) {
                            this.accountMap.put(accountId, account);
                            if (account.getAccountType() != AccountType.ROOT) {
                                this.parentMap.put(account, (String)elementMap.get("parentAccount"));
                            }
                            if (account.getAccountType() != AccountType.ROOT) {
                                Map amortizeObject;
                                Engine engine = EngineFactory.getEngine("default");
                                engine.addAccount(engine.getRootAccount(), account);
                                if (account.getAccountType() == AccountType.LIABILITY && (amortizeObject = (Map)elementMap.get("amortize")) != null) {
                                    AOThread t = new AOThread(account, amortizeObject);
                                    workQueue.add(t);
                                }
                            }
                        }
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            logger.severe("Error importing account id: " + accountId);
            logger.log(Level.SEVERE, e.toString(), e);
        }
    }

    private Map<String, String> parseAmortizeObject(XMLStreamReader reader) {
        HashMap<String, String> elementMap;
        block8: {
            elementMap = new HashMap<String, String>();
            QName parsingElement = reader.getName();
            try {
                while (reader.hasNext()) {
                    int event = reader.next();
                    switch (event) {
                        case 1: {
                            String element = reader.getLocalName();
                            elementMap.put(element, reader.getElementText());
                            break;
                        }
                        case 2: {
                            if (reader.getName().equals(parsingElement)) {
                                logger.finest("Found the end of the Amortize Object");
                                break block8;
                            } else {
                                break;
                            }
                        }
                    }
                }
            }
            catch (XMLStreamException e) {
                logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        return elementMap;
    }

    private String[] parseAccountSecurities(XMLStreamReader reader) {
        ArrayList<String> securities;
        block9: {
            assert (reader.getAttributeCount() == 2);
            securities = new ArrayList<String>();
            QName parsingElement = reader.getName();
            try {
                while (reader.hasNext()) {
                    int event = reader.next();
                    switch (event) {
                        case 1: {
                            securities.add(reader.getElementText());
                            break;
                        }
                        case 2: {
                            if (reader.getName().equals(parsingElement)) {
                                logger.finest("Found the end of the Account Securities");
                                break block9;
                            } else {
                                break;
                            }
                        }
                    }
                }
            }
            catch (XMLStreamException e) {
                logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        return securities.toArray(new String[securities.size()]);
    }

    private Account generateAccount(String accountClass, Map<String, Object> elementMap) {
        Engine engine = EngineFactory.getEngine("default");
        CurrencyNode node = this.decodeCurrency((String)elementMap.get("commodity"));
        if (accountClass.equals("RootAccount")) {
            engine.setDefaultCurrency(node);
            return engine.getRootAccount();
        }
        Account account = null;
        if (accountClass.equals("BankAccount")) {
            account = new Account(AccountType.BANK, node);
        } else if (accountClass.equals("ExpenseAccount")) {
            account = new Account(AccountType.EXPENSE, node);
        } else if (accountClass.equals("IncomeAccount")) {
            account = new Account(AccountType.INCOME, node);
        } else if (accountClass.equals("InvestmentAccount")) {
            account = new Account(AccountType.INVEST, node);
            String[] securities = (String[])elementMap.get("securities");
            if (securities != null) {
                for (String s : securities) {
                    SecurityNode sNode = this.decodeSecurity(s);
                    account.addSecurity(sNode);
                }
            }
        } else if (accountClass.equals("MutualFundAccount")) {
            account = new Account(AccountType.MUTUAL, node);
            String[] securities = (String[])elementMap.get("securities");
            if (securities != null) {
                for (String s : securities) {
                    SecurityNode sNode = this.decodeSecurity(s);
                    account.addSecurity(sNode);
                }
            }
        } else if (accountClass.equals("CreditAccount")) {
            account = new Account(AccountType.CREDIT, node);
        } else if (accountClass.equals("CashAccount")) {
            account = new Account(AccountType.CASH, node);
        } else if (accountClass.equals("EquityAccount")) {
            account = new Account(AccountType.EQUITY, node);
        } else if (accountClass.equals("LiabilityAccount")) {
            account = new Account(AccountType.LIABILITY, node);
        } else if (accountClass.equals("AssetAccount")) {
            account = new Account(AccountType.ASSET, node);
        }
        if (account != null) {
            account.setName((String)elementMap.get("name"));
            account.setDescription((String)elementMap.get("description"));
            account.setNotes((String)elementMap.get("notes"));
            account.setVisible(Boolean.parseBoolean((String)elementMap.get("visible")));
            account.setPlaceHolder(Boolean.parseBoolean((String)elementMap.get("placeHolder")));
            account.setAccountNumber((String)elementMap.get("code"));
        }
        return account;
    }

    private void parseCurrencyNode(XMLStreamReader reader) {
        HashMap<String, String> elementMap = new HashMap<String, String>();
        QName parsingElement = reader.getName();
        try {
            while (reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 1: {
                        String element = reader.getLocalName();
                        elementMap.put(element, reader.getElementText());
                        break;
                    }
                    case 2: {
                        if (!reader.getName().equals(parsingElement)) break;
                        logger.finest("Found the end of a CurrencyNode");
                        Engine engine = EngineFactory.getEngine("default");
                        if (engine.getCurrency((String)elementMap.get("symbol"), this.decodeLocale((String)elementMap.get("locale"))) == null) {
                            CurrencyNode node = new CurrencyNode();
                            node.setSymbol((String)elementMap.get("symbol"));
                            node.setDescription((String)elementMap.get("description"));
                            node.setLocale(this.decodeLocale((String)elementMap.get("locale")));
                            node.setPrefix((String)elementMap.get("prefix"));
                            node.setSuffix((String)elementMap.get("suffix"));
                            node.setScale(Byte.parseByte((String)elementMap.get("scale")));
                            engine.addCommodity(node);
                        }
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            logger.log(Level.SEVERE, e.toString(), e);
        }
    }

    private void parseCommodityNode(XMLStreamReader reader) {
        HashMap<String, String> elementMap = new HashMap<String, String>();
        QName parsingElement = reader.getName();
        try {
            while (reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 1: {
                        String element = reader.getLocalName();
                        elementMap.put(element, reader.getElementText());
                        break;
                    }
                    case 2: {
                        if (!reader.getName().equals(parsingElement)) break;
                        logger.finest("Found the end of a CommodtyNode");
                        Commodity node = new Commodity();
                        node.symbol = (String)elementMap.get("symbol");
                        node.description = (String)elementMap.get("description");
                        node.prefix = (String)elementMap.get("prefix");
                        node.suffix = (String)elementMap.get("suffix");
                        node.scale = Byte.parseByte((String)elementMap.get("scale"));
                        this.commodityMap.put(node.symbol, node);
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            logger.log(Level.SEVERE, e.toString(), e);
        }
    }

    private void parseSecurityNode(XMLStreamReader reader) {
        HashMap<String, String> elementMap = new HashMap<String, String>();
        List<SecurityHistoryNode> history = null;
        try {
            QName parsingElement = reader.getName();
            while (reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 1: {
                        if (reader.getLocalName().equals("history")) {
                            logger.finest("parse history");
                            history = this.parseHistoryNodes(reader);
                            break;
                        }
                        String element = reader.getLocalName();
                        elementMap.put(element, reader.getElementText());
                        break;
                    }
                    case 2: {
                        SecurityNode node;
                        if (!reader.getName().equals(parsingElement)) break;
                        logger.finest("Found the end of a SecurityNode");
                        Engine engine = EngineFactory.getEngine("default");
                        if (engine.getSecurity((String)elementMap.get("symbol")) == null) {
                            node = new SecurityNode(engine.getDefaultCurrency());
                            node.setSymbol((String)elementMap.get("symbol"));
                            node.setDescription((String)elementMap.get("description"));
                            node.setPrefix((String)elementMap.get("prefix"));
                            node.setSuffix((String)elementMap.get("suffix"));
                            node.setScale(Byte.parseByte((String)elementMap.get("scale")));
                            node.setQuoteSource(QuoteSource.YAHOO);
                            if (elementMap.get("reportedCurrency") != null) {
                                SecurityThread thread = new SecurityThread(node, (String)elementMap.get("reportedCurrency"));
                                workQueue.add(thread);
                            }
                            engine.addCommodity(node);
                        }
                        if (history != null && (node = engine.getSecurity((String)elementMap.get("symbol"))) != null) {
                            for (SecurityHistoryNode hNode : history) {
                                engine.addSecurityHistory(node, hNode);
                            }
                        }
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            logger.severe("Exception at element: " + reader.getName().toString());
            logger.log(Level.SEVERE, e.toString(), e);
        }
    }

    private List<SecurityHistoryNode> parseHistoryNodes(XMLStreamReader reader) {
        ArrayList<SecurityHistoryNode> list = new ArrayList<SecurityHistoryNode>();
        assert (reader.getAttributeCount() == 3);
        int count = Integer.parseInt(reader.getAttributeValue(2));
        logger.finest("Parsing " + count + " SecurityHistoryNodes");
        HashMap<String, String> elementMap = new HashMap<String, String>();
        QName parsingElement = null;
        try {
            while (reader.hasNext() && list.size() < count) {
                int event = reader.next();
                switch (event) {
                    case 1: {
                        if (reader.getAttributeCount() > 0 && reader.getAttributeValue(0).equals("SecurityHistoryNode")) {
                            parsingElement = reader.getName();
                            break;
                        }
                        String element = reader.getLocalName();
                        elementMap.put(element, reader.getElementText());
                        break;
                    }
                    case 2: {
                        if (!reader.getName().equals(parsingElement)) break;
                        SecurityHistoryNode hNode = new SecurityHistoryNode();
                        hNode.setDate(this.decodeDate((String)elementMap.get("date")));
                        hNode.setHigh(new BigDecimal((String)elementMap.get("high")));
                        hNode.setLow(new BigDecimal((String)elementMap.get("low")));
                        hNode.setPrice(new BigDecimal((String)elementMap.get("price")));
                        hNode.setVolume(Long.parseLong((String)elementMap.get("volume")));
                        elementMap.clear();
                        list.add(hNode);
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            logger.log(Level.SEVERE, e.toString(), e);
        }
        return list;
    }

    private SecurityNode decodeSecurity(String symbol) {
        Engine engine = EngineFactory.getEngine("default");
        SecurityNode sNode = engine.getSecurity(symbol);
        if (sNode == null) {
            Commodity cNode = this.commodityMap.get(symbol);
            if (cNode != null) {
                logger.info("Converting a commodity into a security: " + symbol);
                sNode = new SecurityNode(engine.getDefaultCurrency());
                sNode.setDescription(cNode.description);
                sNode.setPrefix(cNode.prefix);
                sNode.setSuffix(cNode.suffix);
                sNode.setScale(cNode.scale);
                sNode.setSymbol(cNode.symbol);
                sNode.setQuoteSource(QuoteSource.YAHOO);
                engine.addCommodity(sNode);
            } else {
                CurrencyNode currency = this.decodeCurrency(symbol);
                if (currency != null) {
                    logger.info("Converting a currency into a security");
                    sNode = new SecurityNode();
                    sNode.setDescription(currency.getDescription());
                    sNode.setPrefix(currency.getPrefix());
                    sNode.setSuffix(currency.getSuffix());
                    sNode.setScale(currency.getScale());
                    sNode.setSymbol(currency.getSymbol());
                    sNode.setReportedCurrencyNode(currency);
                    sNode.setQuoteSource(QuoteSource.YAHOO);
                    engine.addCommodity(sNode);
                }
            }
        }
        if (sNode == null) {
            logger.severe("Bad file, security " + symbol + " not mapped");
        }
        return sNode;
    }

    private CurrencyNode decodeCurrency(String currency) {
        if (this.currencyCache.containsKey(currency)) {
            return this.currencyCache.get(currency);
        }
        String[] split = currency.split("\\x2E");
        String symbol = split[0];
        StringBuilder locale = new StringBuilder();
        for (int i = 1; i < split.length; ++i) {
            locale.append(split[i]);
            if (i >= split.length - 1) continue;
            locale.append('.');
        }
        CurrencyNode node = EngineFactory.getEngine("default").getCurrency(symbol, EncodeDecode.decodeLocale(locale.toString()));
        if (node == null) {
            logger.info("Converting a commodity into a currency: " + symbol);
            Commodity cNode = this.commodityMap.get(symbol);
            if (cNode != null) {
                node = new CurrencyNode();
                node.setLocale(Locale.getDefault());
                node.setDescription(cNode.description);
                node.setPrefix(cNode.prefix);
                node.setSuffix(cNode.suffix);
                node.setScale(cNode.scale);
                node.setSymbol(cNode.symbol);
                EngineFactory.getEngine("default").addCommodity(node);
            } else {
                SecurityNode sNode = EngineFactory.getEngine("default").getSecurity(symbol);
                if (sNode != null) {
                    node = new CurrencyNode();
                    node.setLocale(Locale.getDefault());
                    node.setDescription(sNode.getDescription());
                    node.setPrefix(sNode.getPrefix());
                    node.setSuffix(sNode.getSuffix());
                    node.setScale(sNode.getScale());
                    node.setSymbol(sNode.getSymbol());
                    EngineFactory.getEngine("default").addCommodity(node);
                } else {
                    logger.log(Level.SEVERE, "Bad file, currency " + symbol + " not mapped", new Exception());
                }
            }
        }
        this.currencyCache.put(currency, node);
        return node;
    }

    private Date decodeDate(String date) {
        if (date != null) {
            int year = Integer.parseInt(date.substring(0, 4));
            int month = Integer.parseInt(date.substring(5, 7));
            int day = Integer.parseInt(date.substring(8, 10));
            int hour = Integer.parseInt(date.substring(11, 13));
            int minute = Integer.parseInt(date.substring(14, 16));
            int second = Integer.parseInt(date.substring(17, 19));
            int msecond = Integer.parseInt(date.substring(20));
            this.calendar.set(year, month - 1, day, hour, minute, second);
            this.calendar.set(14, msecond);
            return this.calendar.getTime();
        }
        return new Date();
    }

    private Locale decodeLocale(String locale) {
        return EncodeDecode.decodeLocale(locale);
    }

    private static class Commodity {
        String symbol;
        String description;
        String suffix;
        String prefix;
        byte scale;

        private Commodity() {
        }
    }

    private class AOThread
    extends Thread {
        Map<String, String> elementMap;
        Account liabilityAccount;

        public AOThread(Account liabilityAccount, Map<String, String> elementMap) {
            this.liabilityAccount = liabilityAccount;
            this.elementMap = elementMap;
        }

        @Override
        public void run() {
            assert (this.liabilityAccount != null && this.elementMap != null);
            AmortizeObject ao = new AmortizeObject();
            ao.setBankAccount((Account)Import.this.accountMap.get(this.elementMap.get("bankAccount")));
            ao.setDate(Import.this.decodeDate(this.elementMap.get("date")));
            if (this.elementMap.get("daysPerYear") != null) {
                ao.setDaysPerYear(new BigDecimal(this.elementMap.get("daysPerYear")));
            }
            ao.setFees(new BigDecimal(this.elementMap.get("fees")));
            ao.setFeesAccount((Account)Import.this.accountMap.get(this.elementMap.get("feesAccount")));
            ao.setInterestAccount((Account)Import.this.accountMap.get(this.elementMap.get("interestAccount")));
            ao.setInterestPeriods(Integer.parseInt(this.elementMap.get("compondingPeriods")));
            ao.setLength(Integer.parseInt(this.elementMap.get("length")));
            ao.setMemo(this.elementMap.get("memo"));
            ao.setPayee(this.elementMap.get("payee"));
            ao.setPaymentPeriods(Integer.parseInt(this.elementMap.get("paymentPeriods")));
            ao.setPrincipal(new BigDecimal(this.elementMap.get("principal")));
            ao.setRate(new BigDecimal(this.elementMap.get("rate")));
            ao.setUseDailyRate(Boolean.parseBoolean(this.elementMap.get("useDailyRate")));
            Engine engine = EngineFactory.getEngine("default");
            engine.setAmortizeObject(this.liabilityAccount, ao);
        }
    }

    private static class SecurityThread
    extends Thread {
        SecurityNode sNode;
        String cNode;

        public SecurityThread(SecurityNode sNode, String cNode) {
            assert (sNode != null && cNode != null);
            this.sNode = sNode;
            this.cNode = cNode;
        }

        @Override
        public void run() {
            try {
                SecurityNode clone = (SecurityNode)this.sNode.clone();
                Engine engine = EngineFactory.getEngine("default");
                CurrencyNode currencyNode = engine.getCurrency(this.cNode);
                if (currencyNode != null) {
                    clone.setReportedCurrencyNode(currencyNode);
                    engine.updateCommodity(this.sNode, clone);
                }
            }
            catch (CloneNotSupportedException e) {
                logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }
}

