/*
 * Decompiled with CFR 0.152.
 */
package jgnash.imports.qif;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import jgnash.imports.qif.QifReader;

public class QifUtils {
    public static final String US_FORMAT = "mm/dd/yyyy";
    public static final String EU_FORMAT = "dd/mm/yyyy";

    private QifUtils() {
    }

    public static Date parseDate(String sDate, String format) {
        Calendar cal = Calendar.getInstance();
        int month = cal.get(2);
        int day = cal.get(5);
        int year = cal.get(1);
        String[] chunks = sDate.split("/|'|\\.|-");
        if (US_FORMAT.equals(format)) {
            try {
                month = Integer.parseInt(chunks[0].trim());
                day = Integer.parseInt(chunks[1].trim());
                year = Integer.parseInt(chunks[2].trim());
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().severe(e.toString());
            }
        } else if (EU_FORMAT.equals(format)) {
            try {
                day = Integer.parseInt(chunks[0].trim());
                month = Integer.parseInt(chunks[1].trim());
                year = Integer.parseInt(chunks[2].trim());
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().severe(e.toString());
            }
        } else {
            Logger.getAnonymousLogger().severe("Invalid date format specified");
            return new Date();
        }
        if (year < 100) {
            year = year < 29 ? (year += 2000) : (year += 1900);
        }
        cal.set(year, month - 1, day, 0, 0, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static BigDecimal parseMoney(String money) {
        String sMoney = money;
        if (sMoney != null) {
            sMoney = sMoney.trim();
            try {
                BigDecimal bdMoney = new BigDecimal(sMoney);
                return bdMoney;
            }
            catch (NumberFormatException e) {
                String[] split = sMoney.split("\\D");
                if (split.length > 2) {
                    StringBuilder buf = new StringBuilder();
                    if (sMoney.startsWith("-")) {
                        buf.append('-');
                    }
                    for (int i = 0; i < split.length - 1; ++i) {
                        buf.append(split[i]);
                    }
                    buf.append('.');
                    buf.append(split[split.length - 1]);
                    try {
                        BigDecimal bdMoney = new BigDecimal(buf.toString());
                        return bdMoney;
                    }
                    catch (NumberFormatException e2) {
                        Logger l = Logger.getAnonymousLogger();
                        l.info("second parse attempt failed");
                        l.info(buf.toString());
                        l.info("falling back to rounding");
                    }
                }
                NumberFormat formatter = NumberFormat.getNumberInstance();
                try {
                    Number num = formatter.parse(sMoney);
                    BigDecimal bd = new BigDecimal(num.floatValue());
                    if (bd.scale() > 6) {
                        Logger l = Logger.getAnonymousLogger();
                        l.warning("-Warning-");
                        l.warning("Large scale detected in QifUtils.parseMoney");
                        l.warning("Truncating scale to 2 places");
                        l.warning(bd.toString());
                        bd = bd.setScale(2, 4);
                        l.warning(bd.toString());
                    }
                    return bd;
                }
                catch (ParseException ignored) {
                    Logger.getAnonymousLogger().severe("could not parse money: " + sMoney);
                }
            }
        }
        return BigDecimal.ZERO;
    }

    public static boolean isFullFile(File file) {
        boolean result = false;
        try {
            QifReader in = new QifReader(new FileReader(file));
            String line = in.readLine();
            while (line != null) {
                if (QifUtils.startsWith(line, "!Type:Class")) {
                    result = true;
                    break;
                }
                if (QifUtils.startsWith(line, "!Type:Cat")) {
                    result = true;
                    break;
                }
                if (QifUtils.startsWith(line, "!Account")) {
                    result = true;
                    break;
                }
                if (QifUtils.startsWith(line, "!Type:Memorized")) {
                    result = true;
                    break;
                }
                if (QifUtils.startsWith(line, "!Type:Security")) {
                    result = true;
                    break;
                }
                if (QifUtils.startsWith(line, "!Type:Prices")) {
                    result = true;
                    break;
                }
                if (QifUtils.startsWith(line, "!Type:Bank")) {
                    result = false;
                    break;
                }
                if (QifUtils.startsWith(line, "!Type:CCard")) {
                    result = false;
                    break;
                }
                if (QifUtils.startsWith(line, "!Type:Oth")) {
                    result = false;
                    break;
                }
                if (QifUtils.startsWith(line, "!Type:Cash")) {
                    result = false;
                    break;
                }
                if (!QifUtils.startsWith(line, "!Option:AutoSwitch") && !QifUtils.startsWith(line, "!Clear:AutoSwitch")) {
                    System.out.println("Error: " + line);
                    break;
                }
                line = in.readLine();
            }
            in.close();
            return result;
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not find file: " + file.getAbsolutePath());
            return false;
        }
        catch (IOException e) {
            System.err.println(e);
            return false;
        }
    }

    private static boolean startsWith(String source, String prefix) {
        return prefix.length() <= source.length() && source.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static String stripCategoryTags(String category) {
        if (category != null && category.contains("/")) {
            return category.split("/")[0];
        }
        return category;
    }
}

