/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.DateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import jgnash.ui.ThemeManager;
import jgnash.ui.register.RegisterFactory;
import jgnash.util.DateUtils;

public class FormattedJTable
extends JTable {
    private AtomicBoolean defaultSaved = new AtomicBoolean();
    protected int defaultAlignment;
    protected Font defaultFont;
    protected Color defaultColor;
    private boolean stripe = FormattedJTable.stripe();
    private DateFormat dateFormatter = DateUtils.getShortDateFormat();

    public FormattedJTable() {
    }

    public FormattedJTable(TableModel model) {
        super(model);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (c instanceof JLabel) {
            if (!this.defaultSaved.get()) {
                this.defaultAlignment = ((JLabel)c).getHorizontalAlignment();
                this.defaultFont = c.getFont();
                this.defaultColor = c.getForeground();
                this.defaultSaved.set(true);
            }
            c.setFont(this.defaultFont);
            c.setForeground(this.defaultColor);
            ((JLabel)c).setIcon(null);
            if (this.stripe) {
                if (FormattedJTable.isOdd(row)) {
                    c.setBackground(RegisterFactory.getOddColor());
                } else {
                    c.setBackground(RegisterFactory.getEvenColor());
                }
            }
            if (Date.class.isAssignableFrom(this.getColumnClass(column))) {
                ((JLabel)c).setHorizontalAlignment(this.defaultAlignment);
                ((JLabel)c).setText(this.dateFormatter.format(this.getModel().getValueAt(row, column)));
            } else if (Number.class.isAssignableFrom(this.getColumnClass(column))) {
                ((JLabel)c).setHorizontalAlignment(4);
            } else {
                ((JLabel)c).setHorizontalAlignment(this.defaultAlignment);
            }
        }
        return c;
    }

    private static boolean isOdd(int i) {
        return (i & 1) == 1;
    }

    private static boolean stripe() {
        if (ThemeManager.isLookAndFeelSubstance()) {
            return false;
        }
        return !ThemeManager.isLookAndFeelNimbus();
    }
}

