/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.awt.EventQueue;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JProgressBar;
import jgnash.util.Resource;

public class MemoryMonitor
extends JProgressBar {
    private int total;
    private int used;
    private int oldUsed;
    private static final int diff = 1;
    private Runtime runtime = Runtime.getRuntime();

    public MemoryMonitor() {
        this.setMinimum(0);
        this.setStringPainted(true);
        this.setToolTipText(Resource.get().getString("ToolTip.MemoryUsage"));
        this.setString(this.used + "/" + this.total + " MB");
        this.setFont(this.getFont().deriveFont(this.getFont().getSize2D() - 1.0f).deriveFont(0));
        final Runnable update = new Runnable(){

            @Override
            public void run() {
                MemoryMonitor.this.setMaximum(MemoryMonitor.this.total);
                MemoryMonitor.this.setValue(MemoryMonitor.this.used);
                MemoryMonitor.this.setString(MemoryMonitor.this.used + "/" + MemoryMonitor.this.total + " MB");
            }
        };
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                MemoryMonitor.this.total = (int)(MemoryMonitor.this.runtime.totalMemory() / 1024000L);
                MemoryMonitor.this.used = MemoryMonitor.this.total - (int)(MemoryMonitor.this.runtime.freeMemory() / 1024000L);
                if (MemoryMonitor.this.used < MemoryMonitor.this.oldUsed - 1 || MemoryMonitor.this.used > MemoryMonitor.this.oldUsed + 1) {
                    EventQueue.invokeLater(update);
                    MemoryMonitor.this.oldUsed = MemoryMonitor.this.used;
                }
            }
        }, 9L, 1000L);
    }
}

