/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import jgnash.util.Resource;

public class TimePeriodCombo
extends JComboBox {
    private int[] periods = TimePeriodCombo.getPeriods();

    public TimePeriodCombo() {
        String[] descriptions = TimePeriodCombo.getDescriptions();
        assert (this.periods.length == descriptions.length);
        this.setModel(new DefaultComboBoxModel<String>(descriptions));
    }

    static int[] getPeriods() {
        return new int[]{300000, 600000, 900000, 1800000, 3600000, 0x6DDD00, 28800000, 86400000, 0};
    }

    static String[] getDescriptions() {
        Resource rb = Resource.get();
        return new String[]{rb.getString("Period.5Min"), rb.getString("Period.10Min"), rb.getString("Period.15Min"), rb.getString("Period.30Min"), rb.getString("Period.1Hr"), rb.getString("Period.2Hr"), rb.getString("Period.8Hr"), rb.getString("Period.1Day"), rb.getString("Period.NextStart")};
    }

    public void setSelectedPeriod(int period) {
        for (int i = 0; i < this.periods.length; ++i) {
            if (period != this.periods[i]) continue;
            this.setSelectedIndex(i);
            break;
        }
    }

    public int getSelectedPeriod() {
        return this.periods[this.getSelectedIndex()];
    }
}

