/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.reconcile;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jgnash.engine.Account;
import jgnash.engine.Engine;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.text.CommodityFormat;
import jgnash.ui.UIApplication;
import jgnash.ui.components.FormattedJTable;
import jgnash.ui.reconcile.AbstractReconcileTableModel;
import jgnash.ui.reconcile.CreditModel;
import jgnash.ui.reconcile.DebitModel;
import jgnash.ui.register.RegisterFactory;
import jgnash.ui.util.DialogUtils;
import jgnash.ui.util.JTableUtils;
import jgnash.util.Resource;
import org.jdesktop.swingx.JXTitledPanel;

public class ReconcileDialog
extends JDialog
implements MessageListener,
ActionListener,
ListSelectionListener {
    private Account account;
    private Date openingDate;
    private BigDecimal openingBalance;
    private BigDecimal endingBalance;
    private JTable creditTable;
    private JTable debitTable;
    private AbstractReconcileTableModel creditModel;
    private AbstractReconcileTableModel debitModel;
    private JLabel creditTotalLabel;
    private JLabel debitTotalLabel;
    private JLabel differenceLabel;
    private JLabel targetBalanceLabel;
    private JButton cancelButton;
    private JButton finishButton;
    private JButton finishLaterButton;
    private JButton creditSelectAllButton;
    private JButton creditClearAllButton;
    private JButton debitSelectAllButton;
    private JButton debitClearAllButton;
    private JLabel openingBalanceLabel;
    private JLabel reconciledBalanceLabel;
    private NumberFormat numberFormat;
    private final Resource rb = Resource.get();

    public ReconcileDialog(Account reconcileAccount, Date openingDate, BigDecimal openingBalance, BigDecimal endingBalance) {
        super((Frame)UIApplication.getFrame(), false);
        this.account = reconcileAccount;
        this.endingBalance = endingBalance;
        this.openingBalance = openingBalance;
        this.openingDate = openingDate;
        this.numberFormat = CommodityFormat.getShortNumberFormat(this.account.getCurrencyNode());
        this.setTitle(this.rb.getString("Button.Reconcile") + " - " + this.account.getPathName());
        this.setDefaultCloseOperation(2);
        this.layoutMainPanel();
        DialogUtils.addBoundsListener(this);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTableUtils.packTable(ReconcileDialog.this.debitTable);
                JTableUtils.packTable(ReconcileDialog.this.creditTable);
            }
        });
        MessageBus.getInstance().registerListener(this, MessageChannel.ACCOUNT);
        MessageBus.getInstance().registerListener(this, MessageChannel.SYSTEM);
    }

    private void initComponents() {
        this.creditTotalLabel = new JLabel();
        this.debitTotalLabel = new JLabel();
        this.differenceLabel = new JLabel();
        this.openingBalanceLabel = new JLabel();
        this.targetBalanceLabel = new JLabel();
        this.reconciledBalanceLabel = new JLabel();
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.finishLaterButton = new JButton(this.rb.getString("Button.FinishLater"));
        this.finishButton = new JButton(this.rb.getString("Button.Finish"));
        this.creditSelectAllButton = new JButton(this.rb.getString("Button.SelectAll"));
        this.creditClearAllButton = new JButton(this.rb.getString("Button.ClearAll"));
        this.debitSelectAllButton = new JButton(this.rb.getString("Button.SelectAll"));
        this.debitClearAllButton = new JButton(this.rb.getString("Button.ClearAll"));
        this.creditModel = new CreditModel(this.account, this.openingDate);
        this.creditTable = this.createTable(this.creditModel);
        this.debitModel = new DebitModel(this.account, this.openingDate);
        this.debitTable = this.createTable(this.debitModel);
        this.openingBalanceLabel.setText(this.numberFormat.format(this.openingBalance));
        this.targetBalanceLabel.setText(this.numberFormat.format(this.endingBalance));
        this.updateCreditStatus();
        this.updateDebitStatus();
        this.updateStatus();
        this.finishButton.addActionListener(this);
        this.finishLaterButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.creditSelectAllButton.addActionListener(this);
        this.creditClearAllButton.addActionListener(this);
        this.debitSelectAllButton.addActionListener(this);
        this.debitClearAllButton.addActionListener(this);
    }

    private JTable createTable(AbstractReconcileTableModel model) {
        FormattedJTable table = new FormattedJTable(model);
        table.setFillsViewportHeight(true);
        table.getSelectionModel().setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(this);
        return table;
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("min:grow(0.5), 7dlu, min:grow(0.5)", "fill:min:g, 7dlu, p, 14dlu, p");
        layout.addGroupedColumn(1);
        layout.addGroupedColumn(3);
        CellConstraints cc = new CellConstraints();
        String[] columnNames = RegisterFactory.getCreditDebitTabNames(this.account);
        FormLayout dLayout = new FormLayout("fill:min:g(1.0)", "fill:min:g, 4dlu, p");
        JPanel dPanel = new JPanel((LayoutManager)dLayout);
        dPanel.add((Component)ReconcileDialog.buildTablePanel(columnNames[1], this.debitTotalLabel, this.debitTable), cc.xy(1, 1));
        dPanel.add((Component)ButtonBarFactory.buildLeftAlignedBar((JButton)this.debitSelectAllButton, (JButton)this.debitClearAllButton), cc.xy(1, 3));
        FormLayout cLayout = new FormLayout("fill:min:g(1.0)", "fill:min:g, 4dlu, p");
        JPanel cPanel = new JPanel((LayoutManager)cLayout);
        cPanel.add((Component)ReconcileDialog.buildTablePanel(columnNames[0], this.creditTotalLabel, this.creditTable), cc.xy(1, 1));
        cPanel.add((Component)ButtonBarFactory.buildLeftAlignedBar((JButton)this.creditSelectAllButton, (JButton)this.creditClearAllButton), cc.xy(1, 3));
        JPanel p = new JPanel((LayoutManager)layout);
        p.setBorder(Borders.DIALOG_BORDER);
        p.add((Component)dPanel, cc.xywh(1, 1, 1, 3));
        p.add((Component)cPanel, cc.xy(3, 1));
        p.add((Component)this.buildStatPanel(), cc.xy(3, 3));
        p.add((Component)ButtonBarFactory.buildRightAlignedBar((JButton)this.cancelButton, (JButton)this.finishLaterButton, (JButton)this.finishButton), cc.xywh(1, 5, 3, 1));
        this.getContentPane().add(p);
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    private JPanel buildStatPanel() {
        FormLayout layout = new FormLayout("left:p, 8dlu, right:65dlu:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.setRowGroupingEnabled(true);
        builder.append(this.rb.getString("Label.OpeningBalance"), (Component)this.openingBalanceLabel);
        builder.append(this.rb.getString("Label.TargetBalance"), (Component)this.targetBalanceLabel);
        builder.append(this.rb.getString("Label.ReconciledBalance"), (Component)this.reconciledBalanceLabel);
        builder.appendSeparator();
        builder.append(this.rb.getString("Label.Difference"), (Component)this.differenceLabel);
        return builder.getPanel();
    }

    private static JPanel buildTablePanel(String title, JLabel label, JTable table) {
        JPanel p = new JPanel(new BorderLayout());
        JPanel footer = new JPanel(new FlowLayout(2));
        footer.setBackground(SystemColor.inactiveCaptionBorder);
        footer.add(label);
        JScrollPane pane = new JScrollPane(table);
        pane.setBorder(new EmptyBorder(0, 0, 0, 0));
        pane.setHorizontalScrollBarPolicy(31);
        JXTitledPanel panel = new JXTitledPanel(title, (Container)pane);
        p.add((Component)panel, "Center");
        p.add((Component)footer, "South");
        return p;
    }

    private void closeDialog() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    @Override
    public void messagePosted(final Message event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (event.getEvent()) {
                    case ACCOUNT_REMOVE: {
                        if (!event.getObject(MessageProperty.ACCOUNT).equals(ReconcileDialog.this.account)) {
                            return;
                        }
                    }
                    case FILE_NEW_SUCCESS: 
                    case FILE_CLOSING: 
                    case FILE_LOAD_SUCCESS: {
                        ReconcileDialog.this.closeDialog();
                        break;
                    }
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.finishLaterButton || e.getSource() == this.finishButton) {
            this.closeDialog();
            this.creditModel.commitChanges();
            this.debitModel.commitChanges();
        } else if (e.getSource() == this.cancelButton) {
            this.closeDialog();
        } else if (e.getSource() == this.creditSelectAllButton) {
            this.creditModel.selectAll();
            this.updateCreditStatus();
            this.updateStatus();
        } else if (e.getSource() == this.creditClearAllButton) {
            this.creditModel.clearAll();
            this.updateCreditStatus();
            this.updateStatus();
        } else if (e.getSource() == this.debitSelectAllButton) {
            this.debitModel.selectAll();
            this.updateDebitStatus();
            this.updateStatus();
        } else if (e.getSource() == this.debitClearAllButton) {
            this.debitModel.clearAll();
            this.updateDebitStatus();
            this.updateStatus();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (e.getSource() == this.creditTable.getSelectionModel()) {
            if (this.creditTable.getSelectedRow() >= 0) {
                this.creditModel.toggleReconciledState(this.creditTable.getSelectedRow());
                this.creditTable.clearSelection();
                this.updateCreditStatus();
                this.updateStatus();
            }
        } else if (e.getSource() == this.debitTable.getSelectionModel() && this.debitTable.getSelectedRow() >= 0) {
            this.debitModel.toggleReconciledState(this.debitTable.getSelectedRow());
            this.debitTable.clearSelection();
            this.updateDebitStatus();
            this.updateStatus();
        }
    }

    private void updateCreditStatus() {
        this.creditTotalLabel.setText(this.numberFormat.format(this.creditModel.getReconciledTotal()));
    }

    private void updateDebitStatus() {
        this.debitTotalLabel.setText(this.numberFormat.format(this.debitModel.getReconciledTotal()));
    }

    private void updateStatus() {
        byte scale = this.account.getCurrencyNode().getScale();
        BigDecimal sum = this.creditModel.getReconciledTotal().add(this.debitModel.getReconciledTotal());
        BigDecimal reconciledBalance = sum.add(this.openingBalance);
        BigDecimal difference = this.endingBalance.subtract(reconciledBalance).abs().setScale((int)scale, Engine.getRoundingMode());
        this.reconciledBalanceLabel.setText(this.numberFormat.format(reconciledBalance));
        this.differenceLabel.setText(this.numberFormat.format(difference));
        this.finishLaterButton.setEnabled(difference.signum() != 0);
        this.finishButton.setEnabled(difference.signum() == 0);
    }
}

