/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import jgnash.engine.Account;
import jgnash.engine.ReconcileManager;
import jgnash.engine.ReconciledState;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;
import jgnash.engine.TransactionFactory;
import jgnash.engine.TransactionType;
import jgnash.ui.account.AccountListDialog;
import jgnash.ui.register.AbstractBankTransactionPanel;
import jgnash.ui.register.TransactionDialog;
import jgnash.ui.util.ValidationFactory;
import jgnash.util.Resource;

public class AdjustmentPanel
extends AbstractBankTransactionPanel {
    private JButton convertButton = new JButton(Resource.getIcon("/jgnash/resource/edit-redo.png"));

    protected AdjustmentPanel(Account account) {
        super(account);
        this.convertButton.setToolTipText(this.rb.getString("ToolTip.ConvertSEntry"));
        this.convertButton.addActionListener(this);
        this.layoutMainPanel();
        this.clearForm();
    }

    private void layoutMainPanel() {
        FormLayout layout = new FormLayout("right:d, $lcgap, 50dlu:g, 8dlu, right:d, $lcgap, max(48dlu;min)", "f:d, $lgap, f:d, $lgap, f:d, $lgap, f:d");
        layout.setRowGroups((int[][])new int[][]{{1, 3, 5, 7}});
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)layout);
        this.setBorder(Borders.DIALOG_BORDER);
        this.add("Label.Payee", (Object)cc.xy(1, 1));
        this.add((Component)this.payeeField, (Object)cc.xy(3, 1));
        this.add("Label.Number", (Object)cc.xy(5, 1));
        this.add((Component)this.numberField, (Object)cc.xy(7, 1));
        this.add("Label.Memo", (Object)cc.xy(1, 3));
        this.add((Component)this.memoField, (Object)cc.xy(3, 3));
        this.add("Label.Date", (Object)cc.xy(5, 3));
        this.add((Component)this.datePanel, (Object)cc.xy(7, 3));
        this.add((Component)this.reconciledButton, (Object)cc.xywh(1, 5, 3, 1));
        this.add("Label.Amount", (Object)cc.xy(5, 5));
        this.add((Component)ValidationFactory.wrap(this.amountField), (Object)cc.xy(7, 5));
        this.add((Component)ButtonBarFactory.buildHelpBar((JButton)this.convertButton, (JButton)this.enterButton, (JButton)this.cancelButton), (Object)cc.xywh(1, 7, 7, 1));
    }

    @Override
    protected Transaction buildTransaction() {
        return TransactionFactory.generateSingleEntryTransaction(this.account, this.amountField.getDecimal(), this.datePanel.getDate(), this.reconciledButton.isSelected(), this.memoField.getText(), this.payeeField.getText(), this.numberField.getText());
    }

    @Override
    public void modifyTransaction(Transaction t) {
        this.newTransaction(t);
        this.modTrans = t;
        this.convertButton.setEnabled(true);
    }

    @Override
    public void newTransaction(Transaction t) {
        TransactionEntry entry = t.getTransactionEntries().get(0);
        this.memoField.setText(entry.getMemo());
        this.amountField.setDecimal(entry.getCreditAmount());
        this.datePanel.setDate(t.getDate());
        this.numberField.setText(t.getNumber());
        this.payeeField.setText(t.getPayee());
        if (t.getReconciled(this.getAccount()) == ReconciledState.RECONCILED) {
            this.reconciledButton.setSelected(true);
        } else {
            this.reconciledButton.setSelected(false);
        }
    }

    @Override
    public void clearForm() {
        super.clearForm();
        this.convertButton.setEnabled(false);
    }

    @Override
    protected boolean canModifyTransaction(Transaction t) {
        return t.getTransactionType() == TransactionType.SINGLENTRY;
    }

    private void convertAction() {
        AccountListDialog d = new AccountListDialog();
        d.disableAccount(this.getAccount());
        d.disablePlaceHolders();
        d.setVisible(true);
        if (!d.getReturnStatus()) {
            return;
        }
        Account opp = d.getAccount();
        Transaction t = new Transaction();
        t.setDate(this.datePanel.getDate());
        t.setNumber(this.numberField.getText());
        t.setPayee(this.payeeField.getText());
        TransactionEntry entry = new TransactionEntry();
        entry.setMemo(this.memoField.getText());
        if (this.amountField.getDecimal().signum() >= 0) {
            entry.setCreditAccount(this.getAccount());
            entry.setDebitAccount(opp);
        } else {
            entry.setDebitAccount(this.getAccount());
            entry.setCreditAccount(opp);
        }
        entry.setCreditAmount(this.amountField.getDecimal().abs());
        entry.setDebitAmount(this.amountField.getDecimal().abs().negate());
        ReconcileManager.reconcileTransaction(this.getAccount(), t, this.reconciledButton.isSelected() ? ReconciledState.RECONCILED : ReconciledState.NOT_RECONCILED);
        t.addTransactionEntry(entry);
        Transaction tran = TransactionDialog.showDialog(this.getAccount(), t);
        if (tran != null) {
            if (AdjustmentPanel.getEngine().removeTransaction(this.modTrans)) {
                AdjustmentPanel.getEngine().addTransaction(tran);
            }
            this.clearForm();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.convertButton) {
            this.convertAction();
        }
    }
}

