/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import java.awt.event.ActionListener;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import jgnash.engine.Account;
import jgnash.engine.EngineFactory;
import jgnash.engine.ReconciledState;
import jgnash.engine.Transaction;
import jgnash.ui.register.DateChkNumberDialog;
import jgnash.util.DateUtils;
import jgnash.util.Resource;

public class DuplicateTransactionDialog
extends DateChkNumberDialog
implements ActionListener {
    private Transaction transaction;
    private SwingWorker<Transaction, Void> worker;

    protected static DuplicateTransactionDialog showDialog(Account a, Transaction t) {
        if (t != null) {
            DuplicateTransactionDialog d = new DuplicateTransactionDialog(a, t);
            d.setVisible(true);
            return d;
        }
        return null;
    }

    private DuplicateTransactionDialog(Account a, Transaction t) {
        super(a, Resource.get().getString("Title.DuplicateTransaction"));
        if (a == null) {
            throw new IllegalArgumentException("Account parameter was null");
        }
        if (t == null) {
            throw new IllegalArgumentException("Transaction parameter was null");
        }
        this.transaction = t;
        if (t.getNumber() != null && t.getNumber().length() > 0) {
            String n = a.getNextTransactionNumber();
            if (n != null) {
                this.numberCombo.setText(n);
            } else {
                this.numberCombo.setText(t.getNumber());
            }
        } else {
            this.numberCombo.setText(null);
        }
    }

    @Override
    public void okAction() {
        this.worker = new SwingWorker<Transaction, Void>(){

            @Override
            public Transaction doInBackground() {
                Transaction clone = null;
                try {
                    clone = (Transaction)DuplicateTransactionDialog.this.transaction.clone();
                    Date today = DateUtils.levelDate(new Date());
                    if (today.equals(DuplicateTransactionDialog.this.datePanel.getDate())) {
                        clone.setDate(new Date());
                    } else {
                        clone.setDate(DuplicateTransactionDialog.this.datePanel.getDate());
                    }
                    clone.setNumber(DuplicateTransactionDialog.this.numberCombo.getText());
                    clone.setReconciled(ReconciledState.NOT_RECONCILED);
                }
                catch (CloneNotSupportedException e) {
                    Logger.getLogger(DuplicateTransactionDialog.class.getName()).log(Level.SEVERE, e.toString(), e);
                }
                return clone;
            }

            @Override
            protected void done() {
                try {
                    Transaction clone = (Transaction)this.get();
                    EngineFactory.getEngine("default").addTransaction(clone);
                }
                catch (Exception e) {
                    Logger.getLogger(DuplicateTransactionDialog.class.getName()).log(Level.SEVERE, e.toString(), e);
                }
            }
        };
        this.worker.execute();
        super.okAction();
    }

    public Transaction getTransaction() {
        try {
            return this.worker.get();
        }
        catch (Exception e) {
            Logger.getLogger(DuplicateTransactionDialog.class.getName()).log(Level.SEVERE, e.toString(), e);
            return null;
        }
    }
}

