/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.table;

import java.math.BigDecimal;
import java.util.Date;
import jgnash.engine.Account;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.Transaction;
import jgnash.ui.register.table.AbstractRegisterTableModel;
import jgnash.ui.register.table.FullCommodityStyle;
import jgnash.ui.register.table.ShortCommodityStyle;

public class RegisterTableModel
extends AbstractRegisterTableModel {
    private static final long serialVersionUID = 4178160188729546976L;
    static final String split = rb.getString("Button.Splits");
    private static final int[] PREF_COLUMN_WEIGHTS = new int[]{0, 0, 20, 20, 20, 0, 0, 0, 0};
    static final Class<?>[] _clazz = new Class[]{Date.class, String.class, String.class, String.class, String.class, String.class, ShortCommodityStyle.class, ShortCommodityStyle.class, FullCommodityStyle.class};

    RegisterTableModel(Account account, String[] names, Class<?>[] clazz) {
        super(account, names, clazz);
        this.setPreferredColumnWeigths(PREF_COLUMN_WEIGHTS);
    }

    RegisterTableModel(Account account, String[] names) {
        super(account, names, _clazz);
        this.setPreferredColumnWeigths(PREF_COLUMN_WEIGHTS);
    }

    @Override
    protected Object getInternalValueAt(int row, int col) {
        Transaction t = this.getTransactionAt(row);
        BigDecimal amount = t.getAmount(this.account);
        int signum = amount.signum();
        switch (col) {
            case 0: {
                return t.getDate();
            }
            case 1: {
                return t.getNumber();
            }
            case 2: {
                return t.getPayee();
            }
            case 3: {
                return t.getMemo();
            }
            case 4: {
                if (t instanceof InvestmentTransaction) {
                    return ((InvestmentTransaction)t).getInvestmentAccount().getName();
                }
                if (t.size() > 1) {
                    return "[ " + t.size() + " " + split + " ]";
                }
                if (t.getTransactionEntries().get(0).getCreditAccount() != this.account) {
                    return t.getTransactionEntries().get(0).getCreditAccount().getName();
                }
                return t.getTransactionEntries().get(0).getDebitAccount().getName();
            }
            case 5: {
                return t.getReconciled(this.account).toString();
            }
            case 6: {
                if (signum >= 0) {
                    return amount;
                }
                return null;
            }
            case 7: {
                if (signum < 0) {
                    return amount.abs();
                }
                return null;
            }
            case 8: {
                return this.getBalanceAt(row);
            }
        }
        return "error";
    }
}

