/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report;

import ar.com.fdvs.dj.domain.constants.Font;
import java.text.NumberFormat;
import java.util.prefs.Preferences;
import jgnash.ui.report.FontRegistry;

public class ReportFactory {
    private static final String MONOSPACE = "monospace";
    private static final String PROPORTIONAL = "proportional";

    private ReportFactory() {
    }

    private static String getDefaultMonoFont() {
        String[] knownFonts;
        for (String knownFont : knownFonts = new String[]{"Courier New", "Andale Mono", "Bitstream Vera Sans Mono", "Luxi Mono", "Liberation Mono"}) {
            java.awt.Font f = new java.awt.Font(knownFont, 0, 1);
            if (!f.getFamily().equalsIgnoreCase(knownFont)) continue;
            return knownFont;
        }
        return "Monospaced";
    }

    private static String getDefaultProportionalFont() {
        String[] knownFonts;
        for (String knownFont : knownFonts = new String[]{"Times New Roman", "Bitstream Vera Serif", "Luxi Serif", "Liberation Serif"}) {
            java.awt.Font f = new java.awt.Font(knownFont, 0, 1);
            if (!f.getFamily().equalsIgnoreCase(knownFont)) continue;
            return knownFont;
        }
        return "SansSerif";
    }

    public static String getMonoFont() {
        Preferences p = Preferences.userNodeForPackage(ReportFactory.class);
        return p.get(MONOSPACE, ReportFactory.getDefaultMonoFont());
    }

    public static String getProportionalFont() {
        Preferences p = Preferences.userNodeForPackage(ReportFactory.class);
        return p.get(PROPORTIONAL, ReportFactory.getDefaultProportionalFont());
    }

    public static void setMonoFont(String font) {
        Preferences p = Preferences.userNodeForPackage(ReportFactory.class);
        p.put(MONOSPACE, font);
    }

    public static void setProportionalFont(String font) {
        Preferences p = Preferences.userNodeForPackage(ReportFactory.class);
        p.put(PROPORTIONAL, font);
    }

    private static Font buildFont(int size, String font, boolean bold, boolean italic, boolean underline) {
        Font f = new Font(size, font, bold, italic, underline);
        f.setFontName(font);
        String fontPath = FontRegistry.getRegisteredFontPath(font);
        if (fontPath != null) {
            f.setPdfFontEmbedded(true);
            f.setPdfFontName(fontPath);
            f.setPdfFontEncoding("Identity-H");
        }
        return f;
    }

    public static Font getDefaultProportionalFont(int size) {
        return ReportFactory.buildFont(size, ReportFactory.getProportionalFont(), false, false, false);
    }

    public static Font getDefaultProportionalFont(int size, boolean bold) {
        return ReportFactory.buildFont(size, ReportFactory.getProportionalFont(), bold, false, false);
    }

    public static Font getDefaultProportionalFont(int size, boolean bold, boolean italic) {
        return ReportFactory.buildFont(size, ReportFactory.getProportionalFont(), bold, italic, false);
    }

    public static Font getDefaultMonoFont(int size) {
        return ReportFactory.buildFont(size, ReportFactory.getMonoFont(), false, false, false);
    }

    public static Font getDefaultMonoFont(int size, boolean bold) {
        return ReportFactory.buildFont(size, ReportFactory.getMonoFont(), bold, false, false);
    }

    public static NumberFormat getQuantityFormat() {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(4);
        nf.setMinimumFractionDigits(4);
        return nf;
    }

    public static NumberFormat getPercentageFormat() {
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        return nf;
    }
}

