/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report.compiled;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jgnash.engine.Account;
import jgnash.engine.AccountType;
import jgnash.engine.CurrencyNode;
import jgnash.ui.components.DatePanel;
import jgnash.ui.components.FilteredAccountListComboBox;
import jgnash.ui.components.GenericCloseDialog;
import jgnash.ui.register.AccountBalanceDisplayManager;
import jgnash.util.DateUtils;
import jgnash.util.Resource;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.DateTickUnitType;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.ClusteredXYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class MonthlyAccountBalanceChartCompare {
    private FilteredAccountListComboBox combo1 = new FilteredAccountListComboBox(false, false);
    private FilteredAccountListComboBox combo2 = new FilteredAccountListComboBox(false, false);
    private Resource rb = Resource.get();
    private DatePanel startDateField = new DatePanel();
    private DatePanel endDateField = new DatePanel();
    private JCheckBox subAccountCheckBox;
    private JCheckBox hideLockedAccountCheckBox;
    private JCheckBox hidePlaceholderAccountCheckBox;
    private JCheckBox jcb_compare;

    public static void show() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Resource rb = Resource.get();
                MonthlyAccountBalanceChartCompare chart = new MonthlyAccountBalanceChartCompare();
                JPanel p = chart.createPanel();
                GenericCloseDialog d = new GenericCloseDialog(p);
                d.setTitle(rb.getString("Title.AccountBalance"));
                d.pack();
                d.setModal(false);
                d.setVisible(true);
            }
        });
    }

    private JPanel createPanel() {
        Date end = DateUtils.lastDayOfMonth(this.endDateField.getDate());
        Date start = DateUtils.previousYear(end);
        this.startDateField.setDate(start);
        JButton refreshButton = new JButton(this.rb.getString("Button.Refresh"));
        refreshButton.setIcon(Resource.getIcon("/jgnash/resource/view-refresh.png"));
        this.subAccountCheckBox = new JCheckBox(this.rb.getString("Button.IncludeSubcategory"));
        this.subAccountCheckBox.setSelected(true);
        this.hideLockedAccountCheckBox = new JCheckBox(this.rb.getString("Button.HideLockedAccount"));
        this.hidePlaceholderAccountCheckBox = new JCheckBox(this.rb.getString("Button.HidePlaceholderAccount"));
        this.jcb_compare = new JCheckBox(this.rb.getString("Button.Compare"));
        this.jcb_compare.setSelected(true);
        Account a = this.combo1.getSelectedAccount();
        Account a2 = this.combo2.getSelectedAccount();
        JFreeChart chart = this.createVerticalXYBarChart(a, a2);
        final ChartPanel chartPanel = new ChartPanel(chart);
        FormLayout layout = new FormLayout("p, 4dlu, p:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        FormLayout dLayout = new FormLayout("p, 4dlu, p, 8dlu, p, 4dlu, p, 8dlu, p", "");
        DefaultFormBuilder dBuilder = new DefaultFormBuilder(dLayout);
        dBuilder.append(this.rb.getString("Label.StartDate"), (Component)this.startDateField);
        dBuilder.append(this.rb.getString("Label.EndDate"), (Component)this.endDateField);
        dBuilder.append((Component)refreshButton);
        FormLayout cbLayout = new FormLayout("p, 4dlu, p, 4dlu, p, 4dlu", "");
        DefaultFormBuilder cbBuilder = new DefaultFormBuilder(cbLayout);
        cbBuilder.append((Component)this.subAccountCheckBox);
        cbBuilder.append((Component)this.hideLockedAccountCheckBox);
        cbBuilder.append((Component)this.hidePlaceholderAccountCheckBox);
        builder.append(this.rb.getString("Label.Account"), (Component)this.combo1);
        builder.nextLine();
        builder.append(this.rb.getString("Label.Compare"), (Component)this.combo2);
        builder.nextLine();
        builder.append((Component)this.jcb_compare);
        builder.append((Component)cbBuilder.getPanel());
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)dBuilder.getPanel(), 3);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.appendRow(RowSpec.decode((String)"fill:p:g"));
        builder.append((Component)chartPanel, 3);
        final JPanel panel = builder.getPanel();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Account account;
                    if (e.getSource() == MonthlyAccountBalanceChartCompare.this.jcb_compare) {
                        MonthlyAccountBalanceChartCompare.this.combo2.setEnabled(MonthlyAccountBalanceChartCompare.this.jcb_compare.isSelected());
                    }
                    if ((account = MonthlyAccountBalanceChartCompare.this.combo1.getSelectedAccount()) == null) {
                        return;
                    }
                    Account account2 = MonthlyAccountBalanceChartCompare.this.combo2.getSelectedAccount();
                    if (MonthlyAccountBalanceChartCompare.this.jcb_compare.isSelected() && account2 == null) {
                        return;
                    }
                    MonthlyAccountBalanceChartCompare.this.updateSubAccountBox();
                    chartPanel.setChart(MonthlyAccountBalanceChartCompare.this.createVerticalXYBarChart(account, account2));
                    panel.validate();
                }
                catch (Exception ex) {
                    System.out.println(ex);
                }
            }
        };
        this.combo1.addActionListener(listener);
        this.combo2.addActionListener(listener);
        this.jcb_compare.addActionListener(listener);
        this.subAccountCheckBox.addActionListener(listener);
        this.hideLockedAccountCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonthlyAccountBalanceChartCompare.this.combo1.setHideLocked(MonthlyAccountBalanceChartCompare.this.hideLockedAccountCheckBox.isSelected());
                MonthlyAccountBalanceChartCompare.this.combo2.setHideLocked(MonthlyAccountBalanceChartCompare.this.hideLockedAccountCheckBox.isSelected());
                try {
                    Account account = MonthlyAccountBalanceChartCompare.this.combo1.getSelectedAccount();
                    if (account == null) {
                        return;
                    }
                    Account account2 = MonthlyAccountBalanceChartCompare.this.combo2.getSelectedAccount();
                    if (MonthlyAccountBalanceChartCompare.this.jcb_compare.isSelected() && account2 == null) {
                        return;
                    }
                    MonthlyAccountBalanceChartCompare.this.updateSubAccountBox();
                    chartPanel.setChart(MonthlyAccountBalanceChartCompare.this.createVerticalXYBarChart(account, account2));
                    panel.validate();
                }
                catch (Exception ex) {
                    System.out.println(ex);
                }
            }
        });
        this.hidePlaceholderAccountCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonthlyAccountBalanceChartCompare.this.combo1.setHidePlaceholder(MonthlyAccountBalanceChartCompare.this.hidePlaceholderAccountCheckBox.isSelected());
                MonthlyAccountBalanceChartCompare.this.combo2.setHidePlaceholder(MonthlyAccountBalanceChartCompare.this.hidePlaceholderAccountCheckBox.isSelected());
                try {
                    Account account = MonthlyAccountBalanceChartCompare.this.combo1.getSelectedAccount();
                    if (account == null) {
                        return;
                    }
                    Account account2 = MonthlyAccountBalanceChartCompare.this.combo2.getSelectedAccount();
                    if (MonthlyAccountBalanceChartCompare.this.jcb_compare.isSelected() && account2 == null) {
                        return;
                    }
                    MonthlyAccountBalanceChartCompare.this.updateSubAccountBox();
                    chartPanel.setChart(MonthlyAccountBalanceChartCompare.this.createVerticalXYBarChart(account, account2));
                    panel.validate();
                }
                catch (Exception ex) {
                    System.out.println(ex);
                }
            }
        });
        refreshButton.addActionListener(listener);
        this.updateSubAccountBox();
        return panel;
    }

    private void updateSubAccountBox() {
        Account a = this.combo1.getSelectedAccount();
        if (a == null) {
            return;
        }
        if (a.getChildCount() == 0) {
            Account a2 = this.combo2.getSelectedAccount();
            if (this.combo2.isEnabled() && a2 != null && a2.getChildCount() > 0) {
                this.subAccountCheckBox.setEnabled(true);
            } else {
                this.subAccountCheckBox.setEnabled(false);
            }
        } else {
            this.subAccountCheckBox.setEnabled(true);
        }
    }

    private JFreeChart createVerticalXYBarChart(Account a, Account a2) {
        SimpleDateFormat df = new SimpleDateFormat("MM/yy");
        TimeSeriesCollection data = this.createTimeSeriesCollection(a, a2);
        DateAxis dateAxis = new DateAxis(this.rb.getString("Column.Date"));
        dateAxis.setTickUnit(new DateTickUnit(DateTickUnitType.MONTH, 1, (DateFormat)df));
        dateAxis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        Date start = DateUtils.firstDayOfMonth(this.startDateField.getDate());
        Date end = DateUtils.lastDayOfMonth(this.endDateField.getDate());
        dateAxis.setRange(start, end);
        NumberAxis valueAxis = new NumberAxis(this.rb.getString("Column.Balance") + "-" + a.getCurrencyNode().getSymbol());
        StandardXYToolTipGenerator tooltipGenerator = new StandardXYToolTipGenerator("{1}, {2}", (DateFormat)df, NumberFormat.getNumberInstance());
        ClusteredXYBarRenderer renderer = new ClusteredXYBarRenderer(0.2, false);
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)tooltipGenerator);
        XYPlot plot = new XYPlot((XYDataset)data, (ValueAxis)dateAxis, (ValueAxis)valueAxis, (XYItemRenderer)renderer);
        String title = this.jcb_compare.isSelected() ? a.getPathName() + " vs " + a2.getPathName() : this.rb.getString("Title.AccountBalance") + " - " + a.getPathName();
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        chart.setBackgroundPaint(null);
        return chart;
    }

    private TimeSeriesCollection createTimeSeriesCollection(Account account, Account a2) {
        Date start = DateUtils.firstDayOfMonth(this.startDateField.getDate());
        Date stop = DateUtils.lastDayOfMonth(this.endDateField.getDate());
        List<Date> list = DateUtils.lastDaysOfMonth(start, stop);
        TimeSeries t = new TimeSeries((Comparable)((Object)this.rb.getString("Column.Month")), this.rb.getString("Column.Month"), this.rb.getString("Column.Balance"));
        TimeSeries t2 = new TimeSeries((Comparable)((Object)this.rb.getString("Column.Month")), this.rb.getString("Column.Month"), this.rb.getString("Column.Balance"));
        for (Date aList : list) {
            Date d = DateUtils.lastDayOfMonth(aList);
            Date s = DateUtils.firstDayOfMonth(aList);
            BigDecimal bd_TotalAmount = MonthlyAccountBalanceChartCompare.calculateTotal(s, d, account, this.subAccountCheckBox.isSelected(), account.getCurrencyNode());
            t.add((RegularTimePeriod)new Month(aList), (Number)MonthlyAccountBalanceChartCompare.totalModulus(bd_TotalAmount, account.getAccountType()));
            if (!this.jcb_compare.isSelected()) continue;
            bd_TotalAmount = MonthlyAccountBalanceChartCompare.calculateTotal(s, d, a2, this.subAccountCheckBox.isSelected(), account.getCurrencyNode());
            t2.add((RegularTimePeriod)new Month(aList), (Number)MonthlyAccountBalanceChartCompare.totalModulus(bd_TotalAmount, a2.getAccountType()));
        }
        TimeSeriesCollection tsc = new TimeSeriesCollection();
        tsc.addSeries(t);
        if (this.jcb_compare.isSelected()) {
            tsc.addSeries(t2);
        }
        return tsc;
    }

    private static BigDecimal calculateTotal(Date start, Date end, Account account, boolean recursive, CurrencyNode baseCurrency) {
        AccountType type = account.getAccountType();
        BigDecimal amount = AccountBalanceDisplayManager.convertToSelectedBalanceMode(type, account.getBalance(start, end, baseCurrency));
        if (recursive) {
            for (Account child : account.getChildren()) {
                amount = amount.add(MonthlyAccountBalanceChartCompare.calculateTotal(start, end, child, recursive, baseCurrency));
            }
        }
        return amount;
    }

    private static BigDecimal totalModulus(BigDecimal amount, AccountType type) {
        if (type == AccountType.INCOME || type == AccountType.EQUITY || type == AccountType.CREDIT || type == AccountType.LIABILITY) {
            return amount.negate();
        }
        return amount;
    }
}

