/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report.jasper;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.HorizontalBandAlignment;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.AutoText;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJGroupLabel;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.LabelPosition;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import java.awt.Color;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import jgnash.text.CommodityFormat;
import jgnash.ui.StaticUIMethods;
import jgnash.ui.report.AbstractReportTableModel;
import jgnash.ui.report.ColumnHeaderStyle;
import jgnash.ui.report.ColumnStyle;
import jgnash.ui.report.FontUtilities;
import jgnash.ui.report.ReportFactory;
import jgnash.ui.report.ReportPrintFactory;
import jgnash.ui.report.jasper.DynamicJasperReportFrame;
import jgnash.ui.report.jasper.DynamicJasperReportPanel;
import jgnash.util.DateUtils;
import jgnash.util.Resource;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;

public abstract class DynamicJasperReport {
    protected Resource rb = Resource.get();
    private DynamicJasperReportPanel viewer;
    private static final String COLUMN_PROPERTY = "COLUMN_";
    private static final String BASE_FONT_SIZE = "baseFontSize";
    protected Logger logger = Logger.getLogger(DynamicJasperReport.class.getName());

    protected final void setViewer(DynamicJasperReportPanel viewer) {
        this.viewer = viewer;
    }

    protected void refreshReport() {
        this.viewer.refreshReport();
    }

    public final void showReport() {
        DynamicJasperReportFrame.viewReport(this);
    }

    public final void setPageFormat(PageFormat pageFormat) {
        ReportPrintFactory.savePageFormat(this, pageFormat);
    }

    public final PageFormat getPageFormat() {
        return ReportPrintFactory.getPageFormat(this);
    }

    final int getBaseFontSize() {
        Preferences p = this.getPreferences();
        return p.getInt(BASE_FONT_SIZE, 7);
    }

    final void setBaseFontSize(int size) {
        Preferences p = this.getPreferences();
        p.putInt(BASE_FONT_SIZE, size);
    }

    private Page assignPageFormat(DynamicReportBuilder builder) {
        int bottomMargin;
        int topMargin;
        int rightMargin;
        int leftMargin;
        Page page;
        PageFormat format = this.getPageFormat();
        Paper paper = format.getPaper();
        int orientation = format.getOrientation();
        if (orientation == 1) {
            page = new Page((int)paper.getHeight(), (int)paper.getWidth(), true);
            leftMargin = (int)paper.getImageableX();
            rightMargin = (int)paper.getWidth() - (int)paper.getImageableWidth() - leftMargin;
            topMargin = (int)paper.getImageableY();
            bottomMargin = (int)paper.getHeight() - (int)paper.getImageableHeight() - topMargin;
        } else {
            page = new Page((int)paper.getWidth(), (int)paper.getHeight(), false);
            rightMargin = (int)paper.getImageableY();
            leftMargin = (int)paper.getHeight() - (int)paper.getImageableHeight() - rightMargin;
            topMargin = (int)paper.getImageableX();
            bottomMargin = (int)paper.getWidth() - (int)paper.getImageableWidth() - topMargin;
        }
        builder.setPageSizeAndOrientation(page);
        builder.setMargins(topMargin, bottomMargin, leftMargin, rightMargin);
        return page;
    }

    public final Preferences getPreferences() {
        return Preferences.userNodeForPackage(this.getClass()).node(this.getClass().getSimpleName());
    }

    public abstract JasperPrint createJasperPrint(boolean var1);

    public abstract JPanel getReportController();

    public abstract String getReportName();

    public abstract String getGrandTotalLegend();

    public abstract String getGroupFooterLabel();

    public String getSubTitle() {
        DateFormat df = DateFormat.getDateInstance(1);
        return df.format(new Date());
    }

    private void buildTitle(DynamicReportBuilder drb) {
        Font font = ReportFactory.getDefaultProportionalFont(this.getBaseFontSize());
        Style titleStyle = new Style();
        titleStyle.setFont(ReportFactory.getDefaultProportionalFont(this.getBaseFontSize() + 8, true));
        titleStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        titleStyle.setVerticalAlign(VerticalAlign.BOTTOM);
        Style subtitleStyle = new Style();
        font.setItalic(true);
        subtitleStyle.setFont(font);
        subtitleStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        subtitleStyle.setVerticalAlign(VerticalAlign.TOP);
        drb.setTitleStyle(titleStyle);
        drb.setSubtitleStyle(subtitleStyle);
        drb.setTitle(this.getReportName());
        drb.setSubtitle(this.getSubTitle());
    }

    private Style getTypeHeaderStyle() {
        Style style = new Style();
        style.setFont(ReportFactory.getDefaultProportionalFont(this.getBaseFontSize() + 2, true));
        style.setHorizontalAlign(HorizontalAlign.LEFT);
        style.setBorderBottom(Border.THIN);
        style.setPaddingTop(this.getBaseFontSize());
        return style;
    }

    private Style getPageFooterStyle() {
        Style style = new Style();
        style.setFont(ReportFactory.getDefaultProportionalFont(this.getBaseFontSize(), false, true));
        return style;
    }

    private Style getTypeFooterStyle() {
        Style style = new Style();
        style.setFont(ReportFactory.getDefaultMonoFont(this.getBaseFontSize(), true));
        style.setHorizontalAlign(HorizontalAlign.RIGHT);
        style.setBorderTop(Border.THIN);
        return style;
    }

    private Style getGlobalFooterStyle() {
        Style style = new Style();
        style.setFont(ReportFactory.getDefaultMonoFont(this.getBaseFontSize(), true));
        style.setHorizontalAlign(HorizontalAlign.RIGHT);
        style.setBorderTop(Border.THIN);
        return style;
    }

    private Style getStyle(ColumnStyle style, boolean formatForCSV) {
        switch (style) {
            case SHORT_DATE: 
            case STRING: {
                Style stringStyle = new Style();
                stringStyle.setFont(ReportFactory.getDefaultMonoFont(this.getBaseFontSize()));
                stringStyle.setHorizontalAlign(HorizontalAlign.LEFT);
                if (!formatForCSV) {
                    stringStyle.setStretchWithOverflow(false);
                }
                return stringStyle;
            }
            case AMOUNT_SUM: 
            case BALANCE: 
            case BALANCE_WITH_SUM: 
            case BALANCE_WITH_SUM_AND_GLOBAL: 
            case PERCENTAGE: 
            case QUANTITY: 
            case SHORT_AMOUNT: {
                Style amountStyle = new Style();
                amountStyle.setFont(ReportFactory.getDefaultMonoFont(this.getBaseFontSize()));
                amountStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
                if (!formatForCSV) {
                    amountStyle.setStretchWithOverflow(false);
                }
                return amountStyle;
            }
            case CROSSTAB_TOTAL: {
                Style totalStyle = new Style();
                totalStyle.setFont(ReportFactory.getDefaultMonoFont(this.getBaseFontSize(), true));
                totalStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
                if (!formatForCSV) {
                    totalStyle.setStretchWithOverflow(false);
                }
                return totalStyle;
            }
            case GROUP: 
            case GROUP_NO_HEADER: {
                return this.getTypeHeaderStyle();
            }
        }
        System.err.println("Returning a null style");
        return null;
    }

    private Style getStyle(ColumnHeaderStyle style, boolean formatForCSV) {
        Style headerStyle = new Style();
        headerStyle.setFont(ReportFactory.getDefaultProportionalFont(this.getBaseFontSize() + 1, true));
        headerStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
        headerStyle.setBorderTop(Border.THIN);
        headerStyle.setBorderBottom(Border.THIN);
        headerStyle.setBackgroundColor(Color.decode("#E0E9F1"));
        headerStyle.setTransparency(Transparency.OPAQUE);
        headerStyle.setVerticalAlign(VerticalAlign.MIDDLE);
        if (!formatForCSV) {
            headerStyle.setStretchWithOverflow(false);
        }
        switch (style) {
            case LEFT: {
                headerStyle.setHorizontalAlign(HorizontalAlign.LEFT);
                break;
            }
            case CENTER: {
                headerStyle.setHorizontalAlign(HorizontalAlign.CENTER);
                break;
            }
            case RIGHT: {
                headerStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
                break;
            }
            case NONE: {
                headerStyle.setHorizontalAlign(HorizontalAlign.JUSTIFY);
            }
        }
        return headerStyle;
    }

    protected final JasperPrint createJasperPrint(AbstractReportTableModel model, boolean formatForCSV) {
        this.logger.info(this.rb.getString("Message.ProcessingReportData"));
        this.logger.info("Creating report builder");
        DynamicReportBuilder drb = new DynamicReportBuilder();
        try {
            int i;
            if (formatForCSV) {
                drb.setIgnorePagination(true);
            }
            AbstractColumn[] columns = new AbstractColumn[model.getColumnCount()];
            this.assignPageFormat(drb);
            drb.setHeaderHeight(this.getStyle(model.getColumnHeaderStyle(0), formatForCSV).getFont().getFontSize() * 2);
            drb.setDetailHeight(this.getBaseFontSize() * 2);
            this.logger.info("Creating column model for report");
            for (int i2 = 0; i2 < model.getColumnCount(); ++i2) {
                if (model.getColumnStyle(i2) != ColumnStyle.GROUP && model.getColumnStyle(i2) != ColumnStyle.GROUP_NO_HEADER) {
                    String pattern;
                    NumberFormat nf;
                    String pattern2;
                    Style columnTypeStyle = this.getStyle(model.getColumnStyle(i2), formatForCSV);
                    Style columnHeaderStyle = this.getStyle(model.getColumnHeaderStyle(i2), formatForCSV);
                    int width = FontUtilities.getStringWidth(model.getColumnPrototypeValueAt(i2), this.getTypeFooterStyle());
                    int hWidth = FontUtilities.getStringWidth(model.getColumnName(i2), columnHeaderStyle);
                    if (hWidth > width) {
                        width = hWidth;
                    }
                    ColumnBuilder builder = ColumnBuilder.getNew();
                    builder.setColumnProperty(COLUMN_PROPERTY + i2, model.getColumnClass(i2).getName());
                    builder.setTitle(model.getColumnName(i2));
                    builder.setWidth(width);
                    builder.setStyle(columnTypeStyle);
                    builder.setHeaderStyle(columnHeaderStyle);
                    builder.setTruncateSuffix("\u2026");
                    if (model.getColumnStyle(i2) == ColumnStyle.AMOUNT_SUM || model.getColumnStyle(i2) == ColumnStyle.BALANCE || model.getColumnStyle(i2) == ColumnStyle.BALANCE_WITH_SUM || model.getColumnStyle(i2) == ColumnStyle.BALANCE_WITH_SUM_AND_GLOBAL || model.getColumnStyle(i2) == ColumnStyle.CROSSTAB_TOTAL) {
                        pattern2 = CommodityFormat.getFullNumberPattern(model.getCurrency());
                        builder.setPattern(pattern2);
                    } else if (model.getColumnStyle(i2) == ColumnStyle.PERCENTAGE) {
                        nf = ReportFactory.getPercentageFormat();
                        pattern = ((DecimalFormat)nf).toPattern();
                        builder.setPattern(pattern);
                    } else if (model.getColumnStyle(i2) == ColumnStyle.QUANTITY) {
                        nf = ReportFactory.getQuantityFormat();
                        pattern = ((DecimalFormat)nf).toPattern();
                        builder.setPattern(pattern);
                    } else if (model.getColumnStyle(i2) == ColumnStyle.SHORT_DATE) {
                        pattern2 = ((SimpleDateFormat)DateUtils.getShortDateFormat()).toPattern();
                        builder.setPattern(pattern2);
                    } else if (model.getColumnStyle(i2) == ColumnStyle.SHORT_AMOUNT) {
                        pattern2 = CommodityFormat.getShortNumberPattern(model.getCurrency());
                        builder.setPattern(pattern2);
                    }
                    if (model.isColumnFixedWidth(i2) && !formatForCSV) {
                        builder.setFixedWidth(true);
                    }
                    columns[i2] = builder.build();
                    continue;
                }
                if (model.getColumnStyle(i2) != ColumnStyle.GROUP && model.getColumnStyle(i2) != ColumnStyle.GROUP_NO_HEADER) continue;
                ColumnBuilder builder = ColumnBuilder.getNew();
                builder.setColumnProperty(COLUMN_PROPERTY + i2, model.getColumnClass(i2).getName());
                builder.setTitle(model.getColumnName(i2));
                builder.setStyle(this.getTypeHeaderStyle());
                columns[i2] = builder.build();
            }
            boolean group = false;
            boolean header = true;
            this.logger.info("Searching for report groups");
            for (i = 0; i < model.getColumnCount(); ++i) {
                if (model.getColumnStyle(i) == ColumnStyle.GROUP) {
                    group = true;
                    break;
                }
                if (model.getColumnStyle(i) != ColumnStyle.GROUP_NO_HEADER) continue;
                group = true;
                header = false;
                break;
            }
            if (group) {
                this.logger.info("Building report groups");
                GroupBuilder gb = new GroupBuilder();
                gb.setDefaultHeaderVariableStyle(this.getTypeHeaderStyle());
                gb.setDefaultFooterVariableStyle(this.getTypeFooterStyle());
                for (int i3 = 0; i3 < model.getColumnCount(); ++i3) {
                    if (model.getColumnStyle(i3) == ColumnStyle.GROUP || model.getColumnStyle(i3) == ColumnStyle.GROUP_NO_HEADER) {
                        gb.setCriteriaColumn((PropertyColumn)columns[i3]);
                        continue;
                    }
                    if (model.getColumnStyle(i3) != ColumnStyle.AMOUNT_SUM && model.getColumnStyle(i3) != ColumnStyle.BALANCE_WITH_SUM && model.getColumnStyle(i3) != ColumnStyle.BALANCE_WITH_SUM_AND_GLOBAL && model.getColumnStyle(i3) != ColumnStyle.CROSSTAB_TOTAL) continue;
                    gb.addFooterVariable(columns[i3], DJCalculation.SUM);
                }
                if (header) {
                    gb.setGroupLayout(GroupLayout.VALUE_IN_HEADER);
                } else {
                    gb.setGroupLayout(GroupLayout.EMPTY);
                }
                if (this.getGroupFooterLabel() != null && this.getGroupFooterLabel().length() > 0) {
                    DJGroupLabel label = new DJGroupLabel(this.getGroupFooterLabel(), this.getTypeFooterStyle(), LabelPosition.LEFT);
                    gb.setFooterLabel(label);
                }
                DJGroup group1 = gb.build();
                boolean global = false;
                for (int i4 = 0; i4 < model.getColumnCount(); ++i4) {
                    AbstractColumn c = columns[i4];
                    drb.addColumn(c);
                    if (!model.getColumnStyle(i4).equals((Object)ColumnStyle.BALANCE_WITH_SUM_AND_GLOBAL) && !model.getColumnStyle(i4).equals((Object)ColumnStyle.CROSSTAB_TOTAL)) continue;
                    drb.addGlobalFooterVariable(c, DJCalculation.SUM, this.getTypeFooterStyle());
                    global = true;
                }
                drb.addGroup(group1);
                if (global) {
                    drb.setGrandTotalLegendStyle(this.getGlobalFooterStyle());
                    drb.setGrandTotalLegend(this.getGrandTotalLegend());
                }
            } else {
                for (i = 0; i < model.getColumnCount(); ++i) {
                    drb.addColumn(columns[i]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.buildTitle(drb);
        drb.setUseFullPageWidth(true);
        if (!formatForCSV) {
            Style footerStyle = this.getPageFooterStyle();
            AutoText date = new AutoText(3, 0, HorizontalBandAlignment.LEFT, 3);
            date.setStyle(footerStyle);
            AutoText pageNum = new AutoText(1, 0, HorizontalBandAlignment.RIGHT, 0, 80, 50);
            pageNum.setStyle(footerStyle);
            drb.addAutoText(date);
            drb.addAutoText(pageNum);
        }
        this.logger.info(this.rb.getString("Message.CompilingReport"));
        DynamicReport dr = drb.build();
        this.logger.info(this.rb.getString("Message.ReportCompileComplete"));
        JRTableModelDataSource ds = new JRTableModelDataSource((TableModel)model);
        JasperPrint jp = null;
        try {
            this.logger.info(this.rb.getString("Message.ReportCreateView"));
            jp = DynamicJasperHelper.generateJasperPrint(dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds);
        }
        catch (JRException e) {
            this.logger.log(Level.WARNING, "Exception", e);
            StaticUIMethods.displayError(this.rb.getString("Message.ReduceFont"));
        }
        return jp;
    }
}

