/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import jgnash.util.Resource;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;
import org.jdesktop.jxlayer.plaf.LayerUI;

public class ValidationFactory {
    private static Icon errorIcon = Resource.getIcon("/jgnash/resource/validation-error.png");
    public static final String VALIDATION_PROPERTY = "validationProperty";

    private ValidationFactory() {
    }

    public static JComponent wrap(JComponent component) {
        JXLayer layer = new JXLayer((Component)component);
        layer.setUI((LayerUI)new ValidationUI());
        return layer;
    }

    public static void showValidationError(String error, JComponent component) {
        Container parent = component.getParent();
        if (parent instanceof JXLayer) {
            component.putClientProperty(VALIDATION_PROPERTY, error);
            component.repaint();
        }
    }

    private static class ValidationUI
    extends AbstractLayerUI<JComponent> {
        private ValidationUI() {
        }

        protected void paintLayer(Graphics2D graphics, JXLayer<? extends JComponent> layer) {
            super.paintLayer(graphics, layer);
            if (((JComponent)layer.getView()).getClientProperty(ValidationFactory.VALIDATION_PROPERTY) != null) {
                JComponent view = (JComponent)layer.getView();
                String toolTip = (String)view.getClientProperty(ValidationFactory.VALIDATION_PROPERTY);
                view.setToolTipText(toolTip);
                errorIcon.paintIcon(view, graphics, 0, 0);
            }
        }

        protected void processMouseEvent(MouseEvent e, JXLayer<? extends JComponent> layer) {
            if (e.getID() == 500) {
                ((JComponent)layer.getView()).putClientProperty(ValidationFactory.VALIDATION_PROPERTY, null);
            }
        }

        protected void processKeyEvent(KeyEvent e, JXLayer<? extends JComponent> layer) {
            ((JComponent)layer.getView()).putClientProperty(ValidationFactory.VALIDATION_PROPERTY, null);
        }
    }
}

