/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fonts;

import java.awt.Font;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.SimpleFontFace;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRProperties;

public class SimpleFontFamily
implements FontFamily {
    private String name = null;
    private FontFace normalFace = null;
    private FontFace boldFace = null;
    private FontFace italicFace = null;
    private FontFace boldItalicFace = null;
    private String normalPdfFont = null;
    private String boldPdfFont = null;
    private String italicPdfFont = null;
    private String boldItalicPdfFont = null;
    private String pdfEncoding = null;
    private Boolean isPdfEmbedded = null;
    private String defaultExportFont = null;
    private Map exportFonts = null;
    private Set locales = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNormal(String normal) {
        this.normalFace = SimpleFontFamily.createFontFace(normal);
    }

    public void setBold(String bold) {
        this.boldFace = SimpleFontFamily.createFontFace(bold);
    }

    public void setItalic(String italic) {
        this.italicFace = SimpleFontFamily.createFontFace(italic);
    }

    public void setBoldItalic(String boldItalic) {
        this.boldItalicFace = SimpleFontFamily.createFontFace(boldItalic);
    }

    public FontFace getNormalFace() {
        return this.normalFace;
    }

    public FontFace getBoldFace() {
        return this.boldFace;
    }

    public FontFace getItalicFace() {
        return this.italicFace;
    }

    public FontFace getBoldItalicFace() {
        return this.boldItalicFace;
    }

    public String getNormalPdfFont() {
        return this.normalPdfFont;
    }

    public void setNormalPdfFont(String normalPdfFont) {
        this.normalPdfFont = normalPdfFont;
    }

    public String getBoldPdfFont() {
        return this.boldPdfFont;
    }

    public void setBoldPdfFont(String boldPdfFont) {
        this.boldPdfFont = boldPdfFont;
    }

    public String getItalicPdfFont() {
        return this.italicPdfFont;
    }

    public void setItalicPdfFont(String italicPdfFont) {
        this.italicPdfFont = italicPdfFont;
    }

    public String getBoldItalicPdfFont() {
        return this.boldItalicPdfFont;
    }

    public void setBoldItalicPdfFont(String boldItalicPdfFont) {
        this.boldItalicPdfFont = boldItalicPdfFont;
    }

    public String getPdfEncoding() {
        return this.pdfEncoding;
    }

    public void setPdfEncoding(String pdfEncoding) {
        this.pdfEncoding = pdfEncoding;
    }

    public Boolean isPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    public void setPdfEmbedded(Boolean isPdfEmbedded) {
        this.isPdfEmbedded = isPdfEmbedded;
    }

    public String getDefaultExportFont() {
        return this.defaultExportFont;
    }

    public void setDefaultExportFont(String defaultExportFont) {
        this.defaultExportFont = defaultExportFont;
    }

    public Map getExportFonts() {
        return this.exportFonts;
    }

    public void setExportFonts(Map exportFonts) {
        this.exportFonts = exportFonts;
    }

    public String getExportFont(String key) {
        String exportFont = this.exportFonts == null ? null : (String)this.exportFonts.get(key);
        return exportFont == null ? this.defaultExportFont : exportFont;
    }

    public Set getLocales() {
        return this.locales;
    }

    public void setLocales(Set locales) {
        this.locales = locales;
    }

    public boolean supportsLocale(Locale locale) {
        return this.locales == null || this.locales.contains(JRDataUtils.getLocaleCode(locale));
    }

    private static SimpleFontFace createFontFace(String value) {
        SimpleFontFace fontFace = null;
        if (value != null) {
            if (value.trim().toUpperCase().endsWith(".TTF")) {
                fontFace = new SimpleFontFace(value);
            } else {
                JRFontUtil.checkAwtFont(value, JRProperties.getBooleanProperty("net.sf.jasperreports.awt.ignore.missing.font"));
                fontFace = new SimpleFontFace(new Font(value, 0, JRProperties.getIntegerProperty("net.sf.jasperreports.default.font.size")));
            }
        }
        return fontFace;
    }
}

