#include "gamestock.h"
#include "defines.h"

GameStock * gameStock = 0;

GameStock::GameStock()
{
  Font8 = QFont("helvetica", 8);
  Font12 = QFont("helvetica", 12);
  Font20 = QFont("helvetica", 20);
  QFontMetrics fm20(Font20);
  if (fm20.boundingRect("0000000").width() > 120)
      Font20.setPointSize(16);
  Font40 = QFont("helvetica", 40);
  Font60 = QFont("helvetica", 60);

  GameCursor = QCursor(QPixmap(":/images/cursor_wand.png"), 0, 0);

  GameLogoBig = QPixmap(":/images/logo.png");
  MenuBackground = QPixmap(":/images/bg_menu.jpg");

  Concrete = QPixmap(":/images/con1.png");
  Target1 = QPixmap(":/images/target1.png");
  Target2 = QPixmap(":/images/target2.png");
  Block1 = QPixmap(":/images/block1.png");
  Block2 = QPixmap(":/images/block2.png");

  Clock = QPixmap(":/images/clock.png").scaled(48,48, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
  Score = QPixmap(":/images/score.png").scaled(48,48, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);

  for (int i = 0; i < MAX_ITEMS_COUNT; i++)
      Items.append(QPixmap(QString(":/images/item%1.png").arg(i+1)));
}
