#include "consttools.h"
#include "gamesound.h"
#include "gamewidget.h"
#include "gamestock.h"
#include "gamebonus.h"
#include "scene_if.h"

////////////////////////////////////////////////////////////////////////////////

ConstBonus::ConstBonus(int x, int y, int score, const QString &resource) :
    GameTool(x,y,score),
    bonusValue(0)
{
  myPixmap = QPixmap(GameWidget::getResourcePath() + "/bonus/" + resource + ".png")
             .scaled(48,48, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);

  smallPixmap = myPixmap.scaled(16,16, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
}

////////////////////////////////////////////////////////////////////////////////

// this increases bonus timer
TimerBonus::TimerBonus(int x, int y, int score) : ConstBonus(x,y, score, "timer")
{
  bonusInfo = new BonusInfo("Score-Time Bonus",
                            "Gives +1 extra second for every score-time bonus");
}

bool TimerBonus::checkToolClick()
{
  bonusValue += 2;
  scene->createPixmapPopup(980,160, 0,-1, myPixmap, 20);

  sndEngine->playSound(GameSound::sndBonusGot);
  return true;
}

void TimerBonus::advanceAndPaint(QPainter &p, int currentScore)
{
  if (bonusValue)
  {
    p.setOpacity(1);
    p.setPen(Qt::white);
    p.setFont(gameStock->Font8);

    p.drawPixmap(1000,158, smallPixmap);
    p.drawText(975,160, 25,20, Qt::AlignRight, QString("+%1").arg(bonusValue));
  }

    GameTool::advanceAndPaint(p, currentScore);
}

////////////////////////////////////////////////////////////////////////////////

// this increases magnifier
MagBonus::MagBonus(int x, int y, int score) : ConstBonus(x,y, score, "x")
{
  bonusInfo = new BonusInfo("Score-Magnification Bonus",
                            "Increases score magnifier by 1");
}

bool MagBonus::checkToolClick()
{
  bonusValue += 1;
  scene->createPixmapPopup(980,160, 0,-1, myPixmap, 20);

  sndEngine->playSound(GameSound::sndBonusGot);
  return true;
}

void MagBonus::advanceAndPaint(QPainter &p, int currentScore)
{
  if (bonusValue > 2)
  {
    p.setOpacity(1);
    p.setPen(Qt::white);
    p.setFont(gameStock->Font8);

    p.drawPixmap(965,158, smallPixmap);
    p.drawText(940,160, 25,20, Qt::AlignRight, QString("x%1").arg(bonusValue));
  }

   GameTool::advanceAndPaint(p, currentScore);
}

////////////////////////////////////////////////////////////////////////////////

// this gives +1 to score
ScoreBonus::ScoreBonus(int x, int y, int score) : ConstBonus(x,y, score, "score")
{
  bonusInfo = new BonusInfo("Score Bonus",
                            "Gives +1 extra point for every destroyed target or item");
}

bool ScoreBonus::checkToolClick()
{
  bonusValue += 1;
  scene->createPixmapPopup(980,10, 0,-1, myPixmap, 20);

  sndEngine->playSound(GameSound::sndBonusGot);
  return true;
}

void ScoreBonus::advanceAndPaint(QPainter &p, int currentScore)
{
  if (bonusValue)
  {
    p.setOpacity(1);
    p.setPen(Qt::white);
    p.setFont(gameStock->Font8);

    p.drawPixmap(1000,8, smallPixmap);
    p.drawText(975,10, 25,20, Qt::AlignRight, QString("+%1").arg(bonusValue));
  }

    GameTool::advanceAndPaint(p, currentScore);
}

////////////////////////////////////////////////////////////////////////////////

// this increases time for level
ClockBonus::ClockBonus(int x, int y, int score) : ConstBonus(x,y, score, "clock")
{
  bonusInfo = new BonusInfo("Time Bonus",
                            "Gives +30 extra seconds for every level");
}

bool ClockBonus::checkToolClick()
{
  bonusValue += 30;
  scene->createPixmapPopup(980,60, 0,-1, myPixmap, 20);

  sndEngine->playSound(GameSound::sndBonusGot);
  return true;
}

void ClockBonus::advanceAndPaint(QPainter &p, int currentScore)
{
  if (bonusValue)
  {
    p.setOpacity(1);
    p.setPen(Qt::white);
    p.setFont(gameStock->Font8);

    p.drawPixmap(1000,60, smallPixmap);
    p.drawText(975,60, 25,20, Qt::AlignRight, QString("+%1").arg(bonusValue));
  }

    GameTool::advanceAndPaint(p, currentScore);
}

////////////////////////////////////////////////////////////////////////////////
