#include "gamemenu.h"
#include "gameprofile.h"
#include "gamewidget.h"
#include "gamestock.h"

MenuWidget::MenuWidget(QWidget *parent) :
    QStackedWidget(parent)
{
    ui.setupUi(this);
    move(1024-width()-50, 150);
    setWindowOpacity(0.7);

    ui.twHall->setColumnWidth(0, 220);
    ui.twHall->horizontalHeader()->setStretchLastSection(true);
    ui.twHall->setRowCount(10);
    for (int i = 0; i < 10; i++) {
        ui.twHall->setItem(i, 0, new QTableWidgetItem(""));
        ui.twHall->setItem(i, 1, new QTableWidgetItem(""));
    }

    // set stylesheet
    QString stylepath = ":/style/style.css";
#ifdef Q_OS_WIN
    if (QSysInfo::WindowsVersion >= QSysInfo::WV_VISTA)
        stylepath = ":/style/style_vista.css";
#endif

    QString style = "";
    QFile f(stylepath);
    if (f.open(QIODevice::ReadOnly)) {
        QTextStream ts(&f);
        style = ts.readAll().simplified();
        f.close();
    }
    qApp->setStyleSheet(style);

    // load help file
    QSettings settings("xlabsoft","jag");
    QString helpfile = ":/help/" + settings.value("Helpfile", "index.htm").toString();

    QString helpstring = "";
    QFile fhelp(helpfile);
    if (fhelp.open(QIODevice::ReadOnly)) {
        QTextStream ts(&fhelp);
        helpstring = ts.readAll().simplified();
        fhelp.close();
    }
    ui.teHelp->setHtml(helpstring);

    connect(this, SIGNAL(currentChanged(int)), this, SLOT(on_currentChanged(int)));

    setCurrentIndex(MENU_MAIN);
    startAfterSelect = false;
    setMouseTracking(true);

    m_active = false;
    m_newplayer = m_renameplayer = false;

    buttonProfile = QRect((1024 - 800)/2,670, 200,30);
    buttonLevelpack = QRect((1024 - 800)/2+200,670, 300,30);
}

void MenuWidget::activate(bool en)
{
    m_active = en;
    if (en)
        showNormal();
    else
        hide();
}
/*
void MenuWidget::updateHallOfFame()
{
    QList<PlayerScore> topten = gameProfile->topTenList();

    for (int i = 0; i < 10; i++) {
        QString name = QString("%1. ").arg(i + 1, 2, 10, QChar(' '));
        int score = 0;
        if (i < topten.count()) {
            name += topten.at(i).name;
            score = topten.at(i).score;
        }
        QString s_score = QString("%1").arg(score, 7, 10, QChar('0'));
        if (score == 0)
            s_score = "-------";

        QTableWidgetItem *twi = ui.twHall->item(i, 0);
        if (twi)
            twi->setText(name);

        twi = ui.twHall->item(i, 1);
        if (twi) {
            twi->setText(s_score);
            twi->setTextAlignment(Qt::AlignCenter);
        }
    }
}
*/
void MenuWidget::on_currentChanged(int index)
{
    if (gameProfile->isGameStarted())
        move((1024-width())/2, 150);
    else
        move(1024-width()-50, 150);
}

QString MenuWidget::selectedLevelPack()
{
    QString qs;
    int row = ui.lwLevels->currentRow();
    if (row >= 0 && row < lpacks.count())
        qs = lpacks.at(row).section('.',0,0);
    else
        qs = gameProfile->currentLevelPack();
    return qs;
}

void MenuWidget::checkMenuMouseActions(const QPoint &pos)
{
    if (isActive() && !gameProfile->isGameStarted()) {
          if (buttonProfile.contains(pos))
              on_bOptProfile_clicked();
          else if (buttonLevelpack.contains(pos))
              on_bOptLevels_clicked();
      }
}


////////////////////////////////////////////////////////////////////////////////
ConfirmDialog::ConfirmDialog(QWidget *parent, Qt::WindowFlags f):
        QDialog(parent, Qt::FramelessWindowHint)
{
    QVBoxLayout *vbl = new QVBoxLayout();

    vbl->addSpacerItem(new QSpacerItem(1, 20));
    text = new QLabel("");
    text->setAlignment(Qt::AlignCenter);
    vbl->addWidget(text);
    vbl->addSpacerItem(new QSpacerItem(1, 20));

    QHBoxLayout *hbl = new QHBoxLayout();
    QPushButton *bNo = new QPushButton(tr("No"));
    connect(bNo, SIGNAL(clicked()), this, SLOT(onNoClicked()));
    hbl->addWidget(bNo);
    hbl->addSpacerItem(new QSpacerItem(40, 1));
    QPushButton *bYes = new QPushButton(tr("Yes"));
    connect(bYes, SIGNAL(clicked()), this, SLOT(onYesClicked()));
    hbl->addWidget(bYes);

    vbl->addLayout(hbl);
    setLayout(vbl);

    resize(500, 200);
    move((1024-width())/2, (768-height())/2);
    setWindowOpacity(0.7);
}

int ConfirmDialog::exec(const QString &qs)
{
    m_result = 0;
    text->setText(qs);

    QDialog::exec();
    return m_result;
}

void ConfirmDialog::onNoClicked()
{
    m_result = 0;
    close();
}

void ConfirmDialog::onYesClicked()
{
    m_result = 1;
    close();
}
