#include "gamescene.h"
#include "gameprofile.h"
#include "gamestock.h"
#include "gamestat.h"
#include "gamebonus.h"
#include "gametools.h"
#include "gamesound.h"

StatInfo::StatInfo()
{
  tool = 0;

  buttonOk = QRect(450,600,300,50);
  buttonCancel = QRect(100,600,300,50);

  buttons << buttonOk << buttonCancel;
}

void GameScene::showStatictics(STAT_CODE code)
{
  stat->tool = 0;
  stat->code = code;
  stat_active = true;

  advanceTimer->start();
  enableInput();

  if (code == STAT_LEVEL_WON || code == STAT_GAME_WON)
  {
    QTimer::singleShot(1000, this, SLOT(bonusTimeLeft()));

    LevelPackInfo *lpi = gameProfile->currentPlayer()->currentLevelPackInfo();
    lpi->localScore += time * BONUS_FOR_SECOND;
    lpi->score += time * BONUS_FOR_SECOND;
//    lpi->next_tool = toolset->activeToolIndex(lpi->score);

    // every 2nd level give a bonus
    if ((level-1) % 2 == 1 && !lpi->isPuzzle())
    {
      toolset->nextToolActivated();
      int idx = toolset->nextToolIndex();
      lpi->next_tool = idx;
      if (idx != ALL_TOOLS)
        stat->tool = toolset->tool(idx-1);
    }
    return;
  }
}

void GameScene::bonusTimeLeft()
{
  if (!stat_active)
    return;

  score += BONUS_FOR_SECOND;
  toolset->addScore(BONUS_FOR_SECOND);

  sndEngine->playSound(GameSound::sndBonus);

  if (time > 0) {
    --time;
    QTimer::singleShot(10, this, SLOT(bonusTimeLeft()));
  }
}

void GameScene::checkStatMouseActions(const QPoint &pos)
{
  if (stat->buttonCancel.contains(pos))
  {
    exitToMainMenu();
  }
  else
  if (stat->buttonOk.contains(pos))
  {
    runNextLevel();
  }
}

void GameScene::drawStatInfo(QPainter &p)
{
  drawTransRect(p, QRect(0+1,0+1,860-1,700-1), Qt::white, Qt::black, 0.9);

  p.setOpacity(1);

  p.setFont(gameStock->Font40);

  if (stat->code == STAT_LEVEL_WON)
  {
    p.drawText(0,0,860,80, Qt::AlignHCenter | Qt::AlignBottom,
               tr("Level %1 complete!").arg(level));

    p.setFont(gameStock->Font20);

    const int x1 = 200, x2 = 300, x3 = 600;
    const int y1 = 150, y2 = 250, y3 = 350;

    p.drawPixmap(x1,y1, gameStock->Clock);
    p.drawText(x3,y1+30, QString("%1:%2").arg(time/60, 2, 10, QChar('0')).arg(time%60, 2, 10, QChar('0')));

    p.drawPixmap(x1,y2, gameStock->Score);
    p.drawText(x3,y2+30, QString::number(/* stat->level_score */ score));

    p.drawPixmap(x1,y3, gameStock->Items.at(0));
    p.drawText(x3,y3+30, QString::number(gameBonus->collectedOnLevel()));

    p.setPen(QPen(Qt::yellow));
    p.drawText(x2,y1+30, tr("Time left:"));
    p.drawText(x2,y2+30, tr("Score:"));
    p.drawText(x2,y3+30, tr("Items collected:"));

    if (stat->tool)
    {
      p.setPen(QPen(Qt::white));
      p.drawText(QRect(0,500,900,30), Qt::AlignCenter,
                 tr("You got new %1: %2")
                 .arg(stat->tool->type() == GameTool::ConstTool ? tr("bonus") : tr("tool"))
                 .arg(stat->tool->info()->name)
                 );
      p.setFont(gameStock->Font12);
      p.drawText(QRect(0,530,900,30), Qt::AlignCenter,
                 stat->tool->info()->comment
                 );
    }
  }
  else if (stat->code == STAT_LEVEL_FAIL) // level failed
  {
    p.drawText(0,0,860,80, Qt::AlignHCenter | Qt::AlignBottom,
               tr("Level %1 failed!").arg(level));

    int percent = 0;
    if (stat->level_targets_all > 0)
        percent = (stat->level_targets_all - stat->level_targets_left)*100/stat->level_targets_all;
    p.setFont(gameStock->Font20);
    p.drawText(0,300,860,50, Qt::AlignCenter,
               tr("You have completed %1% of level %2.").arg(percent).arg(level));
    p.drawText(0,350,860,50, Qt::AlignCenter,
               tr("Next time you'll be more lucky!"));
  }
  else { // game won
    p.drawText(0,0,860,80, Qt::AlignHCenter | Qt::AlignBottom,
               tr("Congratulations!"));

    p.setFont(gameStock->Font20);

    p.drawText(0,100,860,50, Qt::AlignCenter,
               tr("You have completed all the levels and won the game!"));

    const int x1 = 200, x2 = 300, x3 = 600;
    const int y2 = 300, y3 = 400;

    p.drawPixmap(x1,y2, gameStock->Score);
    p.drawText(x3,y2+30, QString::number(score));

    p.drawPixmap(x1,y3, gameStock->Items.at(0));
    p.drawText(x3,y3+30, QString::number(gameBonus->collectedTotal()));

    p.setPen(QPen(Qt::yellow));
    p.drawText(x2,y2+30, tr("Total score:"));
    p.drawText(x2,y3+30, tr("Items collected:"));
  }

  // ok button
  if (stat->code != STAT_GAME_WON)
  {
    drawTransRect(p, stat->buttonOk, Qt::white, Qt::darkGray,
                  stat->buttonOk.contains(cursorPosition()) ? 0.3 : 0.1
                  );

    p.setOpacity(1);
    p.setPen(QPen(Qt::white));
    p.setFont(gameStock->Font20);
    p.drawText(stat->buttonOk, Qt::AlignCenter, stat->code == STAT_LEVEL_WON ? tr("Continue") : tr("Try Again"));
  }

  // cancel button
  stat->buttonCancel = (stat->code == STAT_GAME_WON) ? QRect(280,600,300,50) : QRect(100,600,300,50);

  drawTransRect(p, stat->buttonCancel, Qt::white, Qt::darkGray,
                stat->buttonCancel.contains(cursorPosition()) ? 0.3 : 0.1
                );

  p.setOpacity(1);
  p.setPen(QPen(Qt::white));
  p.setFont(gameStock->Font20);
  p.drawText(stat->buttonCancel, Qt::AlignCenter, tr("Exit to Menu"));
}
