/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.infonode.gui.ComponentPaintChecker;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.DimensionUtil;
import net.infonode.gui.EventUtil;
import net.infonode.gui.ScrollButtonBox;
import net.infonode.gui.draggable.DraggableComponent;
import net.infonode.gui.draggable.DraggableComponentBox;
import net.infonode.gui.draggable.DraggableComponentBoxEvent;
import net.infonode.gui.draggable.DraggableComponentBoxListener;
import net.infonode.gui.hover.HoverListener;
import net.infonode.gui.hover.panel.HoverableShapedPanel;
import net.infonode.gui.layout.DirectionLayout;
import net.infonode.gui.panel.BaseContainerUtil;
import net.infonode.gui.shaped.panel.ShapedPanel;
import net.infonode.properties.gui.InternalPropertiesUtil;
import net.infonode.properties.gui.util.ButtonProperties;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.properties.gui.util.ShapedPanelProperties;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabAreaComponentsProperties;
import net.infonode.tabbedpanel.TabAreaProperties;
import net.infonode.tabbedpanel.TabAreaVisiblePolicy;
import net.infonode.tabbedpanel.TabContentPanel;
import net.infonode.tabbedpanel.TabDepthOrderPolicy;
import net.infonode.tabbedpanel.TabDragEvent;
import net.infonode.tabbedpanel.TabDropDownListVisiblePolicy;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabLayoutPolicy;
import net.infonode.tabbedpanel.TabListener;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.tabbedpanel.TabSelectTrigger;
import net.infonode.tabbedpanel.TabStateChangedEvent;
import net.infonode.tabbedpanel.TabbedPanelButtonProperties;
import net.infonode.tabbedpanel.TabbedPanelContentPanel;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.TabbedUIDefaults;
import net.infonode.tabbedpanel.internal.ShadowPainter;
import net.infonode.tabbedpanel.internal.TabDropDownList;
import net.infonode.tabbedpanel.internal.TabbedHoverUtil;
import net.infonode.util.Direction;
import net.infonode.util.ValueChange;

public class TabbedPanel
extends JPanel {
    private int shadowSize = 4;
    private ComponentPaintChecker shadowRepaintChecker;
    private TabDropDownList dropDownList;
    private JComponent contentPanel;
    private JComponent[] tabAreaComponents;
    private Direction tabAreaOrientation;
    private TabDropDownListVisiblePolicy listVisiblePolicy = TabDropDownListVisiblePolicy.NEVER;
    private TabLayoutPolicy listTabLayoutPolicy = TabLayoutPolicy.SCROLLING;
    private DraggableComponentBox draggableComponentBox = new DraggableComponentBox(TabbedUIDefaults.getButtonIconSize(), false);
    private ArrayList listeners;
    private TabbedPanelProperties properties = new TabbedPanelProperties(TabbedPanelProperties.getDefaultProperties());
    private Tab highlightedTab;
    private boolean settingHighlighted;
    private boolean mouseEntered = false;
    private boolean removingSelected = false;
    private TabAreaVisiblePolicy areaVisiblePolicy = TabAreaVisiblePolicy.ALWAYS;
    private ShadowPanel componentsPanel = new ShadowPanel();
    private ScrollButtonBox scrollButtonBox;
    private GridBagConstraints constraints = new GridBagConstraints();
    private GridBagLayout tabAreaLayoutManager = new GridBagLayout(){

        public void layoutContainer(Container container) {
            TabbedPanel.this.setTabAreaComponentsButtonsVisible();
            super.layoutContainer(container);
            if (TabbedPanel.this.tabAreaComponentsPanel.isVisible()) {
                if (TabbedPanel.this.tabAreaOrientation.isHorizontal()) {
                    if ((double)TabbedPanel.this.tabAreaContainer.getHeight() < TabbedPanel.this.tabAreaComponentsPanel.getPreferredSize().getHeight()) {
                        TabbedPanel.this.draggableComponentBox.setSize(TabbedPanel.this.draggableComponentBox.getWidth(), 0);
                        TabbedPanel.this.tabAreaComponentsPanel.setSize(TabbedPanel.this.tabAreaComponentsPanel.getWidth(), TabbedPanel.this.tabAreaContainer.getHeight());
                    }
                } else if ((double)TabbedPanel.this.tabAreaContainer.getWidth() < TabbedPanel.this.tabAreaComponentsPanel.getPreferredSize().getWidth()) {
                    TabbedPanel.this.draggableComponentBox.setSize(0, TabbedPanel.this.draggableComponentBox.getHeight());
                    TabbedPanel.this.tabAreaComponentsPanel.setSize(TabbedPanel.this.tabAreaContainer.getWidth(), TabbedPanel.this.tabAreaComponentsPanel.getHeight());
                }
            }
            TabbedPanel.this.updateShadow();
        }
    };
    private HoverableShapedPanel tabAreaContainer = new HoverablePanel(this.tabAreaLayoutManager, this.properties.getTabAreaProperties().getHoverListener()){

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (TabbedPanel.this.getTabCount() == 0) {
                Insets insets = this.getInsets();
                Dimension dimension2 = TabbedPanel.this.tabAreaComponentsPanel.getPreferredSize();
                dimension = new Dimension(insets.left + insets.right + dimension2.width, insets.top + insets.bottom + dimension2.height);
            }
            return dimension;
        }
    };
    private HoverableShapedPanel tabAreaComponentsPanel = new HoverablePanel(new DirectionLayout(), this.properties.getTabAreaComponentsProperties().getHoverListener()){

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            Insets insets = this.getInsets();
            if (ComponentUtil.hasVisibleChildren(this)) {
                if (TabbedPanel.this.tabAreaOrientation.isHorizontal()) {
                    int n = ComponentUtil.getPreferredMaxWidth(this.getComponents()) + insets.left + insets.right;
                    return new Dimension(n, dimension.height);
                }
                int n = ComponentUtil.getPreferredMaxHeight(this.getComponents()) + insets.top + insets.bottom;
                return new Dimension(dimension.width, n);
            }
            return new Dimension(0, 0);
        }
    };
    private DraggableComponentBoxListener draggableComponentBoxListener = new DraggableComponentBoxListener(){
        private boolean selectedMoved;

        public void componentSelected(DraggableComponentBoxEvent draggableComponentBoxEvent) {
            if (draggableComponentBoxEvent.getDraggableComponent() == draggableComponentBoxEvent.getOldDraggableComponent()) {
                if (!this.selectedMoved && TabbedPanel.this.properties.getTabDeselectable()) {
                    TabbedPanel.this.draggableComponentBox.selectDraggableComponent(null);
                }
            } else {
                Tab tab = TabbedPanel.this.findTab(draggableComponentBoxEvent.getDraggableComponent());
                TabbedPanel.this.setHighlightedTab(tab);
                Tab tab2 = TabbedPanel.this.findTab(draggableComponentBoxEvent.getOldDraggableComponent());
                TabbedPanel.this.fireSelectedEvent(tab, tab2);
                if (TabbedPanel.this.removingSelected) {
                    TabbedPanel.this.removingSelected = false;
                    if (tab2 != null) {
                        tab2.setTabbedPanel(null);
                    }
                }
            }
            TabbedPanel.this.tabAreaContainer.repaint();
        }

        public void componentRemoved(DraggableComponentBoxEvent draggableComponentBoxEvent) {
            Tab tab = TabbedPanel.this.findTab(draggableComponentBoxEvent.getDraggableComponent());
            if (TabbedPanel.this.highlightedTab == tab) {
                TabbedPanel.this.highlightedTab = null;
            }
            TabbedPanel.this.setTabAreaComponentsButtonsVisible();
            TabbedPanel.this.updateTabAreaVisibility();
            TabbedPanel.this.tabAreaContainer.repaint();
            TabbedPanel.this.fireRemovedEvent(tab);
        }

        public void componentAdded(DraggableComponentBoxEvent draggableComponentBoxEvent) {
            TabbedPanel.this.updateTabAreaVisibility();
            TabbedPanel.this.tabAreaContainer.repaint();
            TabbedPanel.this.fireAddedEvent(TabbedPanel.this.findTab(draggableComponentBoxEvent.getDraggableComponent()));
        }

        public void componentDragged(DraggableComponentBoxEvent draggableComponentBoxEvent) {
            TabbedPanel.this.fireDraggedEvent(TabbedPanel.this.findTab(draggableComponentBoxEvent.getDraggableComponent()), draggableComponentBoxEvent.getDraggableComponentEvent().getMouseEvent());
        }

        public void componentDropped(DraggableComponentBoxEvent draggableComponentBoxEvent) {
            if (!TabbedPanel.this.draggableComponentBox.contains(draggableComponentBoxEvent.getDraggableComponentBoxPoint())) {
                TabbedPanel.this.setHighlightedTab(TabbedPanel.this.findTab(TabbedPanel.this.draggableComponentBox.getSelectedDraggableComponent()));
            }
            TabbedPanel.this.fireDroppedEvent(TabbedPanel.this.findTab(draggableComponentBoxEvent.getDraggableComponent()), draggableComponentBoxEvent.getDraggableComponentEvent().getMouseEvent());
        }

        public void componentDragAborted(DraggableComponentBoxEvent draggableComponentBoxEvent) {
            TabbedPanel.this.fireNotDroppedEvent(TabbedPanel.this.findTab(draggableComponentBoxEvent.getDraggableComponent()));
        }

        public void changed(DraggableComponentBoxEvent draggableComponentBoxEvent) {
            if (draggableComponentBoxEvent.getDraggableComponentEvent() != null) {
                int n = draggableComponentBoxEvent.getDraggableComponentEvent().getType();
                if (n == 1 && TabbedPanel.this.properties.getHighlightPressedTab()) {
                    if (TabbedPanel.this.highlightedTab != null) {
                        TabbedPanel.this.setHighlightedTab(TabbedPanel.this.findTab(draggableComponentBoxEvent.getDraggableComponent()));
                    }
                } else if (n == 2) {
                    this.selectedMoved = false;
                    TabbedPanel.this.setHighlightedTab(TabbedPanel.this.getSelectedTab());
                } else if (n == 4 && TabbedPanel.this.highlightedTab != null && TabbedPanel.this.highlightedTab.getDraggableComponent() == draggableComponentBoxEvent.getDraggableComponent()) {
                    TabbedPanel.this.setHighlightedTab(null);
                } else if (n == 3 && TabbedPanel.this.draggableComponentBox.getSelectedDraggableComponent() == draggableComponentBoxEvent.getDraggableComponent()) {
                    TabbedPanel.this.setHighlightedTab(TabbedPanel.this.findTab(draggableComponentBoxEvent.getDraggableComponent()));
                } else if (n == 0) {
                    TabbedPanel.this.tabAreaContainer.repaint();
                    this.selectedMoved = draggableComponentBoxEvent.getDraggableComponent() == TabbedPanel.this.draggableComponentBox.getSelectedDraggableComponent();
                    TabbedPanel.this.fireTabMoved(TabbedPanel.this.findTab(draggableComponentBoxEvent.getDraggableComponent()));
                }
            } else {
                TabbedPanel.this.tabAreaContainer.repaint();
            }
            TabbedPanel.this.updateShadow();
        }
    };
    private PropertyMapTreeListener propertyChangedListener = new PropertyMapTreeListener(){

        public void propertyValuesChanged(Map map) {
            TabbedPanel.this.updateProperties(map);
            TabbedPanel.this.updatePropertiesForTabArea(map);
            TabbedPanel.this.updatePropertiesForTabAreaComponentsArea(map);
            TabbedPanel.this.updatePropertiesForTabAreaComponentsButtons(map);
            TabbedPanel.this.updateScrollButtons();
            TabbedPanel.this.checkIfOnlyOneTab(true);
        }
    };

    private void updatePropertiesForTabAreaComponentsButtons(Map map) {
        AbstractButton[] abstractButtonArray;
        TabbedPanelButtonProperties tabbedPanelButtonProperties = this.properties.getButtonProperties();
        Map map2 = (Map)map.get(tabbedPanelButtonProperties.getTabDropDownListButtonProperties().getMap());
        if (map2 != null && this.dropDownList != null) {
            abstractButtonArray = this.dropDownList.getButton();
            if (map2.keySet().contains(ButtonProperties.FACTORY)) {
                abstractButtonArray = this.properties.getButtonProperties().getTabDropDownListButtonProperties().getFactory().createButton(this);
                this.dropDownList.setButton((AbstractButton)abstractButtonArray);
            }
            this.properties.getButtonProperties().getTabDropDownListButtonProperties().applyTo((AbstractButton)abstractButtonArray);
        }
        if (this.scrollButtonBox != null) {
            abstractButtonArray = new AbstractButton[]{this.scrollButtonBox.getUpButton(), this.scrollButtonBox.getDownButton(), this.scrollButtonBox.getLeftButton(), this.scrollButtonBox.getRightButton()};
            ButtonProperties[] buttonPropertiesArray = new ButtonProperties[]{tabbedPanelButtonProperties.getScrollUpButtonProperties(), tabbedPanelButtonProperties.getScrollDownButtonProperties(), tabbedPanelButtonProperties.getScrollLeftButtonProperties(), tabbedPanelButtonProperties.getScrollRightButtonProperties()};
            for (int i = 0; i < abstractButtonArray.length; ++i) {
                map2 = (Map)map.get(buttonPropertiesArray[i].getMap());
                if (map2 == null) continue;
                if (map2.keySet().contains(ButtonProperties.FACTORY)) {
                    abstractButtonArray[i] = buttonPropertiesArray[i].getFactory().createButton(this);
                }
                buttonPropertiesArray[i].applyTo(abstractButtonArray[i]);
            }
            this.scrollButtonBox.setButtons(abstractButtonArray[0], abstractButtonArray[1], abstractButtonArray[2], abstractButtonArray[3]);
        }
    }

    private void updateAllDefaultValues() {
        this.updateAllTabsProperties();
        this.draggableComponentBox.setScrollEnabled(this.properties.getTabLayoutPolicy() == TabLayoutPolicy.SCROLLING);
        this.updateTabDropDownList();
        this.draggableComponentBox.setScrollOffset(this.properties.getTabScrollingOffset());
        this.draggableComponentBox.setEnsureSelectedVisible(this.properties.getEnsureSelectedTabVisible());
        this.tabAreaOrientation = this.properties.getTabAreaOrientation();
        this.updatePropertiesForTabAreaLayoutConstraints();
        this.componentsPanel.add((Component)this.tabAreaContainer, ComponentUtil.getBorderLayoutOrientation(this.tabAreaOrientation));
        this.componentsPanel.revalidate();
        this.draggableComponentBox.setComponentSpacing(this.properties.getTabSpacing());
        this.draggableComponentBox.setDepthSortOrder(this.properties.getTabDepthOrderPolicy() == TabDepthOrderPolicy.DESCENDING);
        this.draggableComponentBox.setAutoSelect(this.properties.getAutoSelectTab());
        this.shadowSize = this.properties.getShadowSize();
        this.componentsPanel.setBorder(this.contentPanel != null && this.properties.getShadowEnabled() ? new EmptyBorder(0, 0, this.shadowSize, this.shadowSize) : null);
        this.componentsPanel.setHoverListener(this.properties.getHoverListener());
        this.tabAreaContainer.setHoverListener(this.properties.getTabAreaProperties().getHoverListener());
        ShapedPanelProperties shapedPanelProperties = this.properties.getTabAreaProperties().getShapedPanelProperties();
        this.properties.getTabAreaProperties().getComponentProperties().applyTo(this.tabAreaContainer);
        this.updateIntelligentInsets(this.tabAreaContainer, this.properties.getTabAreaProperties().getComponentProperties());
        this.updateShapedPanelProperties(this.tabAreaContainer, this.properties.getTabAreaProperties().getShapedPanelProperties());
        this.tabAreaComponentsPanel.setHoverListener(this.properties.getTabAreaComponentsProperties().getHoverListener());
        this.updatePropertiesForTabAreaLayoutConstraints();
        shapedPanelProperties = this.properties.getTabAreaComponentsProperties().getShapedPanelProperties();
        this.properties.getTabAreaComponentsProperties().getComponentProperties().applyTo(this.tabAreaComponentsPanel);
        this.updateIntelligentInsets(this.tabAreaComponentsPanel, this.properties.getTabAreaComponentsProperties().getComponentProperties());
        this.updateShapedPanelProperties(this.tabAreaComponentsPanel, shapedPanelProperties);
        this.tabAreaComponentsPanel.setHorizontalFlip(this.tabAreaOrientation == Direction.DOWN || this.tabAreaOrientation == Direction.LEFT ? !shapedPanelProperties.getHorizontalFlip() : shapedPanelProperties.getHorizontalFlip());
        this.tabAreaComponentsPanel.setVerticalFlip(shapedPanelProperties.getVerticalFlip());
        this.updatePanelOpaque();
    }

    private void updateProperties(Map map) {
        Map map2 = this.getMap(map, this.properties.getMap());
        if (map2 != null) {
            Set set = map2.keySet();
            if (set.contains(TabbedPanelProperties.TAB_REORDER_ENABLED) || map2.keySet().contains(TabbedPanelProperties.ABORT_DRAG_KEY) || map2.keySet().contains(TabbedPanelProperties.TAB_SELECT_TRIGGER)) {
                this.updateAllTabsProperties();
            }
            if (set.contains(TabbedPanelProperties.TAB_LAYOUT_POLICY) && this.getTabCount() > 1) {
                this.draggableComponentBox.setScrollEnabled((TabLayoutPolicy)((ValueChange)map2.get(TabbedPanelProperties.TAB_LAYOUT_POLICY)).getNewValue() == TabLayoutPolicy.SCROLLING);
            }
            if (set.contains(TabbedPanelProperties.TAB_DROP_DOWN_LIST_VISIBLE_POLICY)) {
                this.updateTabDropDownList();
            }
            if (set.contains(TabbedPanelProperties.TAB_SCROLLING_OFFSET)) {
                this.draggableComponentBox.setScrollOffset((Integer)((ValueChange)map2.get(TabbedPanelProperties.TAB_SCROLLING_OFFSET)).getNewValue());
            }
            if (set.contains(TabbedPanelProperties.ENSURE_SELECTED_VISIBLE)) {
                this.draggableComponentBox.setEnsureSelectedVisible((Boolean)((ValueChange)map2.get(TabbedPanelProperties.ENSURE_SELECTED_VISIBLE)).getNewValue());
            }
            if (set.contains(TabbedPanelProperties.TAB_AREA_ORIENTATION)) {
                this.tabAreaOrientation = (Direction)((ValueChange)map2.get(TabbedPanelProperties.TAB_AREA_ORIENTATION)).getNewValue();
                this.updatePropertiesForTabAreaLayoutConstraints();
                this.componentsPanel.remove(this.tabAreaContainer);
                this.componentsPanel.add((Component)this.tabAreaContainer, ComponentUtil.getBorderLayoutOrientation(this.tabAreaOrientation));
                this.componentsPanel.revalidate();
                this.properties.getTabAreaComponentsProperties().getComponentProperties().applyTo(this.tabAreaComponentsPanel);
                this.updateIntelligentInsets(this.tabAreaContainer, this.properties.getTabAreaProperties().getComponentProperties());
                this.tabAreaComponentsPanel.setDirection(this.tabAreaOrientation.getNextCW());
                this.updateIntelligentInsets(this.tabAreaComponentsPanel, this.properties.getTabAreaComponentsProperties().getComponentProperties());
            }
            if (set.contains(TabbedPanelProperties.TAB_SPACING)) {
                this.draggableComponentBox.setComponentSpacing((Integer)((ValueChange)map2.get(TabbedPanelProperties.TAB_SPACING)).getNewValue());
            }
            if (set.contains(TabbedPanelProperties.TAB_DEPTH_ORDER)) {
                this.draggableComponentBox.setDepthSortOrder((TabDepthOrderPolicy)((ValueChange)map2.get(TabbedPanelProperties.TAB_DEPTH_ORDER)).getNewValue() == TabDepthOrderPolicy.DESCENDING);
            }
            if (set.contains(TabbedPanelProperties.AUTO_SELECT_TAB)) {
                this.draggableComponentBox.setAutoSelect((Boolean)((ValueChange)map2.get(TabbedPanelProperties.AUTO_SELECT_TAB)).getNewValue());
            }
            if (set.contains(TabbedPanelProperties.SHADOW_ENABLED) || map2.keySet().contains(TabbedPanelProperties.SHADOW_STRENGTH) || map2.keySet().contains(TabbedPanelProperties.SHADOW_COLOR) || map2.keySet().contains(TabbedPanelProperties.SHADOW_BLEND_AREA_SIZE) || map2.keySet().contains(TabbedPanelProperties.SHADOW_SIZE) || map2.keySet().contains(TabbedPanelProperties.PAINT_TAB_AREA_SHADOW)) {
                this.shadowSize = this.properties.getShadowSize();
                this.componentsPanel.setBorder(this.contentPanel != null && this.properties.getShadowEnabled() ? new EmptyBorder(0, 0, this.shadowSize, this.shadowSize) : null);
            }
            if (set.contains(TabbedPanelProperties.HOVER_LISTENER)) {
                this.componentsPanel.setHoverListener((HoverListener)((ValueChange)map2.get(TabbedPanelProperties.HOVER_LISTENER)).getNewValue());
            }
        }
        this.updatePanelOpaque();
    }

    private void updatePropertiesForTabArea(Map map) {
        Map map2 = this.getMap(map, this.properties.getTabAreaProperties().getMap());
        if (map2 != null) {
            if (map2.keySet().contains(TabAreaProperties.HOVER_LISTENER)) {
                this.tabAreaContainer.setHoverListener((HoverListener)((ValueChange)map2.get(TabAreaProperties.HOVER_LISTENER)).getNewValue());
            }
            this.areaVisiblePolicy = this.getProperties().getTabAreaProperties().getTabAreaVisiblePolicy();
            this.updateTabAreaVisibility();
        }
        map2 = this.getMap(map, this.properties.getTabAreaProperties().getComponentProperties().getMap());
        Map map3 = this.getMap(map, this.properties.getTabAreaProperties().getShapedPanelProperties().getMap());
        if (map2 != null || map3 != null) {
            this.properties.getTabAreaProperties().getComponentProperties().applyTo(this.tabAreaContainer);
            this.updateIntelligentInsets(this.tabAreaContainer, this.properties.getTabAreaProperties().getComponentProperties());
            this.updateShapedPanelProperties(this.tabAreaContainer, this.properties.getTabAreaProperties().getShapedPanelProperties());
            this.repaint();
        }
    }

    private void updateIntelligentInsets(JComponent jComponent, ComponentProperties componentProperties) {
        Direction direction = this.properties.getTabAreaOrientation();
        Insets insets = componentProperties.getInsets();
        if (insets != null) {
            if (direction == Direction.RIGHT) {
                insets = new Insets(insets.left, insets.bottom, insets.right, insets.top);
            } else if (direction == Direction.DOWN) {
                insets = new Insets(insets.bottom, insets.left, insets.top, insets.right);
            } else if (direction == Direction.LEFT) {
                insets = new Insets(insets.left, insets.top, insets.right, insets.bottom);
            }
            Border border = componentProperties.getBorder();
            jComponent.setBorder(border != null ? new CompoundBorder(border, new EmptyBorder(insets)) : new EmptyBorder(insets));
        }
    }

    private void updatePropertiesForTabAreaComponentsArea(Map map) {
        Map map2 = this.getMap(map, this.properties.getTabAreaComponentsProperties().getMap());
        if (map2 != null) {
            if (map2.keySet().contains(TabAreaComponentsProperties.HOVER_LISTENER)) {
                this.tabAreaComponentsPanel.setHoverListener((HoverListener)((ValueChange)map2.get(TabAreaComponentsProperties.HOVER_LISTENER)).getNewValue());
            }
            if (map2.keySet().contains(TabAreaComponentsProperties.STRETCH_ENABLED)) {
                this.updatePropertiesForTabAreaLayoutConstraints();
            }
        }
        map2 = this.getMap(map, this.properties.getTabAreaComponentsProperties().getComponentProperties().getMap());
        Map map3 = this.getMap(map, this.properties.getTabAreaComponentsProperties().getShapedPanelProperties().getMap());
        if (map2 != null || map3 != null) {
            ShapedPanelProperties shapedPanelProperties = this.properties.getTabAreaComponentsProperties().getShapedPanelProperties();
            this.properties.getTabAreaComponentsProperties().getComponentProperties().applyTo(this.tabAreaComponentsPanel);
            this.updateIntelligentInsets(this.tabAreaComponentsPanel, this.properties.getTabAreaComponentsProperties().getComponentProperties());
            this.updateShapedPanelProperties(this.tabAreaComponentsPanel, shapedPanelProperties);
            this.tabAreaComponentsPanel.setHorizontalFlip(this.tabAreaOrientation == Direction.DOWN || this.tabAreaOrientation == Direction.LEFT ? !shapedPanelProperties.getHorizontalFlip() : shapedPanelProperties.getHorizontalFlip());
            this.tabAreaComponentsPanel.setVerticalFlip(shapedPanelProperties.getVerticalFlip());
        }
    }

    private void updatePropertiesForTabAreaLayoutConstraints() {
        boolean bl = this.properties.getTabAreaComponentsProperties().getStretchEnabled();
        if (this.tabAreaOrientation == Direction.UP) {
            this.setTabAreaLayoutConstraints(this.draggableComponentBox, 0, 0, 2, 1.0, 1.0, 15);
            this.setTabAreaLayoutConstraints(this.tabAreaComponentsPanel, 1, 0, bl ? 3 : 0, 0.0, 1.0, 15);
            this.updateTabAreaComponentsPanel(Direction.RIGHT, 0, 1);
        } else if (this.tabAreaOrientation == Direction.DOWN) {
            this.setTabAreaLayoutConstraints(this.draggableComponentBox, 0, 0, 2, 1.0, 1.0, 11);
            this.setTabAreaLayoutConstraints(this.tabAreaComponentsPanel, 1, 0, bl ? 3 : 0, 0.0, 0.0, 11);
            this.updateTabAreaComponentsPanel(Direction.RIGHT, 0, 0);
        } else if (this.tabAreaOrientation == Direction.LEFT) {
            this.setTabAreaLayoutConstraints(this.draggableComponentBox, 0, 0, 3, 1.0, 1.0, 13);
            this.setTabAreaLayoutConstraints(this.tabAreaComponentsPanel, 0, 1, bl ? 2 : 0, 0.0, 0.0, 13);
            this.updateTabAreaComponentsPanel(Direction.DOWN, 0, 0);
        } else {
            this.setTabAreaLayoutConstraints(this.draggableComponentBox, 0, 0, 3, 1.0, 1.0, 17);
            this.setTabAreaLayoutConstraints(this.tabAreaComponentsPanel, 0, 1, bl ? 2 : 0, 0.0, 0.0, 17);
            this.updateTabAreaComponentsPanel(Direction.DOWN, 0, 1);
        }
        this.draggableComponentBox.setComponentDirection(this.tabAreaOrientation);
    }

    private Map getMap(Map map, PropertyMap propertyMap) {
        return map != null ? (Map)map.get(propertyMap) : null;
    }

    private void updateTabAreaVisibility() {
        if (this.areaVisiblePolicy == TabAreaVisiblePolicy.ALWAYS) {
            this.tabAreaContainer.setVisible(true);
        } else if (this.areaVisiblePolicy == TabAreaVisiblePolicy.NEVER) {
            this.tabAreaContainer.setVisible(false);
        } else if (this.areaVisiblePolicy == TabAreaVisiblePolicy.MORE_THAN_ONE_TAB) {
            this.tabAreaContainer.setVisible(this.getTabCount() > 1);
        } else if (this.areaVisiblePolicy == TabAreaVisiblePolicy.TABS_EXIST) {
            this.tabAreaContainer.setVisible(this.getTabCount() > 0);
        }
        if (!this.tabAreaContainer.isVisible()) {
            this.tabAreaContainer.setSize(0, 0);
        }
    }

    public TabbedPanel() {
        this.initialize(new TabbedPanelContentPanel(this, new TabContentPanel(this)));
    }

    public TabbedPanel(JComponent jComponent) {
        this(jComponent, false);
    }

    public TabbedPanel(JComponent jComponent, boolean bl) {
        if (bl) {
            this.initialize(new TabbedPanelContentPanel(this, jComponent));
        } else {
            this.initialize(jComponent);
        }
    }

    public boolean tabAreaContainsPoint(Point point) {
        if (!this.tabAreaContainer.isVisible()) {
            return false;
        }
        return this.tabAreaContainer.contains(SwingUtilities.convertPoint(this, point, this.tabAreaContainer));
    }

    public boolean contentAreaContainsPoint(Point point) {
        return this.contentPanel != null ? this.contentPanel.contains(SwingUtilities.convertPoint(this, point, this.contentPanel)) : false;
    }

    public boolean isTabAreaVisible() {
        return this.tabAreaContainer.isVisible();
    }

    public void addTab(Tab tab) {
        this.doInsertTab(tab, null, -1);
    }

    public void insertTab(Tab tab, int n) {
        this.doInsertTab(tab, null, n);
    }

    public void insertTab(Tab tab, Point point) {
        this.doInsertTab(tab, point, -1);
    }

    public void removeTab(Tab tab) {
        if (tab != null && tab.getTabbedPanel() == this) {
            if (this.getSelectedTab() != tab) {
                tab.setTabbedPanel(null);
            } else {
                this.removingSelected = true;
            }
            this.draggableComponentBox.removeDraggableComponent(tab.getDraggableComponent());
        }
        this.checkIfOnlyOneTab(false);
    }

    public void moveTab(Tab tab, Point point) {
        this.draggableComponentBox.dragDraggableComponent(tab.getDraggableComponent(), SwingUtilities.convertPoint(this, point, this.draggableComponentBox));
    }

    public void setSelectedTab(Tab tab) {
        if (this.getSelectedTab() == tab) {
            return;
        }
        if (tab != null) {
            if (tab.isEnabled() && this.getTabIndex(tab) > -1) {
                if (tab.getDraggableComponent() == this.draggableComponentBox.getSelectedDraggableComponent()) {
                    this.setHighlightedTab(tab);
                } else {
                    tab.setSelected(true);
                }
            }
        } else {
            this.draggableComponentBox.selectDraggableComponent(null);
        }
    }

    public Tab getSelectedTab() {
        return this.findTab(this.draggableComponentBox.getSelectedDraggableComponent());
    }

    public void setHighlightedTab(Tab tab) {
        if (!this.settingHighlighted) {
            this.settingHighlighted = true;
            Tab tab2 = this.highlightedTab;
            Tab tab3 = null;
            if (tab2 != tab) {
                this.draggableComponentBox.setTopComponent(tab != null ? tab.getDraggableComponent() : null);
            }
            if (tab != null) {
                if (this.getTabIndex(tab) > -1) {
                    this.highlightedTab = tab;
                    if (tab2 != null && tab2 != tab) {
                        tab2.setHighlighted(false);
                    }
                    if (tab2 != tab) {
                        if (tab.isEnabled()) {
                            tab.setHighlighted(true);
                        } else {
                            tab.setHighlighted(false);
                            this.highlightedTab = null;
                        }
                    }
                    if (tab.isEnabled() && tab != tab2) {
                        tab3 = tab;
                    }
                    if (tab2 != tab) {
                        this.fireHighlightedEvent(tab3, tab2);
                    }
                }
            } else if (tab2 != null) {
                this.highlightedTab = null;
                tab2.setHighlighted(false);
                this.fireHighlightedEvent(null, tab2);
            }
            this.updateShadow();
            this.settingHighlighted = false;
        }
    }

    public Tab getHighlightedTab() {
        return this.highlightedTab;
    }

    public int getTabCount() {
        return this.draggableComponentBox.getDraggableComponentCount();
    }

    public Tab getTabAt(int n) {
        DraggableComponent draggableComponent = this.draggableComponentBox.getDraggableComponentAt(n);
        return draggableComponent == null ? null : (Tab)draggableComponent.getComponent();
    }

    public int getTabIndex(Tab tab) {
        return tab == null ? -1 : this.draggableComponentBox.getDraggableComponentIndex(tab.getDraggableComponent());
    }

    public void scrollTabToVisibleArea(Tab tab) {
        if (tab.getTabbedPanel() == this) {
            this.draggableComponentBox.scrollToVisible(tab.getDraggableComponent());
        }
    }

    public void setTabAreaComponents(JComponent[] jComponentArray) {
        int n;
        if (this.tabAreaComponents != null) {
            for (n = 0; n < this.tabAreaComponents.length; ++n) {
                this.tabAreaComponentsPanel.remove(this.tabAreaComponents[n]);
            }
        }
        JComponent[] jComponentArray2 = this.tabAreaComponents = jComponentArray == null ? null : (JComponent[])jComponentArray.clone();
        if (jComponentArray != null) {
            for (n = 0; n < jComponentArray.length; ++n) {
                this.tabAreaComponentsPanel.add(jComponentArray[n]);
            }
        }
        this.setTabAreaComponentsButtonsVisible();
        this.tabAreaComponentsPanel.revalidate();
    }

    public boolean isTabAreaComponentsVisible() {
        return this.tabAreaComponentsPanel.isVisible();
    }

    public JComponent[] getTabAreaComponents() {
        return this.tabAreaComponents == null ? null : (JComponent[])this.tabAreaComponents.clone();
    }

    public void addTabListener(TabListener tabListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(tabListener);
    }

    public void removeTabListener(TabListener tabListener) {
        if (this.listeners != null) {
            this.listeners.remove(tabListener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    public TabbedPanelProperties getProperties() {
        return this.properties;
    }

    public boolean hasContentArea() {
        return this.contentPanel != null;
    }

    DraggableComponentBox getDraggableComponentBox() {
        return this.draggableComponentBox;
    }

    private void initialize(JComponent jComponent) {
        this.setLayout(new BorderLayout());
        this.shadowRepaintChecker = new ComponentPaintChecker(this);
        this.setOpaque(false);
        this.draggableComponentBox.setOuterParentArea(this.tabAreaContainer);
        this.tabAreaContainer.add(this.tabAreaComponentsPanel);
        this.tabAreaContainer.add(this.draggableComponentBox);
        this.contentPanel = jComponent;
        this.draggableComponentBox.addListener(this.draggableComponentBoxListener);
        if (jComponent != null) {
            this.componentsPanel.add((Component)jComponent, "Center");
        }
        this.add((Component)this.componentsPanel, "Center");
        this.updateAllDefaultValues();
        PropertyMapWeakListenerManager.addWeakTreeListener(this.properties.getMap(), this.propertyChangedListener);
    }

    private void updateTabDropDownList() {
        TabDropDownListVisiblePolicy tabDropDownListVisiblePolicy = this.properties.getTabDropDownListVisiblePolicy();
        TabLayoutPolicy tabLayoutPolicy = this.properties.getTabLayoutPolicy();
        if (tabDropDownListVisiblePolicy != this.listVisiblePolicy || tabLayoutPolicy != this.listTabLayoutPolicy) {
            if (this.dropDownList != null) {
                this.tabAreaComponentsPanel.remove(this.dropDownList);
                this.dropDownList.dispose();
                this.dropDownList = null;
            }
            if (tabDropDownListVisiblePolicy == TabDropDownListVisiblePolicy.MORE_THAN_ONE_TAB || tabDropDownListVisiblePolicy == TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE && tabLayoutPolicy == TabLayoutPolicy.SCROLLING) {
                this.dropDownList = new TabDropDownList(this, this.properties.getButtonProperties().getTabDropDownListButtonProperties().applyTo(this.properties.getButtonProperties().getTabDropDownListButtonProperties().getFactory().createButton(this)));
                this.tabAreaComponentsPanel.add((Component)this.dropDownList, this.scrollButtonBox == null ? 0 : 1);
                if (tabDropDownListVisiblePolicy == TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE) {
                    this.dropDownList.setVisible(false);
                }
            }
        }
        this.listVisiblePolicy = tabDropDownListVisiblePolicy;
        this.listTabLayoutPolicy = tabLayoutPolicy;
        if (this.dropDownList != null && !this.draggableComponentBox.isScrollEnabled() && this.listVisiblePolicy == TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE) {
            this.dropDownList.setVisible(false);
        }
        this.tabAreaComponentsPanel.revalidate();
    }

    private void updateAllTabsProperties() {
        Component[] componentArray = this.draggableComponentBox.getBoxComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            this.updateTabProperties((Tab)componentArray[i]);
        }
    }

    private void updateTabProperties(Tab tab) {
        tab.getDraggableComponent().setAbortDragKeyCode(this.properties.getAbortDragKey());
        tab.getDraggableComponent().setReorderEnabled(this.properties.getTabReorderEnabled());
        tab.getDraggableComponent().setSelectOnMousePress(this.properties.getTabSelectTrigger() == TabSelectTrigger.MOUSE_PRESS);
    }

    private void updateTabAreaComponentsPanel(Direction direction, int n, int n2) {
        ((DirectionLayout)this.tabAreaComponentsPanel.getLayout()).setDirection(direction);
    }

    private void updateShapedPanelProperties(ShapedPanel shapedPanel, ShapedPanelProperties shapedPanelProperties) {
        InternalPropertiesUtil.applyTo(shapedPanelProperties, shapedPanel, this.properties.getTabAreaOrientation().getNextCW());
    }

    private void setTabAreaLayoutConstraints(JComponent jComponent, int n, int n2, int n3, double d, double d2, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.fill = n3;
        this.constraints.weightx = d;
        this.constraints.weighty = d2;
        this.constraints.anchor = n4;
        this.tabAreaLayoutManager.setConstraints(jComponent, this.constraints);
    }

    private void doInsertTab(Tab tab, Point point, int n) {
        if (tab != null && !this.draggableComponentBox.containsDraggableComponent(tab.getDraggableComponent())) {
            tab.setTabbedPanel(this);
            if (point != null) {
                this.draggableComponentBox.insertDraggableComponent(tab.getDraggableComponent(), SwingUtilities.convertPoint(this, point, this.draggableComponentBox));
            } else {
                this.draggableComponentBox.insertDraggableComponent(tab.getDraggableComponent(), n);
            }
            this.updateTabProperties(tab);
            this.checkIfOnlyOneTab(true);
        }
    }

    private Tab findTab(DraggableComponent draggableComponent) {
        return draggableComponent == null ? null : (Tab)draggableComponent.getComponent();
    }

    private void checkIfOnlyOneTab(boolean bl) {
        if (this.getTabCount() == 1) {
            this.draggableComponentBox.setScrollEnabled(false);
            this.updateScrollButtons();
        } else if (bl && this.getTabCount() == 2) {
            this.draggableComponentBox.setScrollEnabled(this.properties.getTabLayoutPolicy() == TabLayoutPolicy.SCROLLING);
            this.updateScrollButtons();
            this.updateTabDropDownList();
        }
    }

    private void setTabAreaComponentsButtonsVisible() {
        if (this.scrollButtonBox != null) {
            boolean bl = false;
            bl = !this.tabAreaOrientation.isHorizontal() ? this.draggableComponentBox.getInnerSize().getWidth() > (double)this.calcScrollWidth() : this.draggableComponentBox.getInnerSize().getHeight() > (double)this.calcScrollHeight();
            this.scrollButtonBox.setVisible(bl);
            if (this.dropDownList != null && this.listVisiblePolicy == TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE) {
                this.dropDownList.setVisible(bl);
            }
            if (!bl) {
                this.scrollButtonBox.setButton1Enabled(false);
                this.scrollButtonBox.setButton2Enabled(true);
            }
        } else if (this.dropDownList != null && this.listVisiblePolicy == TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE) {
            this.dropDownList.setVisible(false);
        }
        this.tabAreaComponentsPanel.setVisible(ComponentUtil.hasVisibleChildren(this.tabAreaComponentsPanel));
    }

    private int calcScrollWidth() {
        int n;
        Insets insets = this.tabAreaComponentsPanel.getInsets();
        boolean bl = this.dropDownList != null && this.listVisiblePolicy == TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE;
        boolean bl2 = bl ? ComponentUtil.isOnlyVisibleComponents(new Component[]{this.scrollButtonBox, this.dropDownList}) : ComponentUtil.isOnlyVisibleComponent(this.scrollButtonBox);
        int n2 = n = this.tabAreaComponentsPanel.isVisible() && bl2 ? insets.left + insets.right : 0;
        int n3 = this.tabAreaComponentsPanel.isVisible() ? (int)this.tabAreaComponentsPanel.getPreferredSize().getWidth() - n - (this.scrollButtonBox.isVisible() ? this.scrollButtonBox.getWidth() + (bl ? this.dropDownList.getWidth() : 0) : 0) : 0;
        Insets insets2 = this.tabAreaContainer.getInsets();
        return this.tabAreaContainer.getWidth() - n3 - insets2.left - insets2.right;
    }

    private int calcScrollHeight() {
        int n;
        Insets insets = this.tabAreaComponentsPanel.getInsets();
        boolean bl = this.listVisiblePolicy == TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE;
        boolean bl2 = bl ? ComponentUtil.isOnlyVisibleComponents(new Component[]{this.scrollButtonBox, this.dropDownList}) : ComponentUtil.isOnlyVisibleComponent(this.scrollButtonBox);
        int n2 = n = this.tabAreaComponentsPanel.isVisible() && bl2 ? insets.top + insets.bottom : 0;
        int n3 = this.tabAreaComponentsPanel.isVisible() ? (int)this.tabAreaComponentsPanel.getPreferredSize().getHeight() - n - (this.scrollButtonBox.isVisible() ? this.scrollButtonBox.getHeight() + (bl ? this.dropDownList.getHeight() : 0) : 0) : 0;
        Insets insets2 = this.tabAreaContainer.getInsets();
        return this.tabAreaContainer.getHeight() - n3 - insets2.top - insets2.bottom;
    }

    private void updateScrollButtons() {
        ScrollButtonBox scrollButtonBox = this.scrollButtonBox;
        this.scrollButtonBox = this.draggableComponentBox.getScrollButtonBox();
        if (scrollButtonBox != this.scrollButtonBox) {
            if (scrollButtonBox != null) {
                this.tabAreaComponentsPanel.remove(scrollButtonBox);
            }
            if (this.scrollButtonBox != null) {
                this.scrollButtonBox.setButtons(this.properties.getButtonProperties().getScrollUpButtonProperties().applyTo(this.properties.getButtonProperties().getScrollUpButtonProperties().getFactory().createButton(this)), this.properties.getButtonProperties().getScrollDownButtonProperties().applyTo(this.properties.getButtonProperties().getScrollDownButtonProperties().getFactory().createButton(this)), this.properties.getButtonProperties().getScrollLeftButtonProperties().applyTo(this.properties.getButtonProperties().getScrollLeftButtonProperties().getFactory().createButton(this)), this.properties.getButtonProperties().getScrollRightButtonProperties().applyTo(this.properties.getButtonProperties().getScrollRightButtonProperties().getFactory().createButton(this)));
                this.scrollButtonBox.setVisible(false);
                this.tabAreaComponentsPanel.add((Component)this.scrollButtonBox, 0);
            }
            this.tabAreaComponentsPanel.revalidate();
        }
    }

    private void fireTabMoved(Tab tab) {
        if (this.listeners != null) {
            TabEvent tabEvent = new TabEvent(this, tab);
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabMoved(tabEvent);
            }
        }
    }

    private void fireDraggedEvent(Tab tab, MouseEvent mouseEvent) {
        if (this.listeners != null) {
            TabDragEvent tabDragEvent = new TabDragEvent((Object)this, EventUtil.convert(mouseEvent, tab));
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabDragged(tabDragEvent);
            }
        }
    }

    private void fireDroppedEvent(Tab tab, MouseEvent mouseEvent) {
        if (this.listeners != null) {
            TabDragEvent tabDragEvent = new TabDragEvent((Object)this, EventUtil.convert(mouseEvent, tab));
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabDropped(tabDragEvent);
            }
        }
    }

    private void fireNotDroppedEvent(Tab tab) {
        if (this.listeners != null) {
            TabEvent tabEvent = new TabEvent(this, tab);
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabDragAborted(tabEvent);
            }
        }
    }

    private void fireSelectedEvent(Tab tab, Tab tab2) {
        if (this.listeners != null) {
            int n;
            TabStateChangedEvent tabStateChangedEvent = new TabStateChangedEvent(this, this, tab2, tab2, tab);
            Object[] objectArray = this.listeners.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                ((TabListener)objectArray[n]).tabDeselected(tabStateChangedEvent);
            }
            tabStateChangedEvent = new TabStateChangedEvent(this, this, tab, tab2, tab);
            objectArray = this.listeners.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                ((TabListener)objectArray[n]).tabSelected(tabStateChangedEvent);
            }
        }
    }

    private void fireHighlightedEvent(Tab tab, Tab tab2) {
        if (this.listeners != null) {
            int n;
            TabStateChangedEvent tabStateChangedEvent = new TabStateChangedEvent(this, this, tab2, tab2, tab);
            Object[] objectArray = this.listeners.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                ((TabListener)objectArray[n]).tabDehighlighted(tabStateChangedEvent);
            }
            tabStateChangedEvent = new TabStateChangedEvent(this, this, tab, tab2, tab);
            objectArray = this.listeners.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                ((TabListener)objectArray[n]).tabHighlighted(tabStateChangedEvent);
            }
        }
    }

    private void fireAddedEvent(Tab tab) {
        if (this.listeners != null) {
            TabEvent tabEvent = new TabEvent(this, tab);
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabAdded(tabEvent);
            }
        }
    }

    private void fireRemovedEvent(Tab tab) {
        if (this.listeners != null) {
            TabRemovedEvent tabRemovedEvent = new TabRemovedEvent(this, tab, this);
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabRemoved(tabRemovedEvent);
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 504) {
            if (!this.mouseEntered) {
                this.mouseEntered = true;
                super.processMouseEvent(mouseEvent);
            }
        } else if (mouseEvent.getID() == 505) {
            if (!this.contains(mouseEvent.getPoint())) {
                this.mouseEntered = false;
                super.processMouseEvent(mouseEvent);
            }
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    void doProcessMouseEvent(MouseEvent mouseEvent) {
        this.processMouseEvent(SwingUtilities.convertMouseEvent((Component)mouseEvent.getSource(), mouseEvent, this));
    }

    void doProcessMouseMotionEvent(MouseEvent mouseEvent) {
        this.processMouseMotionEvent(SwingUtilities.convertMouseEvent((Component)mouseEvent.getSource(), mouseEvent, this));
    }

    private void updateShadow() {
        if (this.shadowRepaintChecker.isPaintingOk() && this.contentPanel != null && this.properties.getShadowEnabled()) {
            Point point = SwingUtilities.convertPoint(this.tabAreaContainer, new Point(0, 0), this);
            this.repaint(point.x, point.y, this.tabAreaContainer.getWidth() + this.shadowSize, this.tabAreaContainer.getHeight() + this.shadowSize);
        }
    }

    private void updatePanelOpaque() {
        if (!this.properties.getShadowEnabled() && this.properties.getTabAreaProperties().getShapedPanelProperties().getOpaque() && (this.contentPanel == null || this.properties.getContentPanelProperties().getShapedPanelProperties().getOpaque())) {
            BaseContainerUtil.setForcedOpaque(this.componentsPanel, true);
            this.setOpaque(true);
        } else {
            BaseContainerUtil.setForcedOpaque(this.componentsPanel, false);
            this.setOpaque(false);
        }
    }

    private class ShadowPanel
    extends HoverablePanel {
        ShadowPanel() {
            super(new BorderLayout(), TabbedPanel.this.properties.getHoverListener());
            this.setCursor(null);
        }

        public boolean contains(int n, int n2) {
            return TabbedPanel.this.properties.getShadowEnabled() ? this.doContains(n, n2) : super.contains(n, n2);
        }

        public boolean inside(int n, int n2) {
            return TabbedPanel.this.properties.getShadowEnabled() ? this.doContains(n, n2) : super.inside(n, n2);
        }

        private boolean doContains(int n, int n2) {
            Dimension dimension = DimensionUtil.getInnerDimension(this.getSize(), this.getInsets());
            return n >= 0 && n2 >= 0 && (double)n < dimension.getWidth() && (double)n2 < dimension.getHeight();
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (TabbedPanel.this.contentPanel == null || !TabbedPanel.this.properties.getShadowEnabled()) {
                return;
            }
            new ShadowPainter(this, TabbedPanel.this.componentsPanel, TabbedPanel.this.highlightedTab, TabbedPanel.this.contentPanel, TabbedPanel.this.tabAreaComponentsPanel, TabbedPanel.this.tabAreaContainer, TabbedPanel.this.draggableComponentBox, TabbedPanel.this.properties.getTabAreaOrientation(), TabbedPanel.this.properties.getPaintTabAreaShadow(), TabbedPanel.this.shadowSize, TabbedPanel.this.properties.getShadowBlendAreaSize(), TabbedPanel.this.properties.getShadowColor(), TabbedPanel.this.properties.getShadowStrength(), TabbedPanel.this.getTabIndex(TabbedPanel.this.getHighlightedTab()) == TabbedPanel.this.getTabCount() - 1).paint(graphics);
        }
    }

    private class HoverablePanel
    extends HoverableShapedPanel {
        public HoverablePanel(LayoutManager layoutManager, HoverListener hoverListener) {
            super(layoutManager, hoverListener, TabbedPanel.this);
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            TabbedPanel.this.doProcessMouseEvent(mouseEvent);
        }

        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            super.processMouseMotionEvent(mouseEvent);
            TabbedPanel.this.doProcessMouseMotionEvent(mouseEvent);
        }

        public boolean acceptHover(ArrayList arrayList) {
            return this.getHoverListener() == null ? false : TabbedHoverUtil.acceptTabbedPanelHover(TabbedPanel.this.properties.getHoverPolicy(), arrayList, TabbedPanel.this, this);
        }
    }
}

