/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.internal;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Polygon;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.UIManagerColorProvider;
import net.infonode.gui.shaped.border.AbstractPolygonBorder;

public class SlopedTabLineBorder
extends AbstractPolygonBorder {
    private static final long serialVersionUID = 1L;
    private static final int[][][] corners = new int[][][]{new int[][]{{0, 0}, {-1, 0, 0, -1}, {-2, 0, -1, -1, 0, -1}, {-4, 0, -3, -1, -2, -1, -1, -2, -1, -3, 0, -4}}, new int[][]{{0, 0}, {0, 0}, {0, 1, 1, 1, 2, 0}, {0, 4, 1, 3, 1, 2, 2, 1, 3, 1, 4, 0}}, new int[][]{{0, 0}, {0, 0}, {-2, 0, -1, 1, 0, 1}, {-4, 0, -3, 1, -2, 1, -1, 2, -1, 3, 0, 4}}, new int[][]{{0, 0}, {0, -1, 1, 0}, {0, -1, 1, -1, 2, 0}, {0, -4, 1, -3, 1, -2, 2, -1, 3, -1, 4, 0}}, new int[][]{{0, 0}, {0, 0}, {0, 2, 1, 1, 1, 0}, {0, 4, 1, 3, 1, 2, 2, 1, 3, 1, 4, 0}}, new int[][]{{0, 0}, {0, 0}, {-1, 0, -1, 1, 0, 2}, {-4, 0, -3, 1, -2, 1, -1, 2, -1, 3, 0, 4}}};
    private boolean drawBottomLine;
    private float leftSlope;
    private float rightSlope;
    private boolean bottomLeftRounded;
    private boolean topLeftRounded;
    private boolean topRightRounded;
    private boolean bottomRightRounded;
    private int leftHeight;
    private int rightHeight;
    private static int[] xCoords = new int[100];
    private static int[] yCoords = new int[100];
    private static int x;
    private static int y;
    private static int index;

    public SlopedTabLineBorder() {
        this(0.0f, 1.0f);
    }

    public SlopedTabLineBorder(float f, float f2) {
        this(f, f2, 22, 22);
    }

    public SlopedTabLineBorder(float f, float f2, int n, int n2) {
        this(f, f2, n, n2, false, false, false, false);
    }

    public SlopedTabLineBorder(float f, float f2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(f, f2, 22, 22, bl, bl2, bl3, bl4);
    }

    public SlopedTabLineBorder(float f, float f2, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(UIManagerColorProvider.TABBED_PANE_DARK_SHADOW, UIManagerColorProvider.TABBED_PANE_HIGHLIGHT, false, f, f2, n, n2, bl, bl2, bl3, bl4);
    }

    public SlopedTabLineBorder(ColorProvider colorProvider, ColorProvider colorProvider2, boolean bl, float f, float f2, int n, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        super(colorProvider, colorProvider2);
        this.drawBottomLine = bl;
        this.leftHeight = n;
        this.rightHeight = n2;
        this.leftSlope = f;
        this.rightSlope = f2;
        this.bottomLeftRounded = bl2;
        this.topLeftRounded = bl3;
        this.topRightRounded = bl4;
        this.bottomRightRounded = bl5;
    }

    protected boolean lineIsDrawn(int n, Polygon polygon) {
        return this.drawBottomLine || n < polygon.npoints - 1;
    }

    protected Insets getShapedBorderInsets(Component component) {
        return new Insets(1, (this.isBottomLeftRounded(component) ? 4 : 1) + (this.topLeftRounded ? (this.leftSlope <= 0.5f ? 4 : 1) : 0) + (int)(this.leftSlope * (float)this.leftHeight), this.drawBottomLine ? 1 : 0, (this.bottomRightRounded ? 4 : 1) + (this.topRightRounded ? (this.rightSlope <= 0.5f ? 4 : 1) : 0) + (int)(this.rightSlope * (float)this.rightHeight));
    }

    protected boolean isBottomLeftRounded(Component component) {
        return this.bottomLeftRounded;
    }

    private static int[] getCorner(int n, float f, boolean bl) {
        return corners[n][!bl ? 0 : (n < 4 ? (f >= 2.0f ? 1 : (f >= 1.0f ? 2 : 3)) : (f <= 0.5f ? 1 : (f <= 1.0f ? 2 : 3)))];
    }

    private static void addPoint(int n, int n2) {
        SlopedTabLineBorder.xCoords[SlopedTabLineBorder.index] = n;
        SlopedTabLineBorder.yCoords[SlopedTabLineBorder.index++] = n2;
        x = n;
        y = n2;
    }

    private static void addCorner(int n, int n2, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            SlopedTabLineBorder.addPoint(n + nArray[i++], n2 + nArray[i]);
        }
    }

    private static int getStartY(int[] nArray) {
        return nArray[1];
    }

    private static int getEndY(int[] nArray) {
        return nArray[nArray.length - 1];
    }

    protected Polygon createPolygon(Component component, int n, int n2) {
        boolean bl = this.isBottomLeftRounded(component);
        int n3 = (int)((float)this.leftHeight * this.leftSlope + (float)(bl ? 4 : 0));
        int n4 = n - 1 - (int)((float)this.rightHeight * this.rightSlope + (float)(this.bottomRightRounded ? 4 : 0));
        int n5 = n2 - (this.drawBottomLine ? 1 : 0);
        int[] nArray = SlopedTabLineBorder.getCorner(1, this.leftSlope, this.topLeftRounded);
        int[] nArray2 = SlopedTabLineBorder.getCorner(2, this.rightSlope, this.topRightRounded);
        int[] nArray3 = SlopedTabLineBorder.getCorner(0, this.leftSlope, bl);
        int[] nArray4 = SlopedTabLineBorder.getCorner(3, this.rightSlope, this.bottomRightRounded);
        index = 0;
        y = n5;
        int n6 = n2 - SlopedTabLineBorder.getStartY(nArray) + SlopedTabLineBorder.getEndY(nArray3);
        if (n6 <= this.leftHeight) {
            x = n3 - (int)((float)n6 * this.leftSlope);
            SlopedTabLineBorder.addCorner(x, y, nArray3);
        } else {
            x = n3 - (int)((float)this.leftHeight * this.leftSlope);
            SlopedTabLineBorder.addCorner(x, y, SlopedTabLineBorder.getCorner(0, 0.0f, bl));
            SlopedTabLineBorder.addPoint(x, SlopedTabLineBorder.getStartY(nArray) + this.leftHeight);
        }
        SlopedTabLineBorder.addCorner(n3, 0, nArray);
        SlopedTabLineBorder.addCorner(n4, 0, nArray2);
        n6 = n2 - SlopedTabLineBorder.getEndY(nArray2) + SlopedTabLineBorder.getStartY(nArray4);
        if (n6 <= this.rightHeight) {
            SlopedTabLineBorder.addCorner((int)((float)n4 + (float)n6 * this.rightSlope), n5, nArray4);
        } else {
            SlopedTabLineBorder.addPoint((int)((float)n4 + this.rightSlope * (float)this.rightHeight), SlopedTabLineBorder.getEndY(nArray2) + this.rightHeight);
            SlopedTabLineBorder.addCorner(x, n5, SlopedTabLineBorder.getCorner(3, 0.0f, this.bottomRightRounded));
        }
        return new Polygon(xCoords, yCoords, index);
    }
}

