/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.lingo.setup.panels;

import ja.lingo.setup.GuiHelper;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;

public class Panel1License extends JPanel {
    public Panel1License() {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setContentType( "text/html" );
        editorPane.setEditable( false );
        try {
            editorPane.setPage( GuiHelper.getResource( "license.html" ) );
        } catch ( IOException e ) {
            throw new RuntimeException( e );
        }

        final JScrollPane scroll = new JScrollPane( editorPane,
                JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                JScrollPane.HORIZONTAL_SCROLLBAR_NEVER );

        setLayout( new BorderLayout( GuiHelper.GAP, GuiHelper.GAP ) );
        add( new JLabel( "Press Page Down to see the rest of agreement." ), BorderLayout.NORTH );
        add( scroll, BorderLayout.CENTER );
        add( new JLabel(
                "<html>If you accept the terms of the agreement, click I Agree to continue.<br>\n" +
                " You must accept the agreement to install JaLingo.</html>" ), BorderLayout.SOUTH );

        addComponentListener( new ComponentAdapter() {
            public void componentShown( ComponentEvent e ) {
                scroll.requestFocus();
            }
        } );
    }
}