package ja.centre.gui.concurrent;

import junit.framework.TestCase;

import javax.swing.*;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

public class EdtWrapperTest extends TestCase {
    public void testWrapWait() throws Exception {
        Callable<String> delegate = new Callable<String>() {
            public String call() {
                assertTrue( SwingUtilities.isEventDispatchThread() );
                return "Gotcha!";
            }
        };

        Callable<String> proxy = (Callable<String>) EdtWrapper.waiting( delegate );

        assertEquals( "Gotcha!", proxy.call() );
    }

    public void testWrap() throws Exception {
        final AtomicBoolean finished = new AtomicBoolean();

        Callable<String> delegate = new Callable<String>() {
            public String call() {
                assertTrue( SwingUtilities.isEventDispatchThread() );
                finished.set( true );
                return "Gotcha!";
            }
        };

        Callable<String> proxy = (Callable<String>) EdtWrapper.nonWaiting( delegate );

        assertEquals( null, proxy.call() );

        // TODO fix busy waiting
        while ( true ) {
            if ( finished.get() ) {
                break;
            }
        }
    }
}
