/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.lingo.application.util.progress.engine;

import ja.lingo.application.util.progress.ITitledMonitor;

public class MockTitledMonitor implements ITitledMonitor {
    private int value;
    private int minimum;
    private int maximum;
    private String title;
    private String text;

    public void start( int minimum, int maximum ) {
        this.minimum = minimum;
        this.maximum = maximum;
    }
    public void update( int value ) {
        this.value = value;
    }
    public void finish() {
        this.value = maximum;
    }
    public void setTitle( String title ) {
        this.title = title;
    }
    public void setText( String text ) {
        this.text = text;
    }

    public int getValue() {
        return value;
    }
    public int getMinimum() {
        return minimum;
    }
    public int getMaximum() {
        return maximum;
    }
    public String getTitle() {
        return title;
    }
    public String getText() {
        return text;
    }
}
