/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.lingo.engine.dictionaryindex.builder;

import ja.lingo.engine.beans.IInfo;
import ja.lingo.engine.beans.Info;
import ja.lingo.engine.dictionaryindex.Token;
import ja.lingo.engine.dictionaryindex.reader.IIndexSource;
import ja.lingo.engine.dictionaryindex.reader.ITokenReader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MockDictionaryIndexBuilder implements IDictionaryIndexBuilder {
    private Info info;

    private IIndexSource indexSource;
    private Tokens titles;
    private Tokens bodies;

    public MockDictionaryIndexBuilder() {
        titles = new Tokens();
        bodies = new Tokens();

        indexSource = new IIndexSource() {
            public ITokenReader getTitlesTokenReader() {
                return titles;
            }
            public ITokenReader getBodiesTokenReader() {
                return bodies;
            }
            public void close() {
                // do nothing
            }
        };
    }

    public void addArticle( Token title, Token body ) throws IOException {
        titles.add( title );
        bodies.add( body );
    }

    public IInfo getInfo() {
        return info;
    }
    public void setInfo( IInfo info ) throws IOException {
        this.info = new Info( info );
    }

    public void close() throws IOException {
        if ( info != null ) {
        info.setIndexFileName( "index file name" );
        info.setCapacity( titles.size() );
    }
    }
    public IIndexSource getIndexSource() {
        return indexSource;
    }

    private static class Tokens implements ITokenReader {
        private List<Token> tokens;

        public Tokens() {
            this.tokens = new ArrayList<Token>();
        }

        public Token getToken( int index ) {
            return tokens.get( index );
        }
        public int getTokenStart( int index ) {
            return getToken( index ).getStart();
        }
        public int getTokenLength( int index ) {
            return getToken( index ).getLength();
        }
        public int size() {
            return tokens.size();
        }
        public void add( Token token ) {
            tokens.add( token );
        }
    }
}
