/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.lingo.setup;

import javax.swing.*;
import java.awt.*;
import java.net.URL;

public class GuiHelper {
    public static final String TITLE = "JaLingo Setup";
    public static final String RESOURCE_FRAME_ICON = "jalingo.png";
    public static final int GAP = 10;

    private GuiHelper() {
    }

    public static JPanel wrap( JComponent panel, Object constraints ) {
        JPanel newPanel = new JPanel( new BorderLayout() );
        newPanel.add( panel, constraints );
        return newPanel;
    }

    public static URL getResource( String fileName ) {
        URL resource = JaLingoSetup.class.getClassLoader().getResource( "resources/" + fileName );

        if ( resource == null ) {
            throw new RuntimeException( "Could not load resource \"" + fileName + "\"" );
        }

        return resource;
    }
}
