/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.centre.gui.actionbinder.examples;

import ja.centre.gui.actionbinder.config.NListener;
import ja.centre.gui.actionbinder.ActionBinder;

import javax.swing.*;
import java.awt.event.ActionListener;

/**
 * Example of binding with a boolean filter method
 */
public class Example2 {
    @NListener( type = ActionListener.class,
            mappings = "actionPerformed > askConfirmation> ok" )
    private JButton okButton = new JButton( "OK" );

    public Example2() {
        ActionBinder.bind( this );
    }

    public void ok() {
        System.out.println( "ok" );
    }

    public boolean askConfirmation() {
        return JOptionPane.showConfirmDialog( okButton, "Are you sure?", "Confirmation",
                JOptionPane.YES_NO_OPTION ) == JOptionPane.YES_OPTION;
    }

    public static void main( String[] args ) {
        JFrame frame = new JFrame( "Example2" );
        frame.setContentPane( new Example2().okButton );
        frame.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );
        frame.pack();
        frame.setLocationRelativeTo( null );
        frame.setVisible( true );
    }

}
