/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.lingo.application.util.misc;

import junit.framework.TestCase;

public class StringsTest extends TestCase {
    public void testEscapeHtml() throws Exception {
        assertEquals( "text", Strings.escapeHtml( "text" ) );
        assertEquals( "&amp;&quot;&lt;&gt;", Strings.escapeHtml( "&\"<>" ) );
        assertEquals( "&lt;html&gt;", Strings.escapeHtml( "<html>" ) );
    }

    public void testUnescapeSql() throws Exception {
        assertEquals( "'", Strings.unescapeSql( "\\'" ) );
        assertEquals( "\"", Strings.unescapeSql( "\\\"" ) );
        assertEquals( "\n", Strings.unescapeSql( "\\n" ) );
    }
}