/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.SimpleRenderedImage;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReadParamJava;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KReadState;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import jj2000.j2k.codestream.reader.HeaderDecoder;

public class J2KRenderedImage
extends SimpleRenderedImage {
    private Raster currentTile;
    private Point currentTileGrid;
    private J2KReadState readState;

    public J2KRenderedImage(ImageInputStream iis, J2KImageReadParamJava param, J2KMetadata metadata, J2KImageReader reader) throws IOException {
        this(new J2KReadState(iis, param, metadata, reader));
    }

    public J2KRenderedImage(ImageInputStream iis, J2KImageReadParamJava param, J2KImageReader reader) throws IOException {
        this(new J2KReadState(iis, param, reader));
    }

    public J2KRenderedImage(J2KReadState readState) {
        this.readState = readState;
        HeaderDecoder hd = readState.getHeader();
        Rectangle destinationRegion = readState.getDestinationRegion();
        this.width = destinationRegion.width;
        this.height = destinationRegion.height;
        this.minX = destinationRegion.x;
        this.minY = destinationRegion.y;
        this.tileWidth = hd.getNomTileWidth();
        this.tileHeight = hd.getNomTileHeight();
        Point tileOffset = hd.getTilingOrigin(null);
        this.tileGridXOffset = tileOffset.x;
        this.tileGridYOffset = tileOffset.y;
        this.sampleModel = readState.getSampleModel();
        this.colorModel = readState.getColorModel();
        this.tileGridXOffset += (this.XToTileX(this.minX) - this.XToTileX(this.tileGridXOffset)) * this.tileWidth;
        this.tileGridYOffset += (this.YToTileY(this.minY) - this.YToTileY(this.tileGridYOffset)) * this.tileHeight;
    }

    public synchronized Raster getTile(int tileX, int tileY) {
        if (this.currentTile != null && this.currentTileGrid.x == tileX && this.currentTileGrid.y == tileY) {
            return this.currentTile;
        }
        if (tileX >= this.getNumXTiles() || tileY >= this.getNumYTiles()) {
            throw new IllegalArgumentException(I18N.getString("J2KReadState1"));
        }
        try {
            int x = this.tileXToX(tileX);
            int y = this.tileYToY(tileY);
            this.currentTile = Raster.createWritableRaster(this.sampleModel, new Point(x, y));
            this.currentTile = this.readState.getTile(tileX, tileY, (WritableRaster)this.currentTile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.currentTileGrid == null) {
            this.currentTileGrid = new Point(tileX, tileY);
        } else {
            this.currentTileGrid.x = tileX;
            this.currentTileGrid.y = tileY;
        }
        return this.currentTile;
    }
}

