/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TIFFField {
    private static final String[] typeNames = new String[]{null, "Byte", "Ascii", "Short", "Long", "Rational", "SByte", "Undefined", "SShort", "SLong", "SRational", "Float", "Double", "IFDPointer"};
    private static final boolean[] isIntegral = new boolean[]{false, true, false, true, true, false, true, true, true, true, false, false, false, false};
    private TIFFTag tag;
    private int tagNumber;
    private int type;
    private int count;
    private Object data;

    private TIFFField() {
    }

    public TIFFField(TIFFTag tag, int type, int count, Object data) {
        this.tag = tag;
        this.tagNumber = tag.getNumber();
        this.type = type;
        this.count = count;
        this.data = data;
    }

    public TIFFField(TIFFTag tag, int type, int count) {
        this.tag = tag;
        this.tagNumber = tag.getNumber();
        this.type = type;
        this.count = count;
        this.data = TIFFField.createArrayForType(type, count);
    }

    public TIFFField(TIFFTag tag, int val) {
        if (val < 0) {
            throw new IllegalArgumentException("val < 0!");
        }
        this.tag = tag;
        this.tagNumber = tag.getNumber();
        this.count = 1;
        if (val < 65536) {
            this.type = 3;
            char[] cdata = new char[]{(char)val};
            this.data = cdata;
        } else {
            this.type = 4;
            long[] ldata = new long[]{val};
            this.data = ldata;
        }
    }

    private static String getAttribute(Node node, String attrName) {
        NamedNodeMap attrs = node.getAttributes();
        return attrs.getNamedItem(attrName).getNodeValue();
    }

    private static void initData(Node node, int[] otype, int[] ocount, Object[] odata) {
        Object data = null;
        String typeName = node.getNodeName();
        typeName = typeName.substring(4);
        int type = TIFFField.getTypeByName(typeName = typeName.substring(0, typeName.length() - 1));
        if (type == -1) {
            throw new IllegalArgumentException("typeName = " + typeName);
        }
        Node child = node.getFirstChild();
        int count = 0;
        while (child != null) {
            String childTypeName = child.getNodeName().substring(4);
            if (!typeName.equals(childTypeName)) {
                // empty if block
            }
            ++count;
            child = child.getNextSibling();
        }
        if (count > 0) {
            data = TIFFField.createArrayForType(type, count);
            child = node.getFirstChild();
            int idx = 0;
            while (child != null) {
                String value = TIFFField.getAttribute(child, "value");
                switch (type) {
                    case 2: {
                        ((String[])data)[idx] = value;
                        break;
                    }
                    case 1: 
                    case 6: {
                        ((byte[])data)[idx] = (byte)Integer.parseInt(value);
                        break;
                    }
                    case 3: {
                        ((char[])data)[idx] = (char)Integer.parseInt(value);
                        break;
                    }
                    case 8: {
                        ((short[])data)[idx] = (short)Integer.parseInt(value);
                        break;
                    }
                    case 9: {
                        ((int[])data)[idx] = Integer.parseInt(value);
                        break;
                    }
                    case 4: 
                    case 13: {
                        ((long[])data)[idx] = Long.parseLong(value);
                        break;
                    }
                    case 11: {
                        ((float[])data)[idx] = Float.parseFloat(value);
                        break;
                    }
                    case 12: {
                        ((double[])data)[idx] = Double.parseDouble(value);
                        break;
                    }
                    case 10: {
                        int slashPos = value.indexOf("/");
                        String numerator = value.substring(0, slashPos);
                        String denominator = value.substring(slashPos + 1);
                        ((int[][])data)[idx] = new int[2];
                        ((int[][])data)[idx][0] = Integer.parseInt(numerator);
                        ((int[][])data)[idx][1] = Integer.parseInt(denominator);
                        break;
                    }
                    case 5: {
                        int slashPos = value.indexOf("/");
                        String numerator = value.substring(0, slashPos);
                        String denominator = value.substring(slashPos + 1);
                        ((long[][])data)[idx] = new long[2];
                        ((long[][])data)[idx][0] = Long.parseLong(numerator);
                        ((long[][])data)[idx][1] = Long.parseLong(denominator);
                        break;
                    }
                }
                ++idx;
                child = child.getNextSibling();
            }
        }
        otype[0] = type;
        ocount[0] = count;
        odata[0] = data;
    }

    public TIFFField(TIFFTagSet tagSet, Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        String name = node.getNodeName();
        if (!name.equals("TIFFField")) {
            throw new IllegalArgumentException();
        }
        this.tagNumber = Integer.parseInt(TIFFField.getAttribute(node, "number"));
        this.tag = tagSet != null ? tagSet.getTag(this.tagNumber) : new TIFFTag("unknown", this.tagNumber, 0, null);
        Node child = node.getFirstChild();
        if (child != null) {
            String typeName = child.getNodeName();
            if (typeName.equals("TIFFUndefined")) {
                String values = TIFFField.getAttribute(child, "value");
                StringTokenizer st = new StringTokenizer(values, ",");
                this.count = st.countTokens();
                byte[] bdata = new byte[this.count];
                int i = 0;
                while (i < this.count) {
                    bdata[i] = (byte)Integer.parseInt(st.nextToken());
                    ++i;
                }
                this.type = 7;
                this.data = bdata;
            } else {
                int[] otype = new int[1];
                int[] ocount = new int[1];
                Object[] odata = new Object[1];
                TIFFField.initData(node.getFirstChild(), otype, ocount, odata);
                this.type = otype[0];
                this.count = ocount[0];
                this.data = odata[0];
            }
        }
    }

    public TIFFTag getTag() {
        return this.tag;
    }

    public int getTagNumber() {
        return this.tagNumber;
    }

    public int getType() {
        return this.type;
    }

    public static String getTypeName(int dataType) {
        if (dataType < 1 || dataType > 13) {
            throw new IllegalArgumentException();
        }
        return typeNames[dataType];
    }

    public static int getTypeByName(String typeName) {
        int i = 1;
        while (i <= 13) {
            if (typeName.equals(typeNames[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Object createArrayForType(int dataType, int count) {
        switch (dataType) {
            case 1: 
            case 6: 
            case 7: {
                return new byte[count];
            }
            case 2: {
                return new String[count];
            }
            case 3: {
                return new char[count];
            }
            case 4: 
            case 13: {
                return new long[count];
            }
            case 5: {
                return new long[count][2];
            }
            case 8: {
                return new short[count];
            }
            case 9: {
                return new int[count];
            }
            case 10: {
                return new int[count][2];
            }
            case 11: {
                return new float[count];
            }
            case 12: {
                return new double[count];
            }
        }
        throw new IllegalArgumentException();
    }

    public Node getNativeNode() {
        IIOMetadataNode child;
        IIOMetadataNode node = new IIOMetadataNode("TIFFField");
        node.setAttribute("number", Integer.toString(this.getTagNumber()));
        node.setAttribute("name", this.tag.getName());
        int count = this.getCount();
        if (this.tag.isIFDPointer() || count == 0) {
            return node;
        }
        if (this.getType() == 7) {
            child = new IIOMetadataNode("TIFFUndefined");
            byte[] data = this.getAsBytes();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < count) {
                sb.append(Integer.toString(data[i] & 0xFF));
                if (i < count - 1) {
                    sb.append(",");
                }
                ++i;
            }
            child.setAttribute("value", sb.toString());
        } else {
            child = new IIOMetadataNode("TIFF" + TIFFField.getTypeName(this.getType()) + "s");
            int i = 0;
            while (i < count) {
                int value;
                String name;
                IIOMetadataNode cchild = new IIOMetadataNode("TIFF" + TIFFField.getTypeName(this.getType()));
                cchild.setAttribute("value", this.getValueAsString(i));
                if (this.tag.hasValueNames() && this.isIntegral() && (name = this.tag.getValueName(value = this.getAsInt(i))) != null) {
                    cchild.setAttribute("description", name);
                }
                child.appendChild(cchild);
                ++i;
            }
        }
        node.appendChild(child);
        return node;
    }

    public boolean isIntegral() {
        return isIntegral[this.type];
    }

    public int getCount() {
        return this.count;
    }

    public Object getData() {
        return this.data;
    }

    public byte[] getAsBytes() {
        return (byte[])this.data;
    }

    public char[] getAsChars() {
        return (char[])this.data;
    }

    public short[] getAsShorts() {
        return (short[])this.data;
    }

    public int[] getAsInts() {
        if (this.data instanceof int[]) {
            return (int[])this.data;
        }
        if (this.data instanceof char[]) {
            char[] cdata = (char[])this.data;
            int[] idata = new int[cdata.length];
            int i = 0;
            while (i < cdata.length) {
                idata[i] = cdata[i] & 0xFFFF;
                ++i;
            }
            return idata;
        }
        if (this.data instanceof short[]) {
            short[] sdata = (short[])this.data;
            int[] idata = new int[sdata.length];
            int i = 0;
            while (i < sdata.length) {
                idata[i] = sdata[i];
                ++i;
            }
            return idata;
        }
        throw new ClassCastException("Data not char[], short[], or int[]!");
    }

    public long[] getAsLongs() {
        return (long[])this.data;
    }

    public float[] getAsFloats() {
        return (float[])this.data;
    }

    public double[] getAsDoubles() {
        return (double[])this.data;
    }

    public int[][] getAsSRationals() {
        return (int[][])this.data;
    }

    public long[][] getAsRationals() {
        return (long[][])this.data;
    }

    public int getAsInt(int index) {
        switch (this.type) {
            case 1: 
            case 7: {
                return ((byte[])this.data)[index] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[index];
            }
            case 3: {
                return ((char[])this.data)[index] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[index];
            }
            case 9: {
                return ((int[])this.data)[index];
            }
            case 4: 
            case 13: {
                return (int)((long[])this.data)[index];
            }
            case 11: {
                return (int)((float[])this.data)[index];
            }
            case 12: {
                return (int)((double[])this.data)[index];
            }
            case 10: {
                int[] ivalue = this.getAsSRational(index);
                return (int)((double)ivalue[0] / (double)ivalue[1]);
            }
            case 5: {
                long[] lvalue = this.getAsRational(index);
                return (int)((double)lvalue[0] / (double)lvalue[1]);
            }
            case 2: {
                String s = ((String[])this.data)[index];
                return (int)Double.parseDouble(s);
            }
        }
        throw new ClassCastException();
    }

    public long getAsLong(int index) {
        switch (this.type) {
            case 1: 
            case 7: {
                return ((byte[])this.data)[index] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[index];
            }
            case 3: {
                return ((char[])this.data)[index] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[index];
            }
            case 9: {
                return ((int[])this.data)[index];
            }
            case 4: 
            case 13: {
                return ((long[])this.data)[index];
            }
            case 10: {
                int[] ivalue = this.getAsSRational(index);
                return (long)((double)ivalue[0] / (double)ivalue[1]);
            }
            case 5: {
                long[] lvalue = this.getAsRational(index);
                return (long)((double)lvalue[0] / (double)lvalue[1]);
            }
            case 2: {
                String s = ((String[])this.data)[index];
                return (long)Double.parseDouble(s);
            }
        }
        throw new ClassCastException();
    }

    public float getAsFloat(int index) {
        switch (this.type) {
            case 1: 
            case 7: {
                return ((byte[])this.data)[index] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[index];
            }
            case 3: {
                return ((char[])this.data)[index] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[index];
            }
            case 9: {
                return ((int[])this.data)[index];
            }
            case 4: 
            case 13: {
                return ((long[])this.data)[index];
            }
            case 11: {
                return ((float[])this.data)[index];
            }
            case 12: {
                return (float)((double[])this.data)[index];
            }
            case 10: {
                int[] ivalue = this.getAsSRational(index);
                return (float)((double)ivalue[0] / (double)ivalue[1]);
            }
            case 5: {
                long[] lvalue = this.getAsRational(index);
                return (float)((double)lvalue[0] / (double)lvalue[1]);
            }
            case 2: {
                String s = ((String[])this.data)[index];
                return (float)Double.parseDouble(s);
            }
        }
        throw new ClassCastException();
    }

    public double getAsDouble(int index) {
        switch (this.type) {
            case 1: 
            case 7: {
                return ((byte[])this.data)[index] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[index];
            }
            case 3: {
                return ((char[])this.data)[index] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[index];
            }
            case 9: {
                return ((int[])this.data)[index];
            }
            case 4: 
            case 13: {
                return ((long[])this.data)[index];
            }
            case 11: {
                return ((float[])this.data)[index];
            }
            case 12: {
                return ((double[])this.data)[index];
            }
            case 10: {
                int[] ivalue = this.getAsSRational(index);
                return (double)ivalue[0] / (double)ivalue[1];
            }
            case 5: {
                long[] lvalue = this.getAsRational(index);
                return (double)lvalue[0] / (double)lvalue[1];
            }
            case 2: {
                String s = ((String[])this.data)[index];
                return Double.parseDouble(s);
            }
        }
        throw new ClassCastException();
    }

    public String getAsString(int index) {
        return ((String[])this.data)[index];
    }

    public int[] getAsSRational(int index) {
        return ((int[][])this.data)[index];
    }

    public long[] getAsRational(int index) {
        return ((long[][])this.data)[index];
    }

    public String getValueAsString(int index) {
        switch (this.type) {
            case 2: {
                return ((String[])this.data)[index];
            }
            case 1: 
            case 7: {
                return Integer.toString(((byte[])this.data)[index] & 0xFF);
            }
            case 6: {
                return Integer.toString(((byte[])this.data)[index]);
            }
            case 3: {
                return Integer.toString(((char[])this.data)[index] & 0xFFFF);
            }
            case 8: {
                return Integer.toString(((short[])this.data)[index]);
            }
            case 9: {
                return Integer.toString(((int[])this.data)[index]);
            }
            case 4: 
            case 13: {
                return Long.toString(((long[])this.data)[index]);
            }
            case 11: {
                return Float.toString(((float[])this.data)[index]);
            }
            case 12: {
                return Double.toString(((double[])this.data)[index]);
            }
            case 10: {
                int[] ivalue = this.getAsSRational(index);
                String srationalString = ivalue[1] != 0 && ivalue[0] % ivalue[1] == 0 ? Integer.toString(ivalue[0] / ivalue[1]) + "/1" : Integer.toString(ivalue[0]) + "/" + Integer.toString(ivalue[1]);
                return srationalString;
            }
            case 5: {
                long[] lvalue = this.getAsRational(index);
                String rationalString = lvalue[1] != 0L && lvalue[0] % lvalue[1] == 0L ? Long.toString(lvalue[0] / lvalue[1]) + "/1" : Long.toString(lvalue[0]) + "/" + Long.toString(lvalue[1]);
                return rationalString;
            }
        }
        throw new ClassCastException();
    }

    public void writeData(ImageOutputStream stream) throws IOException {
        switch (this.type) {
            case 2: {
                int i = 0;
                while (i < this.count) {
                    String s = ((String[])this.data)[i];
                    int length = s.length();
                    int j = 0;
                    while (j < length) {
                        stream.writeByte(s.charAt(j) & 0xFF);
                        ++j;
                    }
                    stream.writeByte(0);
                    ++i;
                }
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                stream.write((byte[])this.data);
                break;
            }
            case 3: {
                stream.writeChars((char[])this.data, 0, ((char[])this.data).length);
                break;
            }
            case 8: {
                stream.writeShorts((short[])this.data, 0, ((short[])this.data).length);
                break;
            }
            case 9: {
                stream.writeInts((int[])this.data, 0, ((int[])this.data).length);
                break;
            }
            case 4: {
                int i = 0;
                while (i < this.count) {
                    stream.writeInt((int)((long[])this.data)[i]);
                    ++i;
                }
                break;
            }
            case 13: {
                stream.writeInt(0);
                break;
            }
            case 11: {
                stream.writeFloats((float[])this.data, 0, ((float[])this.data).length);
                break;
            }
            case 12: {
                stream.writeDoubles((double[])this.data, 0, ((double[])this.data).length);
                break;
            }
            case 10: {
                int i = 0;
                while (i < this.count) {
                    stream.writeInt(((int[][])this.data)[i][0]);
                    stream.writeInt(((int[][])this.data)[i][1]);
                    ++i;
                }
                break;
            }
            case 5: {
                int i = 0;
                while (i < this.count) {
                    long num = ((long[][])this.data)[i][0];
                    long den = ((long[][])this.data)[i][1];
                    stream.writeInt((int)num);
                    stream.writeInt((int)den);
                    ++i;
                }
                break;
            }
        }
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        int oTagNumber = ((TIFFField)o).getTagNumber();
        if (this.tagNumber < oTagNumber) {
            return -1;
        }
        if (this.tagNumber > oTagNumber) {
            return 1;
        }
        return 0;
    }
}

