/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.media.jai.JAI;
import org.jpedal.PdfDecoder;
import org.jpedal.io.JAIHelper;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.utils.LogWriter;

public class ExtractPagesAsThumbnails {
    private String user_dir = System.getProperty("user.dir");
    private int dpi = 72;
    public static boolean outputMessages = false;
    public static boolean multipleSizes = true;
    String output_dir = "";
    String separator = System.getProperty("file.separator");
    PdfDecoder decode_pdf = null;
    private static String format = "png";
    private String[] ocr = new String[]{"TeleForm"};
    private boolean useHiresImage = false;
    private static String test_file = "/mnt/shared/sample_pdfs/general/World Factbook.pdf";
    public static boolean isTest = false;
    private static int scaling = 100;

    private ExtractPagesAsThumbnails() {
    }

    public ExtractPagesAsThumbnails(String string, String string2) {
        String string3 = System.getProperty("org.jpedal.dpi");
        if (string3 != null) {
            try {
                this.dpi = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                System.err.println("Problem with value " + string3 + " (must be integer)");
                System.err.println(exception);
                System.exit(1);
            }
        }
        String string4 = System.getProperty("org.jpedal.hires");
        if (PdfDecoder.hires || string4 != null) {
            this.useHiresImage = true;
        }
        this.output_dir = string2;
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = this.user_dir + this.separator;
        }
        if (string.toLowerCase().endsWith(".pdf")) {
            if (!isTest) {
                string2 = this.user_dir + "thumbnails" + this.separator;
            }
            this.decodeFile(string, string2);
        } else {
            String[] stringArray = null;
            File file = null;
            if (!string.endsWith(this.separator)) {
                string = string + this.separator;
            }
            try {
                file = new File(string);
                if (!file.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                }
                stringArray = file.list();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
            }
            long l = stringArray.length;
            int n = 0;
            while ((long)n < l) {
                if (stringArray[n].toLowerCase().endsWith(".pdf")) {
                    if (outputMessages) {
                        System.out.println(string + stringArray[n]);
                    }
                    this.decodeFile(string + stringArray[n], string2);
                }
                ++n;
            }
        }
        if (outputMessages) {
            System.out.println("Thumbnails created");
        }
    }

    private void decodeFile(String string, String string2) {
        Object object;
        String string3 = "demo";
        int n = string.lastIndexOf(this.separator);
        if (n == -1) {
            n = string.lastIndexOf(47);
        }
        if (n != -1) {
            string3 = string.substring(n + 1, string.length() - 4);
        } else if (!isTest && string.toLowerCase().endsWith(".pdf")) {
            string3 = string.substring(0, string.length() - 4);
        }
        if (string2 == null) {
            string2 = this.user_dir + "thumbnails" + this.separator;
        }
        try {
            this.decode_pdf = new PdfDecoder(true);
            if (!isTest) {
                object = new String[]{"helvetica", "arial"};
                this.decode_pdf.setSubstitutedFontAliases("arial", (String[])object);
                String[] stringArray = new String[]{"Helvetica-Bold"};
                this.decode_pdf.setSubstitutedFontAliases("Arial-BoldMT", stringArray);
                String[] stringArray2 = new String[]{"Times-Bold", "Times-Roman"};
                this.decode_pdf.setSubstitutedFontAliases("timesbd", stringArray2);
                PdfDecoder.setFontDirs(new String[]{"C:/windows/fonts/", "C:/winNT/fonts/", "/System/Library/Fonts/", "/Library/Fonts/"});
            }
            if (this.useHiresImage) {
                this.decode_pdf.useHiResScreenDisplay(true);
            }
            this.decode_pdf.setExtractionMode(0, this.dpi, this.dpi / 72);
            if (outputMessages) {
                System.out.println("Opening file :" + string + " at " + this.dpi + " dpi");
            }
            this.decode_pdf.openPdfFile(string);
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " in pdf code");
        }
        if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied() && !this.decode_pdf.isExtractionAllowed()) {
            if (outputMessages) {
                System.out.println("Encrypted settings");
                System.out.println("Please look at SimpleViewer for code sample to handle such files");
            }
        } else {
            object = new File(string2);
            if (!((File)object).exists()) {
                ((File)object).mkdirs();
            }
            int n2 = 1;
            int n3 = this.decode_pdf.getPageCount();
            if (n3 > 10 && isTest) {
                n3 = 10;
            }
            if (outputMessages) {
                System.out.println("Thumbnails will be in  " + string2);
            }
            try {
                for (int i = n2; i < n3 + 1; ++i) {
                    if (outputMessages) {
                        System.out.println("Page " + i);
                    }
                    String string4 = string3 + '_' + this.dpi + "_page_" + i;
                    PdfFileInformation pdfFileInformation = this.decode_pdf.getFileInformationData();
                    String[] stringArray = pdfFileInformation.getFieldValues();
                    String[] stringArray3 = pdfFileInformation.getFieldNames();
                    for (int j = 0; j < stringArray3.length; ++j) {
                        if (!stringArray3[j].equals("Creator")) continue;
                        for (int k = 0; k < this.ocr.length; ++k) {
                            if (!stringArray[j].equals(this.ocr[k])) continue;
                            this.decode_pdf.setRenderMode(2);
                            this.decode_pdf.setEnableLegacyJPEGConversion(true);
                        }
                    }
                    BufferedImage bufferedImage = this.decode_pdf.getPageAsImage(i);
                    if (bufferedImage == null) {
                        if (outputMessages) {
                            System.out.println("No image generated - are you using client mode?");
                        }
                    } else {
                        String string5;
                        Object object2;
                        Object object3;
                        int n4;
                        String string6 = System.getProperty("maxDimension");
                        int n5 = -1;
                        if (string6 != null) {
                            n5 = Integer.parseInt(string6);
                        }
                        if (scaling != 100 || n5 != -1) {
                            int n6 = bufferedImage.getWidth() * scaling / 100;
                            n4 = bufferedImage.getHeight() * scaling / 100;
                            object3 = null;
                            if (n5 != -1 && (n6 > n5 || n4 > n5)) {
                                if (n6 > n4) {
                                    n6 = n5;
                                    object3 = bufferedImage.getScaledInstance(n6, -1, 4);
                                } else {
                                    n4 = n5;
                                    object3 = bufferedImage.getScaledInstance(-1, n4, 4);
                                }
                            } else {
                                object3 = bufferedImage.getScaledInstance(n6, -1, 4);
                            }
                            bufferedImage = format.toLowerCase().startsWith("jp") ? new BufferedImage(((Image)object3).getWidth(null), ((Image)object3).getHeight(null), 1) : new BufferedImage(((Image)object3).getWidth(null), ((Image)object3).getHeight(null), 2);
                            object2 = bufferedImage.createGraphics();
                            ((Graphics)object2).drawImage((Image)object3, 0, 0, null);
                        }
                        int n7 = n4 = (string5 = System.getProperty("org.jpedal.compress_tiff")) != null ? 1 : 0;
                        if (JAIHelper.isJAIused()) {
                            JAIHelper.confirmJAIOnClasspath();
                        }
                        if (n4 != 0 && JAIHelper.isJAIused()) {
                            object3 = null;
                            object3 = new TIFFEncodeParam();
                            object3.setCompression(32946);
                            object2 = new FileOutputStream(string2 + i + string4 + ".tif");
                            JAI.create((String)"encode", (RenderedImage)bufferedImage, (Object)object2, (Object)"TIFF", (Object)object3);
                        } else {
                            boolean bl = this.decode_pdf.getObjectStore().saveStoredImage(string2 + i + string4, bufferedImage, true, false, format);
                        }
                    }
                    this.decode_pdf.flushObjectValues(true);
                }
            }
            catch (Exception exception) {
                this.decode_pdf.closePdfFile();
                System.err.println("Exception " + exception.getMessage() + " with thumbnails");
            }
        }
        this.decode_pdf.closePdfFile();
    }

    public static void main(String[] stringArray) {
        File file;
        System.out.println("Simple demo to extract images from a page");
        String string = test_file;
        boolean bl = false;
        int n = stringArray.length;
        if (n == 0) {
            ExtractPagesAsThumbnails.showCommandLineValues();
        } else if (n == 1) {
            string = stringArray[0];
            System.out.println("file name=" + string);
        } else if (n < 4) {
            string = stringArray[0];
            System.out.println("File :" + string);
            for (int i = 1; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                boolean bl2 = ExtractPagesAsThumbnails.isNumber(string2);
                if (bl2) {
                    try {
                        scaling = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        System.out.println(string2 + " is not an integer");
                        System.exit(1);
                    }
                    continue;
                }
                String string3 = string2.toLowerCase();
                if (string3.equals("jpg") | string3.equals("jpeg")) {
                    format = "jpg";
                    continue;
                }
                if (string3.equals("tif") | string3.equals("tiff")) {
                    format = "tif";
                    continue;
                }
                if (string3.equals("png")) {
                    format = "png";
                    continue;
                }
                bl = true;
                System.out.println("value args not recognised as valid parameter.");
                System.out.println("please enter \"jpg\", \"jpeg\", \"tif\", \"tiff\" or \"png\".");
            }
        } else {
            bl = true;
            System.out.println("too many arguments entered - run with no values to see defaults");
        }
        if (bl) {
            String string4 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string4 = string4 + stringArray[i] + '\n';
            }
            System.out.println("you entered:\n" + string4 + "as the arguments");
            ExtractPagesAsThumbnails.showCommandLineValues();
        }
        if (!(file = new File(string)).exists()) {
            System.out.println("File " + file + " not found");
            System.out.println("MAy need full path");
            return;
        }
        ExtractPagesAsThumbnails extractPagesAsThumbnails = new ExtractPagesAsThumbnails(string, null);
    }

    private static void showCommandLineValues() {
        System.out.println("Example can take 1, 2 or 3 parameters");
        System.out.println("Value 1 is the file name or directory of PDF files to process");
        System.out.println("2 optional values of image type (jpeg,tiff,png) and scaling (100 = full size) can also be added");
        System.exit(1);
    }

    private static boolean isNumber(String string) {
        boolean bl = true;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!(c < '0' | c > '9')) continue;
            bl = false;
            i = n;
        }
        return bl;
    }

    public String getOutputDir() {
        return this.output_dir;
    }
}

