/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.base.JRBaseDataRange;
import net.sf.jasperreports.charts.base.JRBaseValueDisplay;
import net.sf.jasperreports.charts.type.MeterShapeEnum;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.base.JRBaseChartPlot;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public class JRBaseMeterPlot
extends JRBaseChartPlot
implements JRMeterPlot {
    private static final long serialVersionUID = 10200L;
    protected JRDataRange dataRange;
    protected JRValueDisplay valueDisplay;
    protected MeterShapeEnum shapeValue;
    protected List intervals = new ArrayList();
    protected Integer meterAngleInteger;
    protected String units;
    protected Double tickIntervalDouble;
    protected Color meterBackgroundColor;
    protected Color needleColor;
    protected Color tickColor;
    protected JRFont tickLabelFont;
    private int PSEUDO_SERIAL_VERSION_UID = 30705;
    private byte shape = MeterShapeEnum.PIE.getValue();
    private int meterAngle = 180;
    private double tickInterval = 10.0;
    private Byte shapeByte;

    public JRBaseMeterPlot(JRChartPlot plot, JRChart chart) {
        super(plot, chart);
        JRMeterPlot meterPlot;
        JRMeterPlot jRMeterPlot = meterPlot = plot instanceof JRMeterPlot ? (JRMeterPlot)plot : null;
        if (meterPlot == null) {
            this.valueDisplay = new JRBaseValueDisplay(null, chart);
            this.tickLabelFont = new JRBaseFont(chart, null);
        } else {
            this.valueDisplay = new JRBaseValueDisplay(meterPlot.getValueDisplay(), chart);
            this.tickLabelFont = new JRBaseFont(chart, meterPlot.getTickLabelFont());
        }
    }

    public JRBaseMeterPlot(JRMeterPlot meterPlot, JRBaseObjectFactory factory) {
        super((JRChartPlot)meterPlot, factory);
        this.dataRange = new JRBaseDataRange(meterPlot.getDataRange(), factory);
        this.valueDisplay = new JRBaseValueDisplay(meterPlot.getValueDisplay(), factory);
        this.shapeValue = meterPlot.getShapeValue();
        List origIntervals = meterPlot.getIntervals();
        this.intervals.clear();
        if (origIntervals != null) {
            for (JRMeterInterval interval : origIntervals) {
                this.intervals.add(new JRMeterInterval(interval, factory));
            }
        }
        this.meterAngleInteger = meterPlot.getMeterAngleInteger();
        this.units = meterPlot.getUnits();
        this.tickIntervalDouble = meterPlot.getTickIntervalDouble();
        this.meterBackgroundColor = meterPlot.getMeterBackgroundColor();
        this.needleColor = meterPlot.getNeedleColor();
        this.tickColor = meterPlot.getTickColor();
        this.tickLabelFont = new JRBaseFont(this.getChart(), meterPlot.getTickLabelFont());
    }

    public JRDataRange getDataRange() {
        return this.dataRange;
    }

    public JRValueDisplay getValueDisplay() {
        return this.valueDisplay;
    }

    public byte getShape() {
        return this.getShapeValue() == null ? MeterShapeEnum.PIE.getValue() : this.getShapeValue().getValue();
    }

    public Byte getShapeByte() {
        return this.getShapeValue() == null ? null : this.getShapeValue().getValueByte();
    }

    public MeterShapeEnum getShapeValue() {
        return this.shapeValue;
    }

    public List getIntervals() {
        return this.intervals;
    }

    public int getMeterAngle() {
        return this.meterAngleInteger == null ? 180 : this.meterAngleInteger;
    }

    public Integer getMeterAngleInteger() {
        return this.meterAngleInteger;
    }

    public String getUnits() {
        return this.units;
    }

    public double getTickInterval() {
        return this.tickIntervalDouble == null ? 10.0 : this.tickIntervalDouble;
    }

    public Double getTickIntervalDouble() {
        return this.tickIntervalDouble;
    }

    public Color getMeterBackgroundColor() {
        return this.meterBackgroundColor;
    }

    public Color getNeedleColor() {
        return this.needleColor;
    }

    public Color getTickColor() {
        return this.tickColor;
    }

    public JRFont getTickLabelFont() {
        return this.tickLabelFont;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public Object clone(JRChart parentChart) {
        JRBaseMeterPlot clone = (JRBaseMeterPlot)super.clone(parentChart);
        if (this.dataRange != null) {
            clone.dataRange = (JRDataRange)this.dataRange.clone();
        }
        if (this.valueDisplay != null) {
            clone.valueDisplay = (JRValueDisplay)this.valueDisplay.clone();
        }
        if (this.intervals != null) {
            clone.intervals = new ArrayList(this.intervals.size());
            for (int i = 0; i < this.intervals.size(); ++i) {
                clone.intervals.add(((JRMeterInterval)this.intervals.get(i)).clone());
            }
        }
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            if (this.PSEUDO_SERIAL_VERSION_UID < 30103) {
                this.shapeValue = MeterShapeEnum.getByValue(this.shape);
                this.meterAngleInteger = this.meterAngle;
                this.tickIntervalDouble = this.tickInterval;
            } else {
                this.shapeValue = MeterShapeEnum.getByValue(this.shapeByte);
                this.shapeByte = null;
            }
        }
    }
}

