/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.concurrent;

import java.io.IOException;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.security.concurrent.ConcurrentSessionFilter;
import org.springframework.security.concurrent.SessionRegistry;
import org.springframework.security.concurrent.SessionRegistryImpl;

public class ConcurrentSessionFilterTests
extends TestCase {
    public ConcurrentSessionFilterTests(String arg0) {
        super(arg0);
    }

    private void executeFilterInContainerSimulator(FilterConfig filterConfig, Filter filter, ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filter.init(filterConfig);
        filter.doFilter(request, response, filterChain);
        filter.destroy();
    }

    public void testDetectsExpiredSessions() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpSession session = new MockHttpSession();
        request.setSession((HttpSession)session);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(false);
        ConcurrentSessionFilter filter = new ConcurrentSessionFilter();
        SessionRegistryImpl registry = new SessionRegistryImpl();
        registry.registerNewSession(session.getId(), (Object)"principal");
        registry.getSessionInformation(session.getId()).expireNow();
        filter.setSessionRegistry((SessionRegistry)registry);
        filter.setExpiredUrl("/expired.jsp");
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        ConcurrentSessionFilterTests.assertEquals((String)"/expired.jsp", (String)response.getRedirectedUrl());
    }

    public void testReturnsExpectedMessageWhenNoExpiredUrlSet() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpSession session = new MockHttpSession();
        request.setSession((HttpSession)session);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(false);
        ConcurrentSessionFilter filter = new ConcurrentSessionFilter();
        SessionRegistryImpl registry = new SessionRegistryImpl();
        registry.registerNewSession(session.getId(), (Object)"principal");
        registry.getSessionInformation(session.getId()).expireNow();
        filter.setSessionRegistry((SessionRegistry)registry);
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        ConcurrentSessionFilterTests.assertEquals((String)"This session has been expired (possibly due to multiple concurrent logins being attempted as the same user).", (String)response.getContentAsString());
    }

    public void testDetectsMissingSessionRegistry() throws Exception {
        ConcurrentSessionFilter filter = new ConcurrentSessionFilter();
        filter.setExpiredUrl("xcx");
        try {
            filter.afterPropertiesSet();
            ConcurrentSessionFilterTests.fail((String)"Should have thrown IAE");
        }
        catch (IllegalArgumentException expected) {
            ConcurrentSessionFilterTests.assertTrue((boolean)true);
        }
    }

    public void testUpdatesLastRequestTime() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpSession session = new MockHttpSession();
        request.setSession((HttpSession)session);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        ConcurrentSessionFilter filter = new ConcurrentSessionFilter();
        SessionRegistryImpl registry = new SessionRegistryImpl();
        registry.registerNewSession(session.getId(), (Object)"principal");
        Date lastRequest = registry.getSessionInformation(session.getId()).getLastRequest();
        filter.setSessionRegistry((SessionRegistry)registry);
        filter.setExpiredUrl("/expired.jsp");
        Thread.sleep(1000L);
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        ConcurrentSessionFilterTests.assertTrue((boolean)registry.getSessionInformation(session.getId()).getLastRequest().after(lastRequest));
    }

    private class MockFilterChain
    implements FilterChain {
        private boolean expectToProceed;

        public MockFilterChain(boolean expectToProceed) {
            this.expectToProceed = expectToProceed;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.expectToProceed) {
                Assert.assertTrue((boolean)true);
            } else {
                Assert.fail((String)"Did not expect filter chain to proceed");
            }
        }
    }
}

