/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.firewall;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.firewall.RequestWrapper;

public class RequestWrapperTests {
    private static Map<String, String> testPaths = new LinkedHashMap<String, String>();

    @BeforeClass
    public static void createTestMap() {
        testPaths.put("/path1;x=y;z=w/path2;x=y/path3;x=y", "/path1/path2/path3");
        testPaths.put("/path1;x=y/path2;x=y/", "/path1/path2/");
        testPaths.put("/path1//path2/", "/path1/path2/");
        testPaths.put("//path1/path2//", "/path1/path2/");
        testPaths.put(";x=y;z=w", "");
    }

    @Test
    public void pathParametersAreRemovedFromServletPath() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        for (Map.Entry<String, String> entry : testPaths.entrySet()) {
            String path = entry.getKey();
            String expectedResult = entry.getValue();
            request.setServletPath(path);
            RequestWrapper wrapper = new RequestWrapper((HttpServletRequest)request);
            Assert.assertEquals((Object)expectedResult, (Object)wrapper.getServletPath());
            wrapper.reset();
            Assert.assertEquals((Object)path, (Object)wrapper.getServletPath());
        }
    }

    @Test
    public void pathParametersAreRemovedFromPathInfo() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        for (Map.Entry<String, String> entry : testPaths.entrySet()) {
            String path = entry.getKey();
            String expectedResult = entry.getValue();
            if (expectedResult.length() == 0) {
                expectedResult = null;
            }
            request.setPathInfo(path);
            RequestWrapper wrapper = new RequestWrapper((HttpServletRequest)request);
            Assert.assertEquals((Object)expectedResult, (Object)wrapper.getPathInfo());
            wrapper.reset();
            Assert.assertEquals((Object)path, (Object)wrapper.getPathInfo());
        }
    }
}

