/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.encoding;

import junit.framework.TestCase;
import org.springframework.security.providers.encoding.Md4PasswordEncoder;

public class Md4PasswordEncoderTests
extends TestCase {
    public void testEncodeUnsaltedPassword() {
        Md4PasswordEncoder md4 = new Md4PasswordEncoder();
        md4.setEncodeHashAsBase64(true);
        String encodedPassword = md4.encodePassword("ww_uni123", null);
        Md4PasswordEncoderTests.assertEquals((String)"8zobtq72iAt0W6KNqavGwg==", (String)encodedPassword);
    }

    public void testEncodeSaltedPassword() {
        Md4PasswordEncoder md4 = new Md4PasswordEncoder();
        md4.setEncodeHashAsBase64(true);
        String encodedPassword = md4.encodePassword("ww_uni123", (Object)"Alan K Stewart");
        Md4PasswordEncoderTests.assertEquals((String)"ZplT6P5Kv6Rlu6W4FIoYNA==", (String)encodedPassword);
    }

    public void testEncodeNullPassword() {
        Md4PasswordEncoder md4 = new Md4PasswordEncoder();
        md4.setEncodeHashAsBase64(true);
        String encodedPassword = md4.encodePassword(null, null);
        Md4PasswordEncoderTests.assertEquals((String)"MdbP4NFq6TG3PFnX4MCJwA==", (String)encodedPassword);
    }

    public void testEncodeEmptyPassword() {
        Md4PasswordEncoder md4 = new Md4PasswordEncoder();
        md4.setEncodeHashAsBase64(true);
        String encodedPassword = md4.encodePassword("", null);
        Md4PasswordEncoderTests.assertEquals((String)"MdbP4NFq6TG3PFnX4MCJwA==", (String)encodedPassword);
    }

    public void testNonAsciiPasswordHasCorrectHash() {
        Md4PasswordEncoder md4 = new Md4PasswordEncoder();
        String encodedPassword = md4.encodePassword("\u4f60\u597d", null);
        Md4PasswordEncoderTests.assertEquals((String)"a7f1196539fd1f85f754ffd185b16e6e", (String)encodedPassword);
    }

    public void testIsHexPasswordValid() {
        Md4PasswordEncoder md4 = new Md4PasswordEncoder();
        Md4PasswordEncoderTests.assertTrue((boolean)md4.isPasswordValid("31d6cfe0d16ae931b73c59d7e0c089c0", "", null));
    }

    public void testIsPasswordValid() {
        Md4PasswordEncoder md4 = new Md4PasswordEncoder();
        md4.setEncodeHashAsBase64(true);
        Md4PasswordEncoderTests.assertTrue((boolean)md4.isPasswordValid("8zobtq72iAt0W6KNqavGwg==", "ww_uni123", null));
    }

    public void testIsSaltedPasswordValid() {
        Md4PasswordEncoder md4 = new Md4PasswordEncoder();
        md4.setEncodeHashAsBase64(true);
        Md4PasswordEncoderTests.assertTrue((boolean)md4.isPasswordValid("ZplT6P5Kv6Rlu6W4FIoYNA==", "ww_uni123", (Object)"Alan K Stewart"));
    }
}

