/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.AccountExpiredException;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.MockAuthenticationManager;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.ui.AbstractProcessingFilter;
import org.springframework.security.ui.TargetUrlResolver;
import org.springframework.security.ui.TargetUrlResolverImpl;
import org.springframework.security.ui.rememberme.NullRememberMeServices;
import org.springframework.security.ui.rememberme.RememberMeServices;
import org.springframework.security.ui.rememberme.TokenBasedRememberMeServices;
import org.springframework.security.ui.savedrequest.SavedRequest;
import org.springframework.security.util.PortResolver;
import org.springframework.security.util.PortResolverImpl;

public class AbstractProcessingFilterTests
extends TestCase {
    public AbstractProcessingFilterTests() {
    }

    public AbstractProcessingFilterTests(String arg0) {
        super(arg0);
    }

    private MockHttpServletRequest createMockRequest() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/j_mock_post");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setRequestURI("/mycontext/j_mock_post");
        request.setContextPath("/mycontext");
        return request;
    }

    private void executeFilterInContainerSimulator(FilterConfig filterConfig, Filter filter, ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filter.init(filterConfig);
        filter.doFilter(request, response, filterChain);
        filter.destroy();
    }

    private SavedRequest makeSavedRequestForUrl() {
        MockHttpServletRequest request = this.createMockRequest();
        request.setMethod("GET");
        request.setServletPath("/some_protected_file.html");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setRequestURI("/mycontext/some_protected_file.html");
        return new SavedRequest((HttpServletRequest)request, (PortResolver)new PortResolverImpl());
    }

    private SavedRequest makePostSavedRequestForUrl() {
        MockHttpServletRequest request = this.createMockRequest();
        request.setServletPath("/some_protected_file.html");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setRequestURI("/mycontext/post/some_protected_file.html");
        request.setMethod("POST");
        return new SavedRequest((HttpServletRequest)request, (PortResolver)new PortResolverImpl());
    }

    protected void setUp() throws Exception {
        super.setUp();
        SecurityContextHolder.clearContext();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SecurityContextHolder.clearContext();
    }

    public void testDefaultProcessesFilterUrlMatchesWithPathParameter() {
        MockHttpServletRequest request = this.createMockRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter();
        filter.setFilterProcessesUrl("/j_spring_security_check");
        request.setRequestURI("/mycontext/j_spring_security_check;jsessionid=I8MIONOSTHOR");
        AbstractProcessingFilterTests.assertTrue((boolean)filter.requiresAuthentication((HttpServletRequest)request, (HttpServletResponse)response));
    }

    public void testFailedAuthenticationRedirectsAppropriately() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(false);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(false);
        filter.setAuthenticationFailureUrl("/failed.jsp");
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertEquals((String)"/mycontext/failed.jsp", (String)response.getRedirectedUrl());
        AbstractProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        filter = new MockAbstractProcessingFilter((AuthenticationException)((Object)new AccountExpiredException("You're account is expired")));
        filter.setAuthenticationFailureUrl("/failed.jsp");
        Properties exceptionMappings = filter.getExceptionMappings();
        exceptionMappings.setProperty(AccountExpiredException.class.getName(), "/accountExpired.jsp");
        filter.setExceptionMappings(exceptionMappings);
        response = new MockHttpServletResponse();
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertEquals((String)"/mycontext/accountExpired.jsp", (String)response.getRedirectedUrl());
        AbstractProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testFilterProcessesUrlVariationsRespected() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        request.setServletPath("/j_OTHER_LOCATION");
        request.setRequestURI("/mycontext/j_OTHER_LOCATION");
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(false);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(true);
        filter.setFilterProcessesUrl("/j_OTHER_LOCATION");
        filter.setDefaultTargetUrl("/logged_in.jsp");
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertEquals((String)"/mycontext/logged_in.jsp", (String)response.getRedirectedUrl());
        AbstractProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        AbstractProcessingFilterTests.assertEquals((String)"test", (String)SecurityContextHolder.getContext().getAuthentication().getPrincipal().toString());
    }

    public void testGettersSetters() throws Exception {
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        filter.setDefaultTargetUrl("/default");
        filter.setFilterProcessesUrl("/p");
        filter.setAuthenticationFailureUrl("/fail");
        filter.afterPropertiesSet();
        AbstractProcessingFilterTests.assertNotNull((Object)filter.getRememberMeServices());
        filter.setRememberMeServices((RememberMeServices)new TokenBasedRememberMeServices());
        AbstractProcessingFilterTests.assertEquals(TokenBasedRememberMeServices.class, filter.getRememberMeServices().getClass());
        AbstractProcessingFilterTests.assertTrue((filter.getAuthenticationManager() != null ? 1 : 0) != 0);
        AbstractProcessingFilterTests.assertEquals((String)"/default", (String)filter.getDefaultTargetUrl());
        AbstractProcessingFilterTests.assertEquals((String)"/p", (String)filter.getFilterProcessesUrl());
        AbstractProcessingFilterTests.assertEquals((String)"/fail", (String)filter.getAuthenticationFailureUrl());
    }

    public void testDefaultUrlMuststartWithSlashOrHttpScheme() {
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter();
        filter.setDefaultTargetUrl("/acceptableRelativeUrl");
        filter.setDefaultTargetUrl("http://some.site.org/index.html");
        filter.setDefaultTargetUrl("https://some.site.org/index.html");
        try {
            filter.setDefaultTargetUrl("missingSlash");
            AbstractProcessingFilterTests.fail((String)"Shouldn't accept default target without leading slash");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIgnoresAnyServletPathOtherThanFilterProcessesUrl() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        request.setServletPath("/some.file.html");
        request.setRequestURI("/mycontext/some.file.html");
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(false);
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
    }

    public void testNormalOperationWithDefaultFilterProcessesUrl() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        HttpSession sessionPreAuth = request.getSession();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(false);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(true);
        filter.setFilterProcessesUrl("/j_mock_post");
        filter.setDefaultTargetUrl("/logged_in.jsp");
        filter.setAuthenticationFailureUrl("/failure.jsp");
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(true));
        filter.afterPropertiesSet();
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertEquals((String)"/mycontext/logged_in.jsp", (String)response.getRedirectedUrl());
        AbstractProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        AbstractProcessingFilterTests.assertEquals((String)"test", (String)SecurityContextHolder.getContext().getAuthentication().getPrincipal().toString());
        AbstractProcessingFilterTests.assertEquals((Object)sessionPreAuth, (Object)request.getSession());
    }

    public void testStartupDetectsInvalidAuthenticationManager() throws Exception {
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter();
        filter.setAuthenticationFailureUrl("/failed.jsp");
        filter.setDefaultTargetUrl("/");
        filter.setFilterProcessesUrl("/j_spring_security_check");
        try {
            filter.afterPropertiesSet();
            AbstractProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractProcessingFilterTests.assertEquals((String)"authenticationManager must be specified", (String)expected.getMessage());
        }
    }

    public void testStartupDetectsInvalidDefaultTargetUrl() throws Exception {
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter();
        filter.setAuthenticationFailureUrl("/failed.jsp");
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        filter.setFilterProcessesUrl("/j_spring_security_check");
        try {
            filter.afterPropertiesSet();
            AbstractProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractProcessingFilterTests.assertEquals((String)"defaultTargetUrl must be specified", (String)expected.getMessage());
        }
    }

    public void testStartupDetectsInvalidFilterProcessesUrl() throws Exception {
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter();
        filter.setAuthenticationFailureUrl("/failed.jsp");
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        filter.setDefaultTargetUrl("/");
        filter.setFilterProcessesUrl(null);
        try {
            filter.afterPropertiesSet();
            AbstractProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractProcessingFilterTests.assertEquals((String)"filterProcessesUrl must be specified", (String)expected.getMessage());
        }
    }

    public void testSuccessLoginThenFailureLoginResultsInSessionLosingToken() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(false);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(true);
        filter.setFilterProcessesUrl("/j_mock_post");
        filter.setDefaultTargetUrl("/logged_in.jsp");
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertEquals((String)"/mycontext/logged_in.jsp", (String)response.getRedirectedUrl());
        AbstractProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        AbstractProcessingFilterTests.assertEquals((String)"test", (String)SecurityContextHolder.getContext().getAuthentication().getPrincipal().toString());
        chain = new MockFilterChain(false);
        response = new MockHttpServletResponse();
        filter = new MockAbstractProcessingFilter(false);
        filter.setFilterProcessesUrl("/j_mock_post");
        filter.setAuthenticationFailureUrl("/failed.jsp");
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testSuccessfulAuthenticationButWithAlwaysUseDefaultTargetUrlCausesRedirectToDefaultTargetUrl() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        request.getSession().setAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY", (Object)this.makeSavedRequestForUrl());
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(true);
        filter.setFilterProcessesUrl("/j_mock_post");
        filter.setDefaultTargetUrl("/foobar");
        AbstractProcessingFilterTests.assertFalse((boolean)filter.isAlwaysUseDefaultTargetUrl());
        filter.setAlwaysUseDefaultTargetUrl(true);
        AbstractProcessingFilterTests.assertTrue((boolean)filter.isAlwaysUseDefaultTargetUrl());
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertEquals((String)"/mycontext/foobar", (String)response.getRedirectedUrl());
        AbstractProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testSuccessfulAuthenticationCausesRedirectToSessionSpecifiedUrl() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        request.getSession().setAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY", (Object)this.makeSavedRequestForUrl());
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(true);
        filter.setFilterProcessesUrl("/j_mock_post");
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertEquals((String)this.makeSavedRequestForUrl().getFullRequestUrl(), (String)response.getRedirectedUrl());
        AbstractProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testSuccessfulAuthenticationCausesRedirectToDefaultTargetUrlOnPOSTSavedRequest() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        request.getSession().setAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY", (Object)this.makePostSavedRequestForUrl());
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(true);
        filter.setFilterProcessesUrl("/j_mock_post");
        filter.setDefaultTargetUrl("/foobar");
        TargetUrlResolverImpl targetUrlResolver = new TargetUrlResolverImpl();
        targetUrlResolver.setJustUseSavedRequestOnGet(true);
        filter.setTargetUrlResolver((TargetUrlResolver)targetUrlResolver);
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertEquals((String)"/mycontext/foobar", (String)response.getRedirectedUrl());
        AbstractProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testFullDefaultTargetUrlDoesNotHaveContextPathPrepended() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(true);
        filter.setDefaultTargetUrl("https://monkeymachine.co.uk/");
        filter.setAlwaysUseDefaultTargetUrl(true);
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertEquals((String)"https://monkeymachine.co.uk/", (String)response.getRedirectedUrl());
        AbstractProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testNewSessionIsCreatedIfInvalidateSessionOnSuccessfulAuthenticationIsSet() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        HttpSession oldSession = request.getSession();
        oldSession.setAttribute("test", (Object)"test");
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(true);
        filter.setInvalidateSessionOnSuccessfulAuthentication(true);
        filter.setDefaultTargetUrl("http://monkeymachine.co.uk/");
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        HttpSession newSession = request.getSession();
        AbstractProcessingFilterTests.assertFalse((boolean)newSession.getId().equals(oldSession.getId()));
        AbstractProcessingFilterTests.assertEquals((Object)"test", (Object)newSession.getAttribute("test"));
    }

    public void testAttributesAreNotMigratedToNewlyCreatedSessionIfMigrateAttributesIsFalse() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        HttpSession oldSession = request.getSession();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(true);
        filter.setInvalidateSessionOnSuccessfulAuthentication(true);
        filter.setMigrateInvalidatedSessionAttributes(false);
        filter.setDefaultTargetUrl("http://monkeymachine.co.uk/");
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        HttpSession newSession = request.getSession();
        AbstractProcessingFilterTests.assertFalse((boolean)newSession.getId().equals(oldSession.getId()));
        AbstractProcessingFilterTests.assertNull((Object)newSession.getAttribute("test"));
    }

    public void testNoSessionIsCreatedIfAllowSessionCreationIsFalse() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(false);
        filter.setAllowSessionCreation(false);
        filter.setAuthenticationFailureUrl("/");
        filter.setDefaultTargetUrl("http://monkeymachine.co.uk/");
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertNull((Object)request.getSession(false));
    }

    public void testLoginErrorWithNoFailureUrlSendsUnauthorizedStatus() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(false);
        filter.setDefaultTargetUrl("http://monkeymachine.co.uk/");
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertEquals((int)401, (int)response.getStatus());
    }

    public void testServerSideRedirectForwardsToFailureUrl() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(false);
        filter.setDefaultTargetUrl("http://monkeymachine.co.uk/");
        filter.setAuthenticationFailureUrl("/error");
        filter.setServerSideRedirect(true);
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertEquals((String)"/error", (String)response.getForwardedUrl());
    }

    public void testTargetUrlParameterIsUsedIfPresent() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        request.setParameter("targetUrl", "/target");
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(true);
        TargetUrlResolverImpl targetUrlResolver = new TargetUrlResolverImpl();
        targetUrlResolver.setTargetUrlParameter("targetUrl");
        filter.setTargetUrlResolver((TargetUrlResolver)targetUrlResolver);
        filter.setDefaultTargetUrl("http://monkeymachine.co.uk/");
        filter.setAuthenticationFailureUrl("/error");
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertEquals((String)"/mycontext/target", (String)response.getRedirectedUrl());
    }

    private class MockFilterChain
    implements FilterChain {
        private boolean expectToProceed;

        public MockFilterChain(boolean expectToProceed) {
            this.expectToProceed = expectToProceed;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.expectToProceed) {
                Assert.assertTrue((boolean)true);
            } else {
                Assert.fail((String)"Did not expect filter chain to proceed");
            }
        }
    }

    private class MockAbstractProcessingFilter
    extends AbstractProcessingFilter {
        private AuthenticationException exceptionToThrow;
        private boolean grantAccess;

        public MockAbstractProcessingFilter(boolean grantAccess) {
            this.setRememberMeServices((RememberMeServices)new NullRememberMeServices());
            this.grantAccess = grantAccess;
            this.exceptionToThrow = new BadCredentialsException("Mock requested to do so");
        }

        public MockAbstractProcessingFilter(AuthenticationException exceptionToThrow) {
            this.setRememberMeServices((RememberMeServices)new NullRememberMeServices());
            this.grantAccess = false;
            this.exceptionToThrow = exceptionToThrow;
        }

        private MockAbstractProcessingFilter() {
        }

        public Authentication attemptAuthentication(HttpServletRequest request) throws AuthenticationException {
            if (this.grantAccess) {
                return new UsernamePasswordAuthenticationToken((Object)"test", (Object)"test", new GrantedAuthority[]{new GrantedAuthorityImpl("TEST")});
            }
            throw this.exceptionToThrow;
        }

        public String getDefaultFilterProcessesUrl() {
            return "/j_mock_post";
        }

        public boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
            return super.requiresAuthentication(request, response);
        }

        public int getOrder() {
            return 0;
        }
    }
}

