/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.preauth;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.MockAuthenticationManager;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.ui.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.util.MockFilterChain;

public class AbstractPreAuthenticatedProcessingFilterTests {
    private AbstractPreAuthenticatedProcessingFilter filter;

    @Before
    public void createFilter() {
        this.filter = new AbstractPreAuthenticatedProcessingFilter(){

            protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
                return "n/a";
            }

            protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
                return "doesntmatter";
            }

            public int getOrder() {
                return 0;
            }
        };
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    @Test
    public void filterChainProceedsOnFailedAuthenticationByDefault() throws Exception {
        this.filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(false));
        this.filter.afterPropertiesSet();
        this.filter.doFilter((ServletRequest)new MockHttpServletRequest(), (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain(true));
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    @Test(expected=BadCredentialsException.class)
    public void exceptionIsThrownOnFailedAuthenticationIfContinueFilterChainOnUnsuccessfulAuthenticationSetToFalse() throws Exception {
        this.filter.setContinueFilterChainOnUnsuccessfulAuthentication(false);
        this.filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(false));
        this.filter.afterPropertiesSet();
        this.filter.doFilter((ServletRequest)new MockHttpServletRequest(), (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain(false));
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }
}

