/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.memory;

import java.util.Properties;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.security.userdetails.memory.InMemoryDaoImpl;
import org.springframework.security.userdetails.memory.UserMap;
import org.springframework.security.userdetails.memory.UserMapEditor;

public class InMemoryDaoTests
extends TestCase {
    public InMemoryDaoTests() {
    }

    public InMemoryDaoTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(InMemoryDaoTests.class);
    }

    private UserMap makeUserMap() {
        UserMapEditor editor = new UserMapEditor();
        editor.setAsText("rod=koala,ROLE_ONE,ROLE_TWO,enabled\r\nscott=wombat,ROLE_ONE,ROLE_TWO,enabled");
        return (UserMap)editor.getValue();
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testLookupFails() throws Exception {
        InMemoryDaoImpl dao = new InMemoryDaoImpl();
        dao.setUserMap(this.makeUserMap());
        dao.afterPropertiesSet();
        try {
            dao.loadUserByUsername("UNKNOWN_USER");
            InMemoryDaoTests.fail((String)"Should have thrown UsernameNotFoundException");
        }
        catch (UsernameNotFoundException expected) {
            InMemoryDaoTests.assertTrue((boolean)true);
        }
    }

    public void testLookupSuccess() throws Exception {
        InMemoryDaoImpl dao = new InMemoryDaoImpl();
        dao.setUserMap(this.makeUserMap());
        dao.afterPropertiesSet();
        InMemoryDaoTests.assertEquals((String)"koala", (String)dao.loadUserByUsername("rod").getPassword());
        InMemoryDaoTests.assertEquals((String)"wombat", (String)dao.loadUserByUsername("scott").getPassword());
    }

    public void testLookupSuccessWithMixedCase() throws Exception {
        InMemoryDaoImpl dao = new InMemoryDaoImpl();
        dao.setUserMap(this.makeUserMap());
        dao.afterPropertiesSet();
        InMemoryDaoTests.assertEquals((String)"koala", (String)dao.loadUserByUsername("rod").getPassword());
        InMemoryDaoTests.assertEquals((String)"wombat", (String)dao.loadUserByUsername("ScOTt").getPassword());
    }

    public void testStartupFailsIfUserMapNotSet() throws Exception {
        InMemoryDaoImpl dao = new InMemoryDaoImpl();
        try {
            dao.afterPropertiesSet();
            InMemoryDaoTests.fail((String)"Shoudl have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            InMemoryDaoTests.assertTrue((boolean)true);
        }
    }

    public void testStartupFailsIfUserMapSetToNull() throws Exception {
        InMemoryDaoImpl dao = new InMemoryDaoImpl();
        dao.setUserMap(null);
        try {
            dao.afterPropertiesSet();
            InMemoryDaoTests.fail((String)"Shoudl have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            InMemoryDaoTests.assertTrue((boolean)true);
        }
    }

    public void testStartupSuccessIfUserMapSet() throws Exception {
        InMemoryDaoImpl dao = new InMemoryDaoImpl();
        dao.setUserMap(this.makeUserMap());
        dao.afterPropertiesSet();
        InMemoryDaoTests.assertEquals((int)2, (int)dao.getUserMap().getUserCount());
    }

    public void testUseOfExternalPropertiesObject() throws Exception {
        InMemoryDaoImpl dao = new InMemoryDaoImpl();
        Properties props = new Properties();
        props.put("rod", "koala,ROLE_ONE,ROLE_TWO,enabled");
        props.put("scott", "wombat,ROLE_ONE,ROLE_TWO,enabled");
        dao.setUserProperties(props);
        InMemoryDaoTests.assertEquals((String)"koala", (String)dao.loadUserByUsername("rod").getPassword());
        InMemoryDaoTests.assertEquals((String)"wombat", (String)dao.loadUserByUsername("scott").getPassword());
    }
}

