/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.vote;

import java.util.List;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.vote.SampleBlockOfData;
import org.springframework.security.vote.SampleService;
import org.springframework.test.AbstractDependencyInjectionSpringContextTests;

public class LabelBasedAclVoterTests
extends AbstractDependencyInjectionSpringContextTests {
    private SampleService sampleService = null;

    protected String[] getConfigLocations() {
        return new String[]{"org/springframework/security/vote/labelBasedSecurityApplicationContext.xml"};
    }

    public SampleService getSampleService() {
        return this.sampleService;
    }

    public void setSampleService(SampleService sampleService) {
        this.sampleService = sampleService;
    }

    private void setupContext(String username, String password) {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        AuthenticationManager authenticationManager = (AuthenticationManager)this.applicationContext.getBean("authenticationManager");
        SecurityContextHolder.getContext().setAuthentication(authenticationManager.authenticate((Authentication)token));
    }

    public void testDoingSomethingForBlueUser() {
        this.setupContext("blueuser", "password");
        List dataList = this.sampleService.getTheSampleData();
        LabelBasedAclVoterTests.assertNotNull((Object)dataList);
        SampleBlockOfData block1 = (SampleBlockOfData)dataList.get(0);
        SampleBlockOfData block2 = (SampleBlockOfData)dataList.get(1);
        SampleBlockOfData block3 = (SampleBlockOfData)dataList.get(2);
        this.sampleService.doSomethingOnThis(block1, block1);
        try {
            this.sampleService.doSomethingOnThis(block2, block2);
            LabelBasedAclVoterTests.fail((String)"Expected an AccessDeniedException");
        }
        catch (AccessDeniedException e) {
        }
        catch (RuntimeException e) {
            LabelBasedAclVoterTests.fail((String)"Expected an AccessDeniedException");
        }
        try {
            this.sampleService.doSomethingOnThis(block1, block2);
            LabelBasedAclVoterTests.fail((String)"Expected an AccessDeniedException");
        }
        catch (AccessDeniedException e) {
        }
        catch (RuntimeException e) {
            LabelBasedAclVoterTests.fail((String)"Expected an AccessDeniedException");
        }
        try {
            this.sampleService.doSomethingOnThis(block2, block1);
            LabelBasedAclVoterTests.fail((String)"Expected an AccessDeniedException");
        }
        catch (AccessDeniedException e) {
        }
        catch (RuntimeException e) {
            LabelBasedAclVoterTests.fail((String)"Expected an AccessDeniedException");
        }
        this.sampleService.doSomethingOnThis(block3, block3);
    }

    public void testDoingSomethingForMultiUser() {
        this.setupContext("multiuser", "password4");
        List dataList = this.sampleService.getTheSampleData();
        LabelBasedAclVoterTests.assertNotNull((Object)dataList);
        SampleBlockOfData block1 = (SampleBlockOfData)dataList.get(0);
        SampleBlockOfData block2 = (SampleBlockOfData)dataList.get(1);
        SampleBlockOfData block3 = (SampleBlockOfData)dataList.get(2);
        this.sampleService.doSomethingOnThis(block1, block1);
        this.sampleService.doSomethingOnThis(block2, block2);
        this.sampleService.doSomethingOnThis(block1, block2);
        this.sampleService.doSomethingOnThis(block2, block1);
        this.sampleService.doSomethingOnThis(block3, block3);
    }

    public void testDoingSomethingForOrangeUser() {
        this.setupContext("orangeuser", "password3");
        List dataList = this.sampleService.getTheSampleData();
        LabelBasedAclVoterTests.assertNotNull((Object)dataList);
        SampleBlockOfData block1 = (SampleBlockOfData)dataList.get(0);
        SampleBlockOfData block2 = (SampleBlockOfData)dataList.get(1);
        SampleBlockOfData block3 = (SampleBlockOfData)dataList.get(2);
        this.sampleService.doSomethingOnThis(block2, block2);
        try {
            this.sampleService.doSomethingOnThis(block1, block1);
            LabelBasedAclVoterTests.fail((String)"Expected an AccessDeniedException");
        }
        catch (AccessDeniedException e) {
        }
        catch (RuntimeException e) {
            LabelBasedAclVoterTests.fail((String)"Expected an AccessDeniedException");
        }
        try {
            this.sampleService.doSomethingOnThis(block1, block2);
            LabelBasedAclVoterTests.fail((String)"Expected an AccessDeniedException");
        }
        catch (AccessDeniedException e) {
        }
        catch (RuntimeException e) {
            LabelBasedAclVoterTests.fail((String)"Expected an AccessDeniedException");
        }
        try {
            this.sampleService.doSomethingOnThis(block2, block1);
            LabelBasedAclVoterTests.fail((String)"Expected an AccessDeniedException");
        }
        catch (AccessDeniedException e) {
        }
        catch (RuntimeException e) {
            LabelBasedAclVoterTests.fail((String)"Expected an AccessDeniedException");
        }
        this.sampleService.doSomethingOnThis(block3, block3);
    }

    public void testDoingSomethingForSuperUser() {
        this.setupContext("superuser", "password2");
        List dataList = this.sampleService.getTheSampleData();
        LabelBasedAclVoterTests.assertNotNull((Object)dataList);
        SampleBlockOfData block1 = (SampleBlockOfData)dataList.get(0);
        SampleBlockOfData block2 = (SampleBlockOfData)dataList.get(1);
        SampleBlockOfData block3 = (SampleBlockOfData)dataList.get(2);
        this.sampleService.doSomethingOnThis(block1, block1);
        this.sampleService.doSomethingOnThis(block2, block2);
        this.sampleService.doSomethingOnThis(block1, block2);
        this.sampleService.doSomethingOnThis(block2, block1);
        this.sampleService.doSomethingOnThis(block3, block3);
    }

    public void testSampleBlockOfDataPOJO() {
        SampleBlockOfData block = new SampleBlockOfData();
        block.setId("ID-ABC");
        LabelBasedAclVoterTests.assertEquals((String)block.getId(), (String)"ID-ABC");
    }
}

