/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.controller;

import com.tonbeller.wcf.controller.Controller;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestFilter;
import com.tonbeller.wcf.controller.RequestListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class WcfController
extends Controller {
    private static Logger logger = Logger.getLogger(WcfController.class);
    private List requestListeners = new LinkedList();
    private static final String WEBKEY = WcfController.class.getName() + ".dispatcher";

    WcfController() {
    }

    public static Controller instance(HttpSession session) {
        WcfController ctrl = (WcfController)session.getAttribute(WEBKEY);
        if (ctrl == null) {
            ctrl = new WcfController();
            session.setAttribute(WEBKEY, (Object)ctrl);
        }
        return ctrl;
    }

    public void addRequestListener(RequestListener l) {
        this.requestListeners.add(l);
    }

    public void removeRequestListener(RequestListener l) {
        this.requestListeners.remove(l);
    }

    public void setNextView(String uri) {
        RequestContext context = RequestContext.instance();
        context.getRequest().setAttribute(RequestFilter.NEXTVIEW, (Object)uri);
    }

    public String getNextView() {
        RequestContext context = RequestContext.instance();
        return (String)context.getRequest().getAttribute(RequestFilter.NEXTVIEW);
    }

    public void request(RequestContext context) throws Exception {
        ArrayList list = new ArrayList(this.requestListeners);
        for (RequestListener l : list) {
            l.request(context);
        }
    }

    public List getRootListeners() {
        return Collections.unmodifiableList(this.requestListeners);
    }
}

