/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.servlet.ServletContext;

public class ResourceLocator {
    private static final String WEBKEY = ResourceLocator.class.getName();
    private Hashtable urlCache = new Hashtable();

    private ResourceLocator() {
    }

    static ResourceLocator instance(ServletContext context) {
        ResourceLocator loc = (ResourceLocator)context.getAttribute(WEBKEY);
        if (loc == null) {
            loc = new ResourceLocator();
            context.setAttribute(WEBKEY, (Object)loc);
        }
        return loc;
    }

    public static URL getResource(ServletContext context, Locale locale, String uri) throws MalformedURLException, MissingResourceException {
        return ResourceLocator.instance(context).findResource(context, locale, uri);
    }

    URL findResource(ServletContext context, Locale locale, String path) throws MalformedURLException, MissingResourceException {
        String test1;
        String ext = "";
        if (path.lastIndexOf("/") < path.lastIndexOf(46)) {
            int pos = path.lastIndexOf(46);
            ext = path.substring(pos, path.length());
            path = path.substring(0, pos);
        }
        if (this.urlCache.containsKey(test1 = path + "_" + locale.getLanguage() + "_" + locale.getCountry() + ext)) {
            return (URL)this.urlCache.get(test1);
        }
        URL url = context.getResource(test1);
        if (url != null) {
            this.urlCache.put(test1, url);
            return url;
        }
        String test = path + "_" + locale.getLanguage() + ext;
        url = context.getResource(test);
        if (url != null) {
            this.urlCache.put(test1, url);
            return url;
        }
        test = path + ext;
        url = context.getResource(test);
        if (url != null) {
            this.urlCache.put(test1, url);
            return url;
        }
        throw new MissingResourceException("Resource \"" + path + "\" not found", ResourceLocator.class.getName(), path + ext);
    }
}

